/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VClassWebappWithInstancesListingController
extends BaseEditController {
    private int NUM_COLS = 6;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vrequest = new VitroRequest(request);
        String uriStr = request.getParameter("uri");
        ArrayList<String> results = new ArrayList<String>();
        if (uriStr != null) {
            VClassDao dao = vrequest.getUnfilteredWebappDaoFactory().getVClassDao();
            results.add("XX");
            results.add("name");
            results.add("group");
            results.add("example");
            results.add("last modified");
            results.add("XX");
            VClass vcw = dao.getVClassByURI(uriStr);
            if (vcw != null) {
                results.add("XX");
                String nameStr = vcw.getName() == null ? "" : vcw.getName();
                results.add(nameStr);
                String groupStr = "";
                results.add(groupStr);
                String exampleStr = vcw.getExample() == null ? "" : vcw.getExample();
                results.add(exampleStr);
                String lastModifiedStr = "";
                results.add(lastModifiedStr);
                results.add("XX");
                IndividualDao ewDao = vrequest.getUnfilteredWebappDaoFactory().getIndividualDao();
                List<Individual> ents = ewDao.getIndividualsByVClassURI(vcw.getURI(), -2, -2);
                if (ents != null && ents.size() > 0) {
                    results.add("+");
                    results.add("XX");
                    results.add("Class");
                    results.add("example");
                    results.add("description");
                    results.add("@@entities");
                    Iterator<Individual> entIt = ents.iterator();
                    int maxEnts = 25;
                    while (entIt.hasNext() && maxEnts > 0) {
                        --maxEnts;
                        Individual ew = entIt.next();
                        results.add("XX");
                        if (ew.getName() != null && ew.getURI() != null) {
                            try {
                                results.add("<a href=\"entityEdit?uri=" + URLEncoder.encode(ew.getURI(), "UTF-8") + "\">" + ew.getName() + "</a>");
                            }
                            catch (Exception e) {
                                results.add(ew.getName());
                            }
                        } else {
                            results.add("");
                        }
                        String descriptionStr = vcw.getDescription() == null ? "" : vcw.getDescription();
                        results.add(descriptionStr);
                        if (!entIt.hasNext()) continue;
                        results.add("@@entities");
                    }
                }
                request.setAttribute("results", results);
            }
        }
        request.setAttribute("columncount", (Object)new Integer(this.NUM_COLS));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Class Groups");
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/fetch/horizontal.jsp");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

