/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.OWL;

@WebServlet(name="ShowClassHierarchyController", urlPatterns={"/showClassHierarchy"})
public class ShowClassHierarchyController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ShowClassHierarchyController.class.getName());
    private static final String TEMPLATE_NAME = "siteAdmin-classHierarchy.ftl";
    private int MAXDEPTH = 7;
    private VClassDao vcDao = null;
    private int previous_posn = 0;

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String displayOption = "";
        displayOption = vreq.getParameter("displayOption") != null ? vreq.getParameter("displayOption") : "asserted";
        body.put("displayOption", displayOption);
        boolean inferred = displayOption.equals("inferred");
        if (inferred) {
            body.put("pageTitle", "Inferred Class Hierarchy");
        } else {
            body.put("pageTitle", "Asserted Class Hierarchy");
        }
        this.vcDao = !inferred ? vreq.getUnfilteredAssertionsWebappDaoFactory().getVClassDao() : vreq.getUnfilteredWebappDaoFactory().getVClassDao();
        StringBuilder json = new StringBuilder();
        String ontologyUri = vreq.getParameter("ontologyUri");
        String startClassUri = vreq.getParameter("vclassUri");
        List<VClass> roots = null;
        if (ontologyUri != null) {
            roots = this.vcDao.getOntologyRootClasses(ontologyUri);
        } else if (startClassUri != null) {
            roots = new LinkedList<VClass>();
            roots.add(this.vcDao.getVClassByURI(startClassUri));
        } else {
            roots = this.vcDao.getRootClasses();
        }
        if (roots.isEmpty()) {
            roots = new LinkedList<VClass>();
            roots.add(vreq.getUnfilteredWebappDaoFactory().getVClassDao().getTopConcept());
        }
        this.sortForPickList(roots, vreq);
        int counter = 0;
        Iterator<VClass> rootIt = roots.iterator();
        if (!rootIt.hasNext()) {
            VClass vcw = new VClass();
            vcw.setName("<strong>No classes found.</strong>");
            json.append(this.addVClassDataToResultsList(vreq.getUnfilteredWebappDaoFactory(), vcw, 0, ontologyUri, counter));
        } else {
            while (rootIt.hasNext()) {
                VClass root = rootIt.next();
                if (root == null) continue;
                json.append(this.addChildren(vreq.getUnfilteredWebappDaoFactory(), root, 0, ontologyUri, counter, vreq));
                ++counter;
            }
            int length = json.length();
            if (length > 0) {
                json.append(" }");
            }
        }
        body.put("jsonTree", json.toString());
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private String addChildren(WebappDaoFactory wadf, VClass parent, int position, String ontologyUri, int counter, VitroRequest vreq) {
        String rowElts = this.addVClassDataToResultsList(wadf, parent, position, ontologyUri, counter);
        int childShift = rowElts.length() > 0 ? 1 : 0;
        int length = rowElts.length();
        StringBuilder leaves = new StringBuilder();
        leaves.append(rowElts);
        List<String> childURIstrs = this.vcDao.getSubClassURIs(parent.getURI());
        if (childURIstrs.size() > 0 && position < this.MAXDEPTH) {
            ArrayList<VClass> childClasses = new ArrayList<VClass>();
            for (String URIstr : childURIstrs) {
                try {
                    VClass child = this.vcDao.getVClassByURI(URIstr);
                    if (child.getURI().equals(OWL.Nothing.getURI())) continue;
                    childClasses.add(child);
                }
                catch (Exception child) {}
            }
            this.sortForPickList(childClasses, vreq);
            Iterator childClassIt = childClasses.iterator();
            block11: while (childClassIt.hasNext()) {
                String ending;
                VClass child = (VClass)childClassIt.next();
                leaves.append(this.addChildren(wadf, child, position + childShift, ontologyUri, counter, vreq));
                if (childClassIt.hasNext()) continue;
                if (ontologyUri == null) {
                    leaves.append(" }] ");
                    continue;
                }
                if (ontologyUri == null || length <= 0) continue;
                switch (ending = leaves.substring(leaves.length() - 2, leaves.length())) {
                    case "] ": {
                        leaves.append("}]");
                        continue block11;
                    }
                    case " [": {
                        leaves.append("] ");
                        continue block11;
                    }
                }
                leaves.append("}]");
            }
        } else if (ontologyUri == null) {
            leaves.append("] ");
        } else if (ontologyUri != null && length > 0) {
            leaves.append("] ");
        }
        return leaves.toString();
    }

    private String addVClassDataToResultsList(WebappDaoFactory wadf, VClass vcw, int position, String ontologyUri, int counter) {
        String tempString = "";
        if (ontologyUri == null || vcw.getNamespace() != null && vcw.getNamespace().equals(ontologyUri)) {
            String ontName;
            if (counter < 1 && position < 1) {
                tempString = tempString + "{ \"name\": ";
            } else if (position == this.previous_posn) {
                tempString = tempString + "}, { \"name\": ";
            } else if (position > this.previous_posn) {
                tempString = tempString + " { \"name\": ";
            } else if (position < this.previous_posn) {
                tempString = tempString + "}, { \"name\": ";
            }
            try {
                tempString = tempString + JacksonUtils.quote("<a href='vclassEdit?uri=" + URLEncoder.encode(vcw.getURI(), "UTF-8") + "'>" + vcw.getPickListName() + "</a>") + ", ";
            }
            catch (Exception e) {
                tempString = tempString + JacksonUtils.quote(vcw.getPickListName() == null ? "" : vcw.getPickListName()) + ", ";
            }
            String shortDef = vcw.getShortDef() == null ? "" : vcw.getShortDef();
            tempString = tempString + "\"data\": { \"shortDef\": " + JacksonUtils.quote(shortDef) + ", ";
            VClassGroupDao groupDao = wadf.getVClassGroupDao();
            String groupURI = vcw.getGroupURI();
            String groupName = null;
            VClassGroup classGroup = null;
            if (groupURI != null && (classGroup = groupDao.getGroupByURI(groupURI)) != null) {
                groupName = classGroup.getPublicName();
            }
            tempString = tempString + "\"classGroup\": " + JacksonUtils.quote(groupName == null ? "" : groupName) + ", ";
            OntologyDao ontDao = wadf.getOntologyDao();
            Ontology ont = ontDao.getOntologyByURI(ontName = vcw.getNamespace());
            if (ont != null && ont.getName() != null) {
                ontName = ont.getName();
            }
            tempString = tempString + "\"ontology\": " + JacksonUtils.quote(ontName == null ? "" : ontName) + "}, \"children\": [";
            this.previous_posn = position;
        }
        return tempString;
    }
}

