/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.GetSearchIndividualsByVClass;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewService;
import edu.cornell.mannlib.vitro.webapp.services.shortview.ShortViewServiceSetup;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.IndividualTemplateModelBuilder;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetRandomSearchIndividualsByVClass
extends GetSearchIndividualsByVClass {
    private static final Log log = LogFactory.getLog(GetRandomSearchIndividualsByVClass.class);

    protected GetRandomSearchIndividualsByVClass(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected ObjectNode process() throws Exception {
        ObjectNode rObj = null;
        List<String> vclassIds = super.getVclassIds(this.vreq);
        String vclassId = vclassIds.get(0);
        this.vreq.setAttribute("queryType", "random");
        rObj = super.process();
        this.addShortViewRenderings(rObj);
        return rObj;
    }

    private void addShortViewRenderings(ObjectNode rObj) {
        ArrayNode individuals = (ArrayNode)rObj.get("individuals");
        String vclassName = rObj.get("vclass").get("name").asText();
        for (int i = 0; i < individuals.size(); ++i) {
            ObjectNode individual = (ObjectNode)individuals.get(i);
            individual.put("shortViewHtml", this.renderShortView(individual.get("URI").asText(), vclassName));
        }
    }

    private String renderShortView(String individualUri, String vclassName) {
        IndividualDao iDao = this.vreq.getWebappDaoFactory().getIndividualDao();
        Individual individual = iDao.getIndividualByURI(individualUri);
        HashMap<String, Object> modelMap = new HashMap<String, Object>();
        modelMap.put("individual", IndividualTemplateModelBuilder.build(individual, this.vreq));
        modelMap.put("vclass", vclassName);
        ShortViewService svs = ShortViewServiceSetup.getService(this.ctx);
        return svs.renderShortView(individual, ShortViewService.ShortViewContext.BROWSE, modelMap, this.vreq);
    }
}

