/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VClassGroupsForRequest {
    private static final Log log = LogFactory.getLog(VClassGroupsForRequest.class);
    private final HttpServletRequest req;
    private final Map<String, VClassGroup> groupMap = new LinkedHashMap<String, VClassGroup>();
    private final Map<String, VClass> classMap = new HashMap<String, VClass>();

    public VClassGroupsForRequest(HttpServletRequest req, VClassGroupCache cache) {
        this.req = req;
        for (VClassGroup vcGroup : cache.getGroups()) {
            this.loadGroup(vcGroup);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("groups: " + this.groupMap.values()));
            log.debug((Object)("classes: " + this.classMap.values()));
        }
    }

    private void loadGroup(VClassGroup vcg) {
        VClassGroup newVcg = new VClassGroup(vcg);
        newVcg.setPublicName(this.getNameForGroup(vcg));
        this.groupMap.put(newVcg.getURI(), newVcg);
        for (VClass vClass : vcg) {
            this.loadClass(vClass, newVcg);
        }
    }

    private String getNameForGroup(VClassGroup vcGroup) {
        VClassGroup g = ModelAccess.on(this.req).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]).getVClassGroupDao().getGroupByURI(vcGroup.getURI());
        return g == null ? vcGroup.getPublicName() : g.getPublicName();
    }

    private void loadClass(VClass vc, VClassGroup newVcg) {
        VClass newVc = vc.copy();
        newVc.setName(this.getNameForVClass(vc));
        newVc.setGroup(newVcg);
        newVcg.add(newVc);
        this.classMap.put(newVc.getURI(), newVc);
    }

    private String getNameForVClass(VClass vClass) {
        VClass vc = ModelAccess.on(this.req).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]).getVClassDao().getVClassByURI(vClass.getURI());
        return vc == null ? vClass.getName() : vc.getName();
    }

    public VClassGroup getGroup(String vClassGroupURI) {
        VClassGroup vcg = this.groupMap.get(vClassGroupURI);
        log.debug((Object)("getGroup(" + vClassGroupURI + ") = " + vcg));
        return vcg;
    }

    public List<VClassGroup> getGroups() {
        ArrayList<VClassGroup> groups = new ArrayList<VClassGroup>(this.groupMap.values());
        log.debug((Object)("getGroups() returned " + groups.size() + " groups."));
        return groups;
    }

    public VClass getCachedVClass(String classUri) {
        VClass vc = this.classMap.get(classUri);
        log.debug((Object)("getCachedVClass(" + classUri + ") = " + vc));
        return vc;
    }
}

