/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.Set;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class DifferenceGraph
implements Graph {
    private Graph g;
    private Graph subtract;

    public DifferenceGraph(Graph g, Graph subtract) {
        this.g = g;
        this.subtract = subtract;
    }

    public void close() {
    }

    public boolean contains(Triple arg0) {
        return this.g.contains(arg0) && !this.subtract.contains(arg0);
    }

    public boolean contains(Node arg0, Node arg1, Node arg2) {
        return this.g.contains(arg0, arg1, arg2) && !this.subtract.contains(arg0, arg1, arg2);
    }

    public void delete(Triple arg0) throws DeleteDeniedException {
        this.g.delete(arg0);
    }

    public ExtendedIterator<Triple> find(Triple triple) {
        return this.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void remove(Node arg0, Node arg1, Node arg2) {
        this.g.remove(arg0, arg1, arg2);
    }

    public boolean dependsOn(Graph arg0) {
        return this.g.dependsOn(arg0);
    }

    public ExtendedIterator<Triple> find(Node arg0, Node arg1, Node arg2) {
        Set tripSet = this.g.find(arg0, arg1, arg2).toSet();
        tripSet.removeAll(this.subtract.find(arg0, arg1, arg2).toSet());
        return WrappedIterator.create(tripSet.iterator());
    }

    public Capabilities getCapabilities() {
        return this.g.getCapabilities();
    }

    public GraphEventManager getEventManager() {
        return this.g.getEventManager();
    }

    public PrefixMapping getPrefixMapping() {
        return this.g.getPrefixMapping();
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return this.g.getStatisticsHandler();
    }

    public TransactionHandler getTransactionHandler() {
        return this.g.getTransactionHandler();
    }

    public boolean isClosed() {
        return this.g.isClosed();
    }

    public boolean isEmpty() {
        return this.g.isEmpty();
    }

    public boolean isIsomorphicWith(Graph arg0) {
        return this.g.isIsomorphicWith(arg0);
    }

    public int size() {
        return this.g.size() - this.subtract.size();
    }

    public void add(Triple arg0) throws AddDeniedException {
        this.g.add(arg0);
    }

    public void clear() {
        this.g.clear();
    }

    public String toString() {
        return "DifferenceGraph[" + ToString.hashHex(this) + ", g=" + ToString.graphToString(this.g) + ", subtract=" + ToString.graphToString(this.subtract) + "]";
    }
}

