/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.ImageInfo;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class IndividualJena
extends IndividualImpl
implements Individual {
    private static final Log log = LogFactory.getLog((String)IndividualJena.class.getName());
    private OntResource ind = null;
    private WebappDaoFactoryJena webappDaoFactory = null;
    private Float _searchBoostJena = null;
    private boolean retrievedNullRdfsLabel = false;
    private Collator collator = Collator.getInstance();

    public IndividualJena(OntResource ind, WebappDaoFactoryJena wadf) {
        this.ind = ind;
        if (ind.isAnon()) {
            this.setNamespace("http://vitro.mannlib.cornell.edu/ns/bnode#");
            this.setLocalName(ind.getId().toString());
        } else {
            this.URI = ind.getURI();
            this.namespace = ind.getNameSpace();
            this.localName = ind.getLocalName();
        }
        this.webappDaoFactory = wadf;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            this.name = this.webappDaoFactory.getJenaBaseDao().getLabelOrId(this.ind);
            if (this.name == null) {
                this.name = "[null]";
            }
            String string = this.name;
            return string;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getLabel() {
        return this.getRdfsLabel();
    }

    @Override
    public String getRdfsLabel() {
        if (this.rdfsLabel != null) {
            return this.rdfsLabel;
        }
        if (this.rdfsLabel == null && this.retrievedNullRdfsLabel) {
            return null;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            this.rdfsLabel = this.webappDaoFactory.getJenaBaseDao().getLabel(this.ind);
            this.retrievedNullRdfsLabel = this.rdfsLabel == null;
            String string = this.rdfsLabel;
            return string;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVClassURI() {
        if (this.vClassURI != null) {
            return this.vClassURI;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try (ExtendedIterator typeIt = this.ind.listRDFTypes(true);){
            while (typeIt.hasNext()) {
                Resource type = (Resource)typeIt.next();
                if (type.getNameSpace() == null || this.webappDaoFactory.getJenaBaseDao().NONUSER_NAMESPACES.contains(type.getNameSpace()) && !type.getURI().equals(OWL.Thing.getURI())) continue;
                this.vClassURI = type.getURI();
                break;
            }
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
        return this.vClassURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VClass getVClass() {
        if (this.vClass != null) {
            return this.vClass;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            try (ExtendedIterator typeIt = this.ind.listRDFTypes(true);){
                while (typeIt.hasNext()) {
                    Resource type = (Resource)typeIt.next();
                    if (type.getNameSpace() == null || this.webappDaoFactory.getJenaBaseDao().NONUSER_NAMESPACES.contains(type.getNameSpace()) && !type.getURI().equals(OWL.Thing.getURI())) continue;
                    this.vClassURI = type.getURI();
                    this.vClass = this.webappDaoFactory.getVClassDao().getVClassByURI(this.vClassURI);
                    break;
                }
            }
            VClass vClass = this.vClass;
            return vClass;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public Timestamp getModTime() {
        if (this.modTime != null) {
            return this.modTime;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            Date modDate = this.webappDaoFactory.getJenaBaseDao().getPropertyDateTimeValue(this.ind, (Property)this.webappDaoFactory.getJenaBaseDao().MODTIME);
            if (modDate != null) {
                this.modTime = new Timestamp(modDate.getTime());
            }
            Timestamp timestamp = this.modTime;
            return timestamp;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public Float getSearchBoost() {
        if (this._searchBoostJena != null) {
            return this._searchBoostJena;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            try {
                this.searchBoost = Float.valueOf(((Literal)this.ind.getPropertyValue((Property)this.webappDaoFactory.getJenaBaseDao().SEARCH_BOOST_ANNOT)).getFloat());
            }
            catch (Exception e) {
                this.searchBoost = null;
            }
            Float f = this.searchBoost;
            return f;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getMainImageUri() {
        if (this.mainImageUri != "__%NOT_INITIALIZED%__") {
            return this.mainImageUri;
        }
        for (ObjectPropertyStatement stmt : this.getObjectPropertyStatements()) {
            if (!stmt.getPropertyURI().equals("http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage")) continue;
            this.mainImageUri = stmt.getObjectURI();
            return this.mainImageUri;
        }
        return null;
    }

    @Override
    public String getImageUrl() {
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.instanceFromEntityUri(this.webappDaoFactory, this);
            log.trace((Object)("figured imageInfo for " + this.getURI() + ": '" + this.imageInfo + "'"));
        }
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.EMPTY_IMAGE_INFO;
            log.trace((Object)("imageInfo for " + this.getURI() + " is empty."));
        }
        return this.imageInfo.getMainImage().getBytestreamAliasUrl();
    }

    @Override
    public String getThumbUrl() {
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.instanceFromEntityUri(this.webappDaoFactory, this);
            log.trace((Object)("figured imageInfo for " + this.getURI() + ": '" + this.imageInfo + "'"));
        }
        if (this.imageInfo == null) {
            this.imageInfo = ImageInfo.EMPTY_IMAGE_INFO;
            log.trace((Object)("imageInfo for " + this.getURI() + " is empty."));
        }
        return this.imageInfo.getThumbnail().getBytestreamAliasUrl();
    }

    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements() {
        if (this.objectPropertyStatements != null) {
            return this.objectPropertyStatements;
        }
        try {
            this.webappDaoFactory.getObjectPropertyStatementDao().fillExistingObjectPropertyStatements(this);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not fill existing ObjectPropertyStatements for " + this.getURI()), (Throwable)e);
        }
        return this.objectPropertyStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectPropertyStatement> getObjectPropertyStatements(String propertyURI) {
        if (propertyURI == null) {
            return null;
        }
        ArrayList<ObjectPropertyStatement> objectPropertyStatements = new ArrayList<ObjectPropertyStatement>();
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator sit = this.ind.listProperties(this.ind.getModel().getProperty(propertyURI));
            while (sit.hasNext()) {
                Statement s = sit.nextStatement();
                if (!s.getSubject().canAs(OntResource.class) || !s.getObject().canAs(OntResource.class)) continue;
                IndividualJena subj = new IndividualJena((OntResource)s.getSubject().as(OntResource.class), this.webappDaoFactory);
                IndividualJena obj = new IndividualJena((OntResource)s.getObject().as(OntResource.class), this.webappDaoFactory);
                ObjectProperty op = this.webappDaoFactory.getObjectPropertyDao().getObjectPropertyByURI(s.getPredicate().getURI());
                if (subj == null || obj == null || op == null) continue;
                ObjectPropertyStatementImpl ops = new ObjectPropertyStatementImpl();
                ops.setSubject(subj);
                ops.setSubjectURI(subj.getURI());
                ops.setObject(obj);
                ops.setObjectURI(obj.getURI());
                ops.setProperty(op);
                ops.setPropertyURI(op.getURI());
                objectPropertyStatements.add(ops);
            }
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
        return objectPropertyStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Individual> getRelatedIndividuals(String propertyURI) {
        if (propertyURI == null) {
            return null;
        }
        ArrayList<Individual> relatedIndividuals = new ArrayList<Individual>();
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            NodeIterator values = this.ind.listPropertyValues(this.ind.getModel().getProperty(propertyURI));
            while (values.hasNext()) {
                RDFNode value = values.nextNode();
                if (!value.canAs(OntResource.class)) continue;
                relatedIndividuals.add(new IndividualJena((OntResource)value.as(OntResource.class), this.webappDaoFactory));
            }
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
        return relatedIndividuals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Individual getRelatedIndividual(String propertyURI) {
        if (propertyURI == null) {
            return null;
        }
        this.ind.getOntModel().enterCriticalSection(true);
        try {
            RDFNode value = this.ind.getPropertyValue(this.ind.getModel().getProperty(propertyURI));
            if (value != null && value.canAs(OntResource.class)) {
                IndividualJena individualJena = new IndividualJena((OntResource)value.as(OntResource.class), this.webappDaoFactory);
                return individualJena;
            }
            Individual individual = null;
            return individual;
        }
        finally {
            this.ind.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public List<ObjectProperty> getObjectPropertyList() {
        if (this.propertyList != null) {
            return this.propertyList;
        }
        try {
            this.webappDaoFactory.getObjectPropertyDao().fillObjectPropertiesForIndividual(this);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not fillEntityProperties for " + this.getURI()));
        }
        return this.propertyList;
    }

    @Override
    public List<ObjectProperty> getPopulatedObjectPropertyList() {
        if (this.populatedObjectPropertyList == null) {
            this.populatedObjectPropertyList = this.webappDaoFactory.getObjectPropertyDao().getObjectPropertyList(this);
        }
        return this.populatedObjectPropertyList;
    }

    @Override
    public Map<String, ObjectProperty> getObjectPropertyMap() {
        if (this.objectPropertyMap != null) {
            return this.objectPropertyMap;
        }
        HashMap<String, ObjectProperty> map = new HashMap<String, ObjectProperty>();
        if (this.propertyList == null) {
            this.getObjectPropertyList();
        }
        for (ObjectProperty op : this.propertyList) {
            if (op.getURI() == null) continue;
            map.put(op.getURI(), op);
        }
        this.objectPropertyMap = map;
        return map;
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements() {
        if (this.dataPropertyStatements != null) {
            return this.dataPropertyStatements;
        }
        try {
            this.webappDaoFactory.getDataPropertyStatementDao().fillExistingDataPropertyStatementsForIndividual(this);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not fill existing DataPropertyStatements for " + this.getURI()));
        }
        return this.dataPropertyStatements;
    }

    public List getDataPropertyList() {
        if (this.datatypePropertyList != null) {
            return this.datatypePropertyList;
        }
        try {
            this.webappDaoFactory.getDataPropertyDao().fillDataPropertiesForIndividual(this);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not fill data properties for " + this.getURI()));
        }
        return this.datatypePropertyList;
    }

    @Override
    public List<DataProperty> getPopulatedDataPropertyList() {
        if (this.populatedDataPropertyList == null) {
            this.populatedDataPropertyList = this.webappDaoFactory.getDataPropertyDao().getDataPropertyList(this);
        }
        return this.populatedDataPropertyList;
    }

    @Override
    public Map<String, DataProperty> getDataPropertyMap() {
        if (this.dataPropertyMap != null) {
            return this.dataPropertyMap;
        }
        HashMap<String, DataProperty> map = new HashMap<String, DataProperty>();
        if (this.datatypePropertyList == null) {
            this.getDataPropertyList();
        }
        for (DataProperty dp : this.datatypePropertyList) {
            if (dp.getURI() == null) continue;
            map.put(dp.getURI(), dp);
        }
        this.dataPropertyMap = map;
        return map;
    }

    @Override
    public List<DataPropertyStatement> getExternalIds() {
        if (this.externalIds != null) {
            return this.externalIds;
        }
        try {
            ArrayList<DataPropertyStatement> dpsList = new ArrayList<DataPropertyStatement>();
            dpsList.addAll(this.webappDaoFactory.getIndividualDao().getExternalIds(this.getURI(), null));
            this.externalIds = dpsList;
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not fill external IDs for " + this.getURI()));
        }
        return this.externalIds;
    }

    @Override
    public List<VClass> getVClasses() {
        return this.getVClasses(false);
    }

    @Override
    public List<VClass> getVClasses(boolean direct) {
        if (direct) {
            if (this.directVClasses != null) {
                return this.directVClasses;
            }
            this.directVClasses = this.getMyVClasses(true);
            return this.directVClasses;
        }
        if (this.allVClasses != null) {
            return this.allVClasses;
        }
        this.allVClasses = this.getMyVClasses(false);
        return this.allVClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VClass> getMyVClasses(boolean direct) {
        ArrayList<VClass> vClassList = new ArrayList<VClass>();
        OntModel ontModel = this.ind.getOntModel();
        ontModel.enterCriticalSection(true);
        try (ExtendedIterator typeIt = this.ind.listRDFTypes(direct);){
            ExtendedIterator it = typeIt;
            while (it.hasNext()) {
                VClass vc;
                String typeURI;
                Resource type = (Resource)typeIt.next();
                String string = typeURI = !type.isAnon() ? type.getURI() : "http://vitro.mannlib.cornell.edu/ns/bnode#" + type.getId().toString();
                if (type.getNameSpace() != null && this.webappDaoFactory.getNonuserNamespaces().contains(type.getNameSpace()) || (vc = this.webappDaoFactory.getVClassDao().getVClassByURI(typeURI)) == null) continue;
                vClassList.add(vc);
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        try {
            Collections.sort(vClassList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vClassList;
    }

    @Override
    public boolean isVClass(String uri) {
        if (uri == null) {
            return false;
        }
        if (super.isVClass(uri)) {
            return true;
        }
        VClassDao vclassDao = this.webappDaoFactory.getVClassDao();
        for (VClass vClass : this.getVClasses(true)) {
            for (String superClassUri : vclassDao.getAllSuperClassURIs(vClass.getURI())) {
                if (!uri.equals(superClassUri)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void sortEnts2EntsForDisplay() {
        if (this.getObjectPropertyList() == null) {
            return;
        }
        for (ObjectProperty prop : this.getObjectPropertyList()) {
            ObjectProperty.sortObjectPropertyStatementsForDisplay(prop, prop.getObjectPropertyStatements());
        }
    }

    private void sortObjectPropertyStatementsForDisplay(ObjectProperty prop) {
        try {
            boolean tmpAsc;
            log.info((Object)("Doing special sort for " + prop.getDomainPublic()));
            final String sortPropertyURI = prop.getObjectIndividualSortPropertyURI();
            String tmpDir = prop.getDomainEntitySortDirection();
            final boolean dir = tmpAsc = !"desc".equalsIgnoreCase(tmpDir);
            Comparator comp = new Comparator(){
                final boolean cAsc;
                {
                    this.cAsc = dir;
                }

                public final int compare(Object o1, Object o2) {
                    DataProperty dp;
                    ObjectPropertyStatement e2e1 = (ObjectPropertyStatement)o1;
                    ObjectPropertyStatement e2e2 = (ObjectPropertyStatement)o2;
                    Individual e1 = e2e1 != null ? e2e1.getObject() : null;
                    Individual e2 = e2e2 != null ? e2e2.getObject() : null;
                    String val1 = null;
                    String val2 = null;
                    if (e1 != null) {
                        try {
                            dp = e1.getDataPropertyMap().get(sortPropertyURI);
                            if (dp.getDataPropertyStatements() != null && dp.getDataPropertyStatements().size() > 0) {
                                val1 = dp.getDataPropertyStatements().get(0).getData();
                            }
                        }
                        catch (Exception e) {
                            val1 = "";
                        }
                    } else {
                        log.warn((Object)"IndividualJena.sortObjectPropertiesForDisplay passed object property statement with no range entity.");
                    }
                    if (e2 != null) {
                        try {
                            dp = e2.getDataPropertyMap().get(sortPropertyURI);
                            if (dp.getDataPropertyStatements() != null && dp.getDataPropertyStatements().size() > 0) {
                                val2 = dp.getDataPropertyStatements().get(0).getData();
                            }
                        }
                        catch (Exception e) {
                            val2 = "";
                        }
                    } else {
                        log.warn((Object)"IndividualJena.sortObjectPropertyStatementsForDisplay() was passed an object property statement with no range entity.");
                    }
                    int rv = 0;
                    try {
                        if (val1 instanceof String) {
                            rv = IndividualJena.this.collator.compare((Object)val1, (Object)val2);
                        } else if (val1 instanceof Date) {
                            DateTime dt1 = new DateTime((Object)val1);
                            DateTime dt2 = new DateTime((Object)val2);
                            rv = dt1.compareTo((ReadableInstant)dt2);
                        } else {
                            rv = 0;
                        }
                    }
                    catch (NullPointerException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                    if (this.cAsc) {
                        return rv;
                    }
                    return rv * -1;
                }
            };
            try {
                this.getObjectPropertyStatements().sort(comp);
            }
            catch (Exception e) {
                log.error((Object)("Exception sorting object property statements for object property " + this.getURI()));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void resolveAsFauxPropertyStatements(List<ObjectPropertyStatement> list) {
        this.webappDaoFactory.getObjectPropertyStatementDao().resolveAsFauxPropertyStatements(list);
    }
}

