/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class UserAccountsDaoJena
extends JenaBaseDao
implements UserAccountsDao {
    public UserAccountsDaoJena(WebappDaoFactoryJena wadf) {
        super(wadf);
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getUserAccountsModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<UserAccount> getAllUserAccounts() {
        ArrayList<String> userUris = new ArrayList<String>();
        this.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator stmts = this.getOntModel().listStatements((Resource)null, RDF.type, (RDFNode)this.USERACCOUNT);
            while (stmts.hasNext()) {
                Resource subject = ((Statement)stmts.next()).getSubject();
                if (subject == null) continue;
                userUris.add(subject.getURI());
            }
            stmts.close();
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        ArrayList<UserAccount> userAccounts = new ArrayList<UserAccount>();
        for (String userUri : userUris) {
            UserAccount ua = this.getUserAccountByUri(userUri);
            if (ua == null) continue;
            userAccounts.add(ua);
        }
        return userAccounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserAccount getUserAccountByUri(String uri) {
        if (uri == null) {
            return null;
        }
        this.getOntModel().enterCriticalSection(true);
        try {
            OntResource r = this.getOntModel().getOntResource(uri);
            if (r == null) {
                UserAccount userAccount = null;
                return userAccount;
            }
            if (!this.isResourceOfType(r, this.USERACCOUNT)) {
                UserAccount userAccount = null;
                return userAccount;
            }
            UserAccount u = new UserAccount();
            u.setUri(r.getURI());
            u.setEmailAddress(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_EMAIL_ADDRESS));
            u.setFirstName(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_FIRST_NAME));
            u.setLastName(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_LAST_NAME));
            u.setArgon2Password(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_ARGON2_PASSWORD));
            u.setMd5Password(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_MD5_PASSWORD));
            u.setOldPassword(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_OLD_PASSWORD));
            u.setPasswordLinkExpires(this.getPropertyLongValue(r, (Property)this.USERACCOUNT_PASSWORD_LINK_EXPIRES));
            u.setPasswordChangeRequired(this.getPropertyBooleanValue(r, (Property)this.USERACCOUNT_PASSWORD_CHANGE_REQUIRED));
            u.setExternalAuthOnly(this.getPropertyBooleanValue(r, (Property)this.USERACCOUNT_EXTERNAL_AUTH_ONLY));
            u.setLoginCount(this.getPropertyIntValue(r, (Property)this.USERACCOUNT_LOGIN_COUNT));
            u.setLastLoginTime(this.getPropertyLongValue(r, (Property)this.USERACCOUNT_LAST_LOGIN_TIME));
            u.setStatusFromString(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_STATUS));
            u.setExternalAuthId(this.getPropertyStringValue(r, (Property)this.USERACCOUNT_EXTERNAL_AUTH_ID));
            u.setPermissionSetUris(this.getPropertyResourceURIValues((Resource)r, this.USERACCOUNT_HAS_PERMISSION_SET));
            u.setRootUser(this.isResourceOfType(r, this.USERACCOUNT_ROOT_USER));
            u.setProxiedIndividualUris(this.getPropertyResourceURIValues((Resource)r, this.USERACCOUNT_PROXY_EDITOR_FOR));
            UserAccount userAccount = u;
            return userAccount;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserAccount getUserAccountByEmail(String emailAddress) {
        if (emailAddress == null) {
            return null;
        }
        String userUri = null;
        this.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator stmts = this.getOntModel().listStatements(null, (Property)this.USERACCOUNT_EMAIL_ADDRESS, (RDFNode)this.getOntModel().createLiteral(emailAddress));
            if (stmts.hasNext()) {
                userUri = ((Statement)stmts.next()).getSubject().getURI();
            }
            stmts.close();
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return this.getUserAccountByUri(userUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserAccount getUserAccountByExternalAuthId(String externalAuthId) {
        if (externalAuthId == null) {
            return null;
        }
        String userUri = null;
        this.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator stmts = this.getOntModel().listStatements(null, (Property)this.USERACCOUNT_EXTERNAL_AUTH_ID, (RDFNode)this.getOntModel().createLiteral(externalAuthId));
            if (stmts.hasNext()) {
                userUri = ((Statement)stmts.next()).getSubject().getURI();
            }
            stmts.close();
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return this.getUserAccountByUri(userUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<UserAccount> getUserAccountsWhoProxyForPage(String profilePageUri) {
        ArrayList<String> userUris = new ArrayList<String>();
        Resource s = null;
        Property p = this.getOntModel().getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#proxyEditorFor");
        Resource o = this.getOntModel().createResource(profilePageUri);
        this.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator stmts = this.getOntModel().listStatements(s, p, (RDFNode)o);
            while (stmts.hasNext()) {
                Resource subject = ((Statement)stmts.next()).getSubject();
                if (subject == null) continue;
                userUris.add(subject.getURI());
            }
            stmts.close();
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        ArrayList<UserAccount> userAccounts = new ArrayList<UserAccount>();
        for (String userUri : userUris) {
            UserAccount ua = this.getUserAccountByUri(userUri);
            if (ua == null) continue;
            userAccounts.add(ua);
        }
        return userAccounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String insertUserAccount(UserAccount userAccount) {
        if (userAccount == null) {
            throw new NullPointerException("userAccount may not be null.");
        }
        if (!userAccount.getUri().isEmpty()) {
            throw new IllegalArgumentException("URI of new userAccount must be empty.");
        }
        OntModel model = this.getOntModel();
        model.enterCriticalSection(false);
        try {
            String userUri = this.getUnusedURI();
            Individual res = model.createIndividual(userUri, (Resource)this.USERACCOUNT);
            this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_EMAIL_ADDRESS, userAccount.getEmailAddress(), (Model)model);
            this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_FIRST_NAME, userAccount.getFirstName(), (Model)model);
            this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_LAST_NAME, userAccount.getLastName(), (Model)model);
            this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_MD5_PASSWORD, userAccount.getMd5Password(), (Model)model);
            this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_ARGON2_PASSWORD, userAccount.getArgon2Password(), (Model)model);
            this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_OLD_PASSWORD, userAccount.getOldPassword(), (Model)model);
            this.addPropertyLongValue((Resource)res, (Property)this.USERACCOUNT_PASSWORD_LINK_EXPIRES, userAccount.getPasswordLinkExpires(), (Model)model);
            this.addPropertyBooleanValue((Resource)res, (Property)this.USERACCOUNT_PASSWORD_CHANGE_REQUIRED, userAccount.isPasswordChangeRequired(), (Model)model);
            this.addPropertyBooleanValue((Resource)res, (Property)this.USERACCOUNT_EXTERNAL_AUTH_ONLY, userAccount.isExternalAuthOnly(), (Model)model);
            this.addPropertyIntValue((Resource)res, (Property)this.USERACCOUNT_LOGIN_COUNT, userAccount.getLoginCount(), (Model)model);
            this.addPropertyLongValue((Resource)res, (Property)this.USERACCOUNT_LAST_LOGIN_TIME, userAccount.getLastLoginTime(), (Model)model);
            if (userAccount.getStatus() != null) {
                this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_STATUS, userAccount.getStatus().toString(), (Model)model);
            }
            this.addPropertyStringValue((Resource)res, (Property)this.USERACCOUNT_EXTERNAL_AUTH_ID, userAccount.getExternalAuthId(), (Model)model);
            this.updatePropertyResourceURIValues((Resource)res, (Property)this.USERACCOUNT_HAS_PERMISSION_SET, userAccount.getPermissionSetUris(), (Model)model);
            if (userAccount.isRootUser()) {
                model.add((Resource)res, RDF.type, (RDFNode)this.USERACCOUNT_ROOT_USER);
            }
            this.updatePropertyResourceURIValues((Resource)res, (Property)this.USERACCOUNT_PROXY_EDITOR_FOR, userAccount.getProxiedIndividualUris(), (Model)model);
            userAccount.setUri(userUri);
            String string = userUri;
            return string;
        }
        catch (InsertException e) {
            log.error((Object)e, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserAccount(UserAccount userAccount) {
        if (userAccount == null) {
            throw new NullPointerException("userAccount may not be null.");
        }
        OntModel model = this.getOntModel();
        model.enterCriticalSection(false);
        try {
            OntResource res = model.getOntResource(userAccount.getUri());
            if (res == null) {
                throw new IllegalArgumentException("userAccount '" + userAccount.getUri() + "' does not exist.");
            }
            this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_EMAIL_ADDRESS, userAccount.getEmailAddress(), (Model)model);
            this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_FIRST_NAME, userAccount.getFirstName(), (Model)model);
            this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_LAST_NAME, userAccount.getLastName(), (Model)model);
            this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_MD5_PASSWORD, userAccount.getMd5Password(), (Model)model);
            this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_ARGON2_PASSWORD, userAccount.getArgon2Password(), (Model)model);
            this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_OLD_PASSWORD, userAccount.getOldPassword(), (Model)model);
            this.updatePropertyLongValue((Resource)res, (Property)this.USERACCOUNT_PASSWORD_LINK_EXPIRES, userAccount.getPasswordLinkExpires(), (Model)model);
            this.updatePropertyBooleanValue((Resource)res, (Property)this.USERACCOUNT_PASSWORD_CHANGE_REQUIRED, userAccount.isPasswordChangeRequired(), (Model)model, true);
            this.updatePropertyBooleanValue((Resource)res, (Property)this.USERACCOUNT_EXTERNAL_AUTH_ONLY, userAccount.isExternalAuthOnly(), (Model)model, true);
            this.updatePropertyIntValue((Resource)res, (Property)this.USERACCOUNT_LOGIN_COUNT, userAccount.getLoginCount(), (Model)model);
            this.updatePropertyLongValue((Resource)res, (Property)this.USERACCOUNT_LAST_LOGIN_TIME, userAccount.getLastLoginTime(), (Model)model);
            if (userAccount.getStatus() == null) {
                this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_STATUS, null, (Model)model);
            } else {
                this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_STATUS, userAccount.getStatus().toString(), (Model)model);
            }
            this.updatePropertyStringValue((Resource)res, (Property)this.USERACCOUNT_EXTERNAL_AUTH_ID, userAccount.getExternalAuthId(), (Model)model);
            this.updatePropertyResourceURIValues((Resource)res, (Property)this.USERACCOUNT_HAS_PERMISSION_SET, userAccount.getPermissionSetUris(), (Model)model);
            if (userAccount.isRootUser()) {
                model.add((Resource)res, RDF.type, (RDFNode)this.USERACCOUNT_ROOT_USER);
            } else {
                model.remove((Resource)res, RDF.type, (RDFNode)this.USERACCOUNT_ROOT_USER);
            }
            this.updatePropertyResourceURIValues((Resource)res, (Property)this.USERACCOUNT_PROXY_EDITOR_FOR, userAccount.getProxiedIndividualUris(), (Model)model);
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUserAccount(String userAccountUri) {
        if (userAccountUri == null) {
            return;
        }
        OntModel model = this.getOntModel();
        model.enterCriticalSection(false);
        try {
            Resource res = model.createResource(userAccountUri);
            model.removeAll(res, null, null);
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProxyAccountsOnProfile(String profilePageUri, Collection<String> userAccountUris) {
        Property p = this.getOntModel().getProperty("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#proxyEditorFor");
        Resource o = this.getOntModel().createResource(profilePageUri);
        ArrayList<String> removeThese = new ArrayList<String>();
        ArrayList<String> addThese = new ArrayList<String>(userAccountUris);
        this.getOntModel().enterCriticalSection(true);
        try {
            Resource s = null;
            StmtIterator stmts = this.getOntModel().listStatements(s, p, (RDFNode)o);
            while (stmts.hasNext()) {
                Resource subject = ((Statement)stmts.next()).getSubject();
                if (subject == null) continue;
                String uri = subject.getURI();
                if (addThese.contains(uri)) {
                    addThese.remove(uri);
                    continue;
                }
                removeThese.add(uri);
            }
            stmts.close();
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        this.getOntModel().enterCriticalSection(false);
        try {
            Resource s;
            for (String uri : removeThese) {
                s = this.getOntModel().createResource(uri);
                this.getOntModel().remove(s, p, (RDFNode)o);
            }
            for (String uri : addThese) {
                s = this.getOntModel().createResource(uri);
                this.getOntModel().add(s, p, (RDFNode)o);
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionSet getPermissionSetByUri(String uri) {
        if (uri == null) {
            return null;
        }
        this.getOntModel().enterCriticalSection(true);
        try {
            OntResource r = this.getOntModel().getOntResource(uri);
            if (r == null) {
                PermissionSet permissionSet = null;
                return permissionSet;
            }
            if (!this.isResourceOfType(r, this.PERMISSIONSET)) {
                PermissionSet permissionSet = null;
                return permissionSet;
            }
            PermissionSet ps = new PermissionSet();
            ps.setUri(uri);
            ps.setLabel(this.getPropertyStringValue(r, RDFS.label));
            ps.setForNewUsers(this.isResourceOfType(r, this.PERMISSION_SET_FOR_NEW_USERS));
            ps.setForPublic(this.isResourceOfType(r, this.PERMISSION_SET_FOR_PUBLIC));
            ps.setPermissionUris(this.getPropertyResourceURIValues((Resource)r, this.PERMISSIONSET_HAS_PERMISSION));
            PermissionSet permissionSet = ps;
            return permissionSet;
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PermissionSet> getAllPermissionSets() {
        ArrayList<PermissionSet> list = new ArrayList<PermissionSet>();
        this.getOntModel().enterCriticalSection(true);
        try (StmtIterator stmtIt = this.getOntModel().listStatements(null, RDF.type, (RDFNode)this.PERMISSIONSET);){
            while (stmtIt.hasNext()) {
                Statement stmt = (Statement)stmtIt.next();
                OntResource r = (OntResource)stmt.getSubject().as(OntResource.class);
                PermissionSet ps = new PermissionSet();
                ps.setUri(r.getURI());
                ps.setLabel(this.getPropertyStringValue(r, RDFS.label));
                ps.setForNewUsers(this.isResourceOfType(r, this.PERMISSION_SET_FOR_NEW_USERS));
                ps.setForPublic(this.isResourceOfType(r, this.PERMISSION_SET_FOR_PUBLIC));
                ps.setPermissionUris(this.getPropertyResourceURIValues((Resource)r, this.PERMISSIONSET_HAS_PERMISSION));
                list.add(ps);
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        list.sort(new PermissionSetsByUri());
        return list;
    }

    private String getUnusedURI() throws InsertException {
        String errMsg = null;
        String namespace = this.DEFAULT_NAMESPACE;
        String uri = null;
        Random random = new Random(System.currentTimeMillis());
        for (int attempts = 0; attempts < 30; ++attempts) {
            int upperBound = (int)Math.pow(2.0, attempts + 13);
            uri = namespace + "u" + random.nextInt(upperBound);
            if (this.isUriUsed(uri)) continue;
            return uri;
        }
        throw new InsertException("Could not create URI for individual: " + errMsg);
    }

    private boolean isUriUsed(String uri) {
        return this.getOntModel().getOntResource(uri) != null;
    }

    private boolean isResourceOfType(OntResource r, OntClass type) {
        if (r == null) {
            return false;
        }
        if (type == null) {
            return false;
        }
        StmtIterator stmts = this.getOntModel().listStatements((Resource)r, RDF.type, (RDFNode)type);
        if (stmts.hasNext()) {
            stmts.close();
            return true;
        }
        stmts.close();
        return false;
    }

    private static class PermissionSetsByUri
    implements Comparator<PermissionSet> {
        private PermissionSetsByUri() {
        }

        @Override
        public int compare(PermissionSet ps1, PermissionSet ps2) {
            return ps1.getUri().compareTo(ps2.getUri());
        }
    }
}

