/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import edu.cornell.mannlib.vitro.webapp.dao.ApplicationDao;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.DatatypeDao;
import edu.cornell.mannlib.vitro.webapp.dao.DisplayModelDao;
import edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.MenuDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PageDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ApplicationDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DataPropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DataPropertyStatementDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatatypeDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DisplayModelDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.FauxPropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.IndividualDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.MenuDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ObjectPropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ObjectPropertyStatementDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelectorImpl;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntologyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.PageDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.PropertyGroupDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.PropertyInstanceDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.StaticDatasetFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.UserAccountsDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupDaoJena;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.utils.jena.URIUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class WebappDaoFactoryJena
implements WebappDaoFactory {
    private static final Log log = LogFactory.getLog(WebappDaoFactoryJena.class);
    protected IndividualDao entityWebappDao;
    protected ApplicationDaoJena applicationDao;
    protected UserAccountsDao userAccountsDao;
    protected VClassGroupDao vClassGroupDao;
    protected PropertyGroupDao propertyGroupDao;
    private PageDao pageDao;
    private MenuDao menuDao;
    protected OntModelSelector ontModelSelector;
    protected WebappDaoFactoryConfig config;
    protected String userURI;
    private Map<String, String> properties = new HashMap<String, String>();
    protected DatasetWrapperFactory dwf;
    protected RDFService rdfService;
    DataPropertyStatementDao dataPropertyStatementDao = null;
    DatatypeDao datatypeDao = null;
    DataPropertyDao dataPropertyDao = null;
    IndividualDao individualDao = null;
    ObjectPropertyStatementDao objectPropertyStatementDao = null;
    private OntologyDao ontologyDao = null;
    private ObjectPropertyDao objectPropertyDao = null;
    private FauxPropertyDao fauxPropertyDao = null;
    private PropertyInstanceDao propertyInstanceDao = null;
    protected VClassDao vClassDao = null;
    private JenaBaseDao jenaBaseDao = null;

    public WebappDaoFactoryJena(WebappDaoFactoryJena base, String userURI) {
        this.ontModelSelector = base.ontModelSelector;
        this.config = base.config;
        this.userURI = userURI;
        this.dwf = base.dwf;
    }

    public WebappDaoFactoryJena(OntModelSelector ontModelSelector, OntModelSelector baseOntModelSelector, OntModelSelector inferenceOntModelSelector, WebappDaoFactoryConfig config, String userURI) {
        this.ontModelSelector = ontModelSelector;
        this.config = config;
        this.userURI = userURI;
        OntModel assertions = baseOntModelSelector != null ? baseOntModelSelector.getFullModel() : ontModelSelector.getFullModel();
        OntModel inferences = inferenceOntModelSelector != null ? inferenceOntModelSelector.getFullModel() : null;
        Dataset dataset = WebappDaoFactoryJena.makeInMemoryDataset((Model)assertions, (Model)inferences);
        this.dwf = new StaticDatasetFactory(dataset);
        this.rdfService = new RDFServiceModel((Model)ontModelSelector.getFullModel());
    }

    public WebappDaoFactoryJena(OntModelSelector ontModelSelector, WebappDaoFactoryConfig config, String userURI) {
        this(ontModelSelector, null, null, config, userURI);
    }

    public WebappDaoFactoryJena(OntModelSelector ontModelSelector, WebappDaoFactoryConfig config) {
        this(ontModelSelector, config, null);
    }

    public WebappDaoFactoryJena(OntModelSelector ontModelSelector, OntModelSelector baseOntModelSelector, OntModelSelector inferenceOntModelSelector, WebappDaoFactoryConfig config) {
        this(ontModelSelector, baseOntModelSelector, inferenceOntModelSelector, config, null);
    }

    public WebappDaoFactoryJena(OntModelSelector ontModelSelector) {
        this(ontModelSelector, new WebappDaoFactoryConfig(), null);
    }

    public WebappDaoFactoryJena(OntModel ontModel) {
        this(new SimpleOntModelSelector(ontModel), new WebappDaoFactoryConfig(), null);
    }

    public OntModelSelector getOntModelSelector() {
        return this.ontModelSelector;
    }

    public OntModel getOntModel() {
        return this.ontModelSelector.getFullModel();
    }

    public static Dataset makeInMemoryDataset(Model assertions, Model inferences) {
        Dataset dataset = DatasetFactory.createMem();
        OntModel union = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        if (assertions != null) {
            dataset.addNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-2", assertions);
            union.addSubModel(assertions);
        }
        if (inferences != null) {
            dataset.addNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf", inferences);
            union.addSubModel(inferences);
        }
        dataset.setDefaultModel((Model)union);
        return dataset;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String checkURI(String uriStr) {
        String errorMessage = this.checkURIForValidity(uriStr);
        if (errorMessage != null) {
            return errorMessage;
        }
        if (this.hasExistingURI(uriStr)) {
            return "URI is already in use. Please enter another URI. ";
        }
        return null;
    }

    @Override
    public String checkURIForEditableEntity(String uriStr) {
        String errorMessage = this.checkURIForValidity(uriStr);
        if (errorMessage != null) {
            return errorMessage;
        }
        if (this.hasEditableEntity(uriStr)) {
            return "URI is already in use. Please enter another URI. ";
        }
        return null;
    }

    private String checkURIForValidity(String uriStr) {
        uriStr = uriStr == null ? " " : uriStr;
        IRI iri = IRIFactory.jenaImplementation().create(uriStr);
        if (iri.hasViolation(false)) {
            return ((Violation)iri.violations(false).next()).getShortMessage() + " ";
        }
        try {
            Resource res = ResourceFactory.createResource((String)uriStr);
            if (res.getLocalName().matches("\\d+")) {
                return "Localname must contain at least one non-numeric character.  Please enter another URI. ";
            }
        }
        catch (Exception e) {
            return "Not a valid URI.  Please enter another URI. ";
        }
        return null;
    }

    @Override
    public boolean hasExistingURI(String uriStr) {
        OntModel ontModel = this.ontModelSelector.getFullModel();
        return URIUtils.hasExistingURI(uriStr, ontModel);
    }

    private boolean hasEditableEntity(String uriStr) {
        OntModel ontModel = this.ontModelSelector.getFullModel();
        return URIUtils.hasEditableEntity(uriStr, ontModel);
    }

    @Override
    public WebappDaoFactory getUserAwareDaoFactory(String userURI) {
        return new WebappDaoFactoryJena(this, userURI);
    }

    @Override
    public String getUserURI() {
        return this.userURI;
    }

    @Override
    public String getDefaultNamespace() {
        return this.config.getDefaultNamespace();
    }

    @Override
    public List<String> getPreferredLanguages() {
        return this.config.getPreferredLanguages();
    }

    @Override
    public Set<String> getNonuserNamespaces() {
        return this.config.getNonUserNamespaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCommentsForResource(String resourceURI) {
        LinkedList<String> commentList;
        block7: {
            commentList = new LinkedList<String>();
            OntModel ontModel = this.ontModelSelector.getFullModel();
            ontModel.enterCriticalSection(true);
            try {
                OntResource res = ontModel.getOntResource(resourceURI);
                if (res == null) break block7;
                try (ExtendedIterator closeIt = res.listComments(null);){
                    ExtendedIterator commIt = closeIt;
                    while (commIt.hasNext()) {
                        Literal lit = (Literal)commIt.next();
                        commentList.add(lit.getLexicalForm());
                    }
                }
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        }
        return commentList;
    }

    @Override
    public IndividualDao getIndividualDao() {
        if (this.entityWebappDao != null) {
            return this.entityWebappDao;
        }
        this.entityWebappDao = new IndividualDaoJena(this);
        return this.entityWebappDao;
    }

    @Override
    public ApplicationDao getApplicationDao() {
        if (this.applicationDao != null) {
            return this.applicationDao;
        }
        this.applicationDao = new ApplicationDaoJena(this);
        return this.applicationDao;
    }

    @Override
    public VClassGroupDao getVClassGroupDao() {
        if (this.vClassGroupDao != null) {
            return this.vClassGroupDao;
        }
        this.vClassGroupDao = new VClassGroupDaoJena(this);
        return this.vClassGroupDao;
    }

    @Override
    public PropertyGroupDao getPropertyGroupDao() {
        if (this.propertyGroupDao != null) {
            return this.propertyGroupDao;
        }
        this.propertyGroupDao = new PropertyGroupDaoJena(this);
        return this.propertyGroupDao;
    }

    @Override
    public UserAccountsDao getUserAccountsDao() {
        if (this.userAccountsDao != null) {
            return this.userAccountsDao;
        }
        this.userAccountsDao = new UserAccountsDaoJena(this);
        return this.userAccountsDao;
    }

    @Override
    public DataPropertyStatementDao getDataPropertyStatementDao() {
        if (this.dataPropertyStatementDao == null) {
            this.dataPropertyStatementDao = new DataPropertyStatementDaoJena(this.dwf, this);
        }
        return this.dataPropertyStatementDao;
    }

    @Override
    public DatatypeDao getDatatypeDao() {
        if (this.datatypeDao == null) {
            this.datatypeDao = new DatatypeDaoJena(this);
        }
        return this.datatypeDao;
    }

    @Override
    public DataPropertyDao getDataPropertyDao() {
        if (this.dataPropertyDao == null) {
            this.dataPropertyDao = new DataPropertyDaoJena(this.rdfService, this.dwf, this);
        }
        return this.dataPropertyDao;
    }

    public IndividualDao getEntityDao() {
        if (this.individualDao == null) {
            this.individualDao = new IndividualDaoJena(this);
        }
        return this.individualDao;
    }

    @Override
    public ObjectPropertyStatementDao getObjectPropertyStatementDao() {
        if (this.objectPropertyStatementDao == null) {
            this.objectPropertyStatementDao = new ObjectPropertyStatementDaoJena(this.rdfService, this.dwf, this);
        }
        return this.objectPropertyStatementDao;
    }

    @Override
    public OntologyDao getOntologyDao() {
        if (this.ontologyDao == null) {
            this.ontologyDao = new OntologyDaoJena(this);
        }
        return this.ontologyDao;
    }

    @Override
    public ObjectPropertyDao getObjectPropertyDao() {
        if (this.objectPropertyDao == null) {
            this.objectPropertyDao = new ObjectPropertyDaoJena(this.rdfService, this.dwf, this.config.customListViewConfigFileMap, this);
        }
        return this.objectPropertyDao;
    }

    @Override
    public FauxPropertyDao getFauxPropertyDao() {
        if (this.fauxPropertyDao == null) {
            this.fauxPropertyDao = new FauxPropertyDaoJena(this);
        }
        return this.fauxPropertyDao;
    }

    @Override
    public PropertyInstanceDao getPropertyInstanceDao() {
        if (this.propertyInstanceDao == null) {
            this.propertyInstanceDao = new PropertyInstanceDaoJena(this.rdfService, this.dwf, this);
        }
        return this.propertyInstanceDao;
    }

    @Override
    public VClassDao getVClassDao() {
        if (this.vClassDao == null) {
            this.vClassDao = new VClassDaoJena(this, this.config.isUnderlyingStoreReasoned());
        }
        return this.vClassDao;
    }

    public JenaBaseDao getJenaBaseDao() {
        if (this.jenaBaseDao == null) {
            this.jenaBaseDao = new JenaBaseDao(this);
        }
        return this.jenaBaseDao;
    }

    @Override
    public PageDao getPageDao() {
        if (this.pageDao == null) {
            this.pageDao = new PageDaoJena(this);
        }
        return this.pageDao;
    }

    @Override
    public MenuDao getMenuDao() {
        if (this.menuDao == null) {
            this.menuDao = new MenuDaoJena(this);
        }
        return this.menuDao;
    }

    @Override
    public DisplayModelDao getDisplayModelDao() {
        return new DisplayModelDaoJena(this);
    }

    @Override
    public void close() {
        if (this.applicationDao != null) {
            this.applicationDao.close();
        }
    }

    public WebappDaoFactoryJena(WebappDaoFactoryJena base) {
        if (base.ontModelSelector instanceof OntModelSelectorImpl) {
            OntModelSelectorImpl selector = new OntModelSelectorImpl();
            selector.setABoxModel(base.ontModelSelector.getABoxModel());
            selector.setApplicationMetadataModel(base.ontModelSelector.getApplicationMetadataModel());
            selector.setDisplayModel(base.ontModelSelector.getDisplayModel());
            selector.setFullModel(base.ontModelSelector.getFullModel());
            selector.setTBoxModel(base.ontModelSelector.getTBoxModel());
            selector.setUserAccountsModel(base.ontModelSelector.getUserAccountsModel());
            this.ontModelSelector = selector;
        } else if (base.ontModelSelector instanceof SimpleOntModelSelector) {
            SimpleOntModelSelector selector = new SimpleOntModelSelector();
            selector.setABoxModel(base.ontModelSelector.getABoxModel());
            selector.setApplicationMetadataModel(base.ontModelSelector.getApplicationMetadataModel());
            selector.setDisplayModel(base.ontModelSelector.getDisplayModel());
            selector.setFullModel(base.ontModelSelector.getFullModel());
            selector.setTBoxModel(base.ontModelSelector.getTBoxModel());
            selector.setUserAccountsModel(base.ontModelSelector.getUserAccountsModel());
            this.ontModelSelector = selector;
        } else {
            this.ontModelSelector = base.ontModelSelector;
        }
        this.config = base.config;
        this.userURI = base.userURI;
        this.dwf = base.dwf;
    }

    public void setSpecialDataModel(OntModel specialModel, OntModel specialTboxModel, OntModel specialDisplayModel) {
        if (specialModel == null) {
            throw new IllegalStateException("specialModel must not be null");
        }
        OntModelSelector originalSelector = this.getOntModelSelector();
        OntModel unionModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        unionModel.addSubModel((Model)specialModel);
        OntModelSelectorImpl specialSelector = new OntModelSelectorImpl();
        specialSelector.setFullModel(unionModel);
        OntModel newApplicationModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        newApplicationModel.add((Model)specialModel);
        newApplicationModel.add((Model)originalSelector.getApplicationMetadataModel());
        specialSelector.setApplicationMetadataModel(newApplicationModel);
        if (specialDisplayModel != null) {
            specialSelector.setDisplayModel(specialDisplayModel);
            unionModel.addSubModel((Model)specialDisplayModel);
        } else {
            OntModel selectorDisplayModel = originalSelector.getDisplayModel();
            if (selectorDisplayModel != null) {
                specialSelector.setDisplayModel(originalSelector.getDisplayModel());
            }
        }
        if (specialTboxModel != null) {
            unionModel.addSubModel((Model)specialTboxModel);
            specialSelector.setTBoxModel(specialTboxModel);
        } else {
            OntModel selectorTboxModel = originalSelector.getTBoxModel();
            if (selectorTboxModel != null) {
                specialSelector.setTBoxModel(originalSelector.getTBoxModel());
            }
        }
        specialSelector.setABoxModel(specialModel);
        specialSelector.setUserAccountsModel(specialModel);
        WebappDaoFactoryJena specialWadfj = new WebappDaoFactoryJena(specialSelector);
        this.entityWebappDao = specialWadfj.getIndividualDao();
        this.vClassGroupDao = specialWadfj.getVClassGroupDao();
        this.propertyGroupDao = specialWadfj.getPropertyGroupDao();
        this.objectPropertyDao = specialWadfj.getObjectPropertyDao();
        this.objectPropertyStatementDao = specialWadfj.getObjectPropertyStatementDao();
        this.dataPropertyDao = specialWadfj.getDataPropertyDao();
        this.dataPropertyStatementDao = specialWadfj.getDataPropertyStatementDao();
        this.ontModelSelector = specialSelector;
    }

    public String makeLocalNameWithPrefix(ResourceBean bean) {
        OntologyDao oDao = this.getOntologyDao();
        Ontology o = oDao.getOntologyByURI(bean.getNamespace());
        if (o == null) {
            if ("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#".equals(bean.getNamespace())) {
                return "vitro:" + bean.getLocalName();
            }
            log.debug((Object)("no ontology object found for namespace " + bean.getNamespace()));
            return bean.getLocalName();
        }
        String prefix = o.getPrefix() == null ? (o.getName() == null ? "unspec" : o.getName()) : o.getPrefix();
        return prefix + ":" + bean.getLocalName();
    }

    public String makePickListName(ResourceBean bean) {
        OntologyDao oDao = this.getOntologyDao();
        Ontology o = oDao.getOntologyByURI(bean.getNamespace());
        String label = bean.getLabel() != null ? bean.getLabel() : bean.getLocalName();
        String string = label = label != null ? label : bean.getURI();
        if (o == null) {
            if ("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#".equals(bean.getNamespace())) {
                return label + " (vitro)";
            }
            log.debug((Object)("no ontology object found for namespace " + bean.getNamespace()));
            return label;
        }
        String prefix = o.getPrefix() == null ? (o.getName() == null ? "unspec" : o.getName()) : o.getPrefix();
        return label + " (" + prefix + ")";
    }
}

