/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.rdf.model.Literal;

public class DateTimeIntervalValidationVTwo
implements N3ValidatorVTwo {
    private static Log log = LogFactory.getLog(DateTimeIntervalValidationVTwo.class);
    private String startFieldName;
    private String endFieldName;
    private String templateName;
    private String startValueName;
    private String endValueName;
    private String startPrecisionName;
    private String endPrecisionName;

    public DateTimeIntervalValidationVTwo(String startFieldName, String endFieldName) {
        this.startFieldName = startFieldName;
        this.endFieldName = endFieldName;
        this.startValueName = startFieldName + "-value";
        this.endValueName = endFieldName + "-value";
        this.startPrecisionName = startFieldName + "-precision";
        this.endPrecisionName = endFieldName + "-precision";
    }

    public DateTimeIntervalValidationVTwo(String startFieldName, String endFieldName, String template) {
        this.templateName = template;
        this.startFieldName = startFieldName;
        this.endFieldName = endFieldName;
        this.startValueName = startFieldName + "-value";
        this.endValueName = endFieldName + "-value";
        this.startPrecisionName = startFieldName + "-precision";
        this.endPrecisionName = endFieldName + "-precision";
    }

    @Override
    public Map<String, String> validate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        Map<String, List<Literal>> existingLiterals = editConfig.getLiteralsInScope();
        List<Literal> existingStartYear = existingLiterals.get(this.startValueName);
        List<Literal> existingEndYear = existingLiterals.get(this.endValueName);
        Map<String, List<Literal>> literalsFromForm = editSub.getLiteralsFromForm();
        List<Literal> formStartYear = literalsFromForm.get(this.startValueName);
        List<Literal> formEndYear = literalsFromForm.get(this.endValueName);
        VitroVocabulary.Precision startPrecision = this.getPrecision(this.startPrecisionName, editConfig, editSub);
        VitroVocabulary.Precision endPrecision = this.getPrecision(this.endPrecisionName, editConfig, editSub);
        HashMap<String, String> errors = new HashMap<String, String>();
        if (this.templateName != null && this.templateName.equals("dateTimeIntervalForm.ftl") && this.literalListIsNull(formStartYear) && this.literalListIsNull(formEndYear)) {
            errors.put(this.startFieldName, "Date/time intervals must begin with a year. Please enter a start year, an end year or both.");
            return errors;
        }
        if (!this.literalListIsNull(formStartYear) && !this.literalListIsNull(formEndYear)) {
            int numberStartYears = formStartYear.size();
            int numberEndYears = formEndYear.size();
            if (numberStartYears > 1 && numberEndYears > 1) {
                errors.put(this.startFieldName, "DateTimeIntervalValidationVTwo does not support multiple start years or end years");
                return errors;
            }
            if (numberStartYears > 0 && numberEndYears > 0) {
                errors.putAll(this.checkDateLiterals(formStartYear.get(0), formEndYear.get(0), startPrecision, endPrecision));
            }
        } else if (!this.literalListIsNull(formStartYear) && !this.literalListIsNull(existingEndYear)) {
            int numberStartYears = formStartYear.size();
            int numberEndYears = existingEndYear.size();
            if (numberStartYears > 1 && numberEndYears > 1) {
                errors.put(this.startFieldName, "DateTimeIntervalValidationVTwo does not support multiple start years or end years");
                return errors;
            }
            if (numberStartYears > 0 && numberEndYears > 0) {
                errors.putAll(this.checkDateLiterals(formStartYear.get(0), existingEndYear.get(0), startPrecision, endPrecision));
            }
        } else if (!this.literalListIsNull(existingStartYear) && !this.literalListIsNull(formEndYear)) {
            int numberStartYears = existingStartYear.size();
            int numberEndYears = formEndYear.size();
            if (numberStartYears > 1 && numberEndYears > 1) {
                errors.put(this.startFieldName, "DateTimeIntervalValidationVTwo does not support multiple start years or end years");
                return errors;
            }
            if (numberStartYears > 0 && numberEndYears > 0) {
                errors.putAll(this.checkDateLiterals(existingStartYear.get(0), formEndYear.get(0), startPrecision, endPrecision));
            }
        } else if (!this.literalListIsNull(existingStartYear) && !this.literalListIsNull(existingEndYear)) {
            int numberStartYears = existingStartYear.size();
            int numberEndYears = existingEndYear.size();
            if (numberStartYears > 1 && numberEndYears > 1) {
                errors.put(this.startFieldName, "DateTimeIntervalValidationVTwo does not support multiple start years or end years");
                return errors;
            }
            if (numberStartYears > 0 && numberEndYears > 0) {
                errors.putAll(this.checkDateLiterals(existingStartYear.get(0), existingEndYear.get(0), startPrecision, endPrecision));
            }
        }
        if (errors.size() != 0) {
            return errors;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VitroVocabulary.Precision getPrecision(String precisionVarName, EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        if (editSub != null && editSub.getUrisFromForm() != null && editSub.getUrisFromForm().containsKey(precisionVarName)) {
            List<String> precisionStr = editSub.getUrisFromForm().get(precisionVarName);
            if (precisionStr.size() > 0) {
                String precisionString = precisionStr.get(0);
                VitroVocabulary.Precision precision = DateTimeWithPrecisionVTwo.toPrecision(precisionString);
                if (precision != null) return precision;
                log.debug((Object)("cannot convert " + precisionStr + " to a precision"));
                return null;
            } else {
                log.error((Object)"No precision strings returned");
            }
            return null;
        } else {
            if (editConfig == null || editConfig.getUrisInScope() == null || !editConfig.getUrisInScope().containsKey(precisionVarName)) return null;
            List<String> precisionStr = editConfig.getUrisInScope().get(precisionVarName);
            if (precisionStr.size() > 0) {
                String precisionString = precisionStr.get(0);
                VitroVocabulary.Precision precision = DateTimeWithPrecisionVTwo.toPrecision(precisionString);
                if (precision != null) return precision;
                log.warn((Object)("cannot convert " + precisionString + " to a precision"));
                return null;
            } else {
                log.error((Object)"No precision strings returned");
            }
        }
        return null;
    }

    private Map<String, String> checkDateLiterals(Literal startLit, Literal endLit, VitroVocabulary.Precision startPrecision, VitroVocabulary.Precision endPrecision) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (endPrecision == null) {
            return errors;
        }
        try {
            XSDDateTime startDate = (XSDDateTime)startLit.getValue();
            XSDDateTime endDate = (XSDDateTime)endLit.getValue();
            if (startDate != null && endDate != null) {
                Calendar startCal = startDate.asCalendar();
                Calendar endCal = endDate.asCalendar();
                if (endCal != null && !startCal.before(endCal)) {
                    if (startPrecision == VitroVocabulary.Precision.YEAR && endPrecision == VitroVocabulary.Precision.YEAR) {
                        errors.putAll(this.checkYears(startCal, endCal));
                    } else {
                        errors.put(this.startFieldName, "Start must be before end");
                        errors.put(this.endFieldName, "End must be after start");
                    }
                }
            }
        }
        catch (ClassCastException cce) {
            errors.put(this.startFieldName, "could not format start or end date");
            errors.put(this.endFieldName, "could not format start or end date");
            log.debug((Object)("could not format dates " + cce));
        }
        return errors;
    }

    private Map<? extends String, ? extends String> checkYears(Calendar startCal, Calendar endCal) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (endCal.get(1) < startCal.get(1)) {
            errors.put(this.startFieldName, "Start must be before end");
            errors.put(this.endFieldName, "End must be after start");
        }
        return errors;
    }

    private boolean literalListIsNull(List<Literal> literalList) {
        if (literalList == null) {
            return true;
        }
        boolean allNulls = true;
        for (Literal l : literalList) {
            if (l == null) continue;
            allNulls = false;
        }
        return allNulls;
    }
}

