/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.fields.FieldUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualsViaObjectPropetyOptions
implements FieldOptions {
    private static final Log log = LogFactory.getLog(IndividualsViaObjectPropetyOptions.class);
    private static final String LEFT_BLANK = "";
    private String subjectUri;
    private String predicateUri;
    private List<VClass> rangeTypes;
    private String objectUri;
    private VitroRequest vreq;
    private boolean hasSubclasses = true;
    private String defaultOptionLabel;

    public IndividualsViaObjectPropetyOptions(String subjectUri, String predicateUri, List<VClass> rangeTypes, String objectUri, VitroRequest vreq) throws Exception {
        if (subjectUri == null || subjectUri.equals(LEFT_BLANK)) {
            throw new Exception("no subjectUri found for field ");
        }
        if (predicateUri == null || predicateUri.equals(LEFT_BLANK)) {
            throw new Exception("no predicateUri found for field ");
        }
        this.subjectUri = subjectUri;
        this.predicateUri = predicateUri;
        this.rangeTypes = rangeTypes;
        this.objectUri = objectUri;
        this.vreq = vreq;
    }

    public IndividualsViaObjectPropetyOptions(String subjectUri, String predicateUri, String objectUri) throws Exception {
        this(subjectUri, predicateUri, null, objectUri);
    }

    public IndividualsViaObjectPropetyOptions(String subjectUri, String predicateUri, List<VClass> rangeTypes, String objectUri) throws Exception {
        this(subjectUri, predicateUri, rangeTypes, objectUri, null);
    }

    public IndividualsViaObjectPropetyOptions setDefaultOptionLabel(String label) {
        this.defaultOptionLabel = label;
        return this;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact) {
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        int optionsCount = 0;
        if (this.defaultOptionLabel != null) {
            optionsMap.put(LEFT_BLANK, this.defaultOptionLabel);
        }
        Individual subject = wDaoFact.getIndividualDao().getIndividualByURI(this.subjectUri);
        HashSet<String> vclassesURIs = this.getApplicableVClassURIs(subject, wDaoFact);
        if (!this.rangeTypes.isEmpty()) {
            vclassesURIs = this.filterToSubclassesOfRange(vclassesURIs, this.rangeTypes, wDaoFact);
            if (this.vreq != null && this.rangeTypes.size() == 1) {
                this.hasSubclasses = this.rangeHasSubclasses(this.rangeTypes.get(0), this.vreq);
            }
        }
        if (vclassesURIs.size() == 0) {
            return optionsMap;
        }
        List<Individual> individuals = new ArrayList<Individual>();
        HashSet<String> uriSet = new HashSet<String>();
        for (String vclassURI : vclassesURIs) {
            List<Individual> inds = wDaoFact.getIndividualDao().getIndividualsByVClassURI(vclassURI, -1, -1);
            for (Individual ind : inds) {
                if (uriSet.contains(ind.getURI())) continue;
                uriSet.add(ind.getURI());
                individuals.add(ind);
            }
        }
        List<ObjectPropertyStatement> stmts = subject.getObjectPropertyStatements();
        individuals = FieldUtils.removeIndividualsAlreadyInRange(individuals, stmts, this.predicateUri, this.objectUri);
        for (Individual ind : individuals) {
            String theType;
            String label;
            String uri = ind.getURI();
            if (uri == null || (label = ind.getRdfsLabel()) == null) continue;
            List<String> msTypes = ind.getMostSpecificTypeURIs();
            if (this.hasSubclasses && msTypes.size() > 0 && (theType = this.getMsTypeLocalName(msTypes.get(0), wDaoFact)).length() > 0) {
                label = label + " (" + theType + ")";
            }
            optionsMap.put(uri, label);
            ++optionsCount;
        }
        return optionsMap;
    }

    private HashSet<String> getApplicableVClassURIs(Individual subject, WebappDaoFactory wDaoFact) {
        HashSet<String> vclassesURIs = new HashSet<String>();
        if (!this.rangeTypes.isEmpty()) {
            StringBuilder rangeBuff = new StringBuilder();
            for (VClass rangeType : this.rangeTypes) {
                vclassesURIs.add(rangeType.getURI());
                rangeBuff.append(rangeType.getURI()).append(", ");
            }
            log.debug((Object)("individualsViaObjectProperty using rangeUri " + rangeBuff.toString()));
            return vclassesURIs;
        }
        log.debug((Object)"individualsViaObjectProperty not using any rangeUri");
        List<VClass> subjectVClasses = subject.getVClasses();
        for (VClass subjectVClass : subjectVClasses) {
            List<VClass> vclasses = wDaoFact.getVClassDao().getVClassesForProperty(subjectVClass.getURI(), this.predicateUri);
            if (vclasses == null) continue;
            for (VClass v : vclasses) {
                vclassesURIs.add(v.getURI());
            }
        }
        return vclassesURIs;
    }

    private HashSet<String> filterToSubclassesOfRange(HashSet<String> vclassesURIs, List<VClass> rangeTypes, WebappDaoFactory wDaoFact) {
        HashSet<String> filteredVClassesURIs = new HashSet<String>();
        VClassDao vcDao = wDaoFact.getVClassDao();
        for (String vclass : vclassesURIs) {
            for (VClass rangeType : rangeTypes) {
                if (!vclass.equals(rangeType.getURI()) && !vcDao.isSubClassOf(vclass, rangeType.getURI())) continue;
                filteredVClassesURIs.add(vclass);
            }
        }
        return filteredVClassesURIs;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return null;
    }

    private String getMsTypeLocalName(String theUri, WebappDaoFactory wDaoFact) {
        VClassDao vcDao = wDaoFact.getVClassDao();
        VClass vClass = vcDao.getVClassByURI(theUri);
        String theType = LEFT_BLANK;
        if (vClass == null) {
            return LEFT_BLANK;
        }
        theType = vClass.getName() == null ? LEFT_BLANK : vClass.getName();
        return theType;
    }

    private boolean rangeHasSubclasses(VClass uri, VitroRequest vreq) {
        String askQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nASK { ?something rdfs:subClassOf <" + uri.getURI() + "> }";
        try {
            return this.getRdfService((HttpServletRequest)vreq).sparqlAskQuery(askQuery);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private RDFService getRdfService(HttpServletRequest req) {
        return RDFServiceUtils.getRDFService(new VitroRequest(req));
    }
}

