/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.IdModelSelector;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.StandardModelSelector;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;

public abstract class BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    public static final String DEFAULT_NS_FOR_NEW_RESOURCE = "";

    void initBasics(EditConfigurationVTwo editConf, VitroRequest vreq) {
        String editKey = EditConfigurationUtils.getEditKey(vreq);
        editConf.setEditKey(editKey);
        String formUrl = EditConfigurationUtils.getFormUrlWithoutContext(vreq);
        editConf.setFormUrl(formUrl);
    }

    void initPropertyParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        editConfiguration.setSubjectUri(subjectUri);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setPredicateUri(predicateUri);
        editConfiguration.setUrlPatternToReturnTo("/individual");
        editConfiguration.setEntityToReturnTo(subjectUri);
    }

    void initObjectPropForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setObject(EditConfigurationUtils.getObjectUri(vreq));
    }

    void prepare(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        this.setupModelSelectorsFromVitroRequest(vreq, editConfig);
        OntModel queryModel = ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
        if (editConfig.getSubjectUri() == null) {
            editConfig.setSubjectUri(EditConfigurationUtils.getSubjectUri(vreq));
        }
        if (editConfig.getPredicateUri() == null) {
            editConfig.setPredicateUri(EditConfigurationUtils.getPredicateUri(vreq));
        }
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        Integer dataKey = EditConfigurationUtils.getDataHash(vreq);
        if (objectUri != null && !objectUri.trim().isEmpty()) {
            if (editConfig.getObject() == null) {
                editConfig.setObject(EditConfigurationUtils.getObjectUri(vreq));
            }
            editConfig.prepareForObjPropUpdate((Model)queryModel);
        } else if (dataKey != null) {
            editConfig.prepareForDataPropUpdate((Model)queryModel, vreq.getWebappDaoFactory().getDataPropertyDao());
        } else {
            editConfig.prepareForNonUpdate((Model)queryModel);
        }
    }

    public void setupModelSelectorsFromVitroRequest(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        if (!StringUtils.isEmpty((CharSequence)vreq.getNameForWriteModel())) {
            editConfig.setWriteModelSelector(new IdModelSelector(vreq.getNameForWriteModel()));
            editConfig.setWriteModelId(vreq.getNameForWriteModel());
        } else {
            editConfig.setWriteModelSelector(StandardModelSelector.selector);
        }
        if (!StringUtils.isEmpty((CharSequence)vreq.getNameForABOXModel())) {
            editConfig.setQueryModelSelector(new IdModelSelector(vreq.getNameForABOXModel()));
            editConfig.setResourceModelSelector(new IdModelSelector(vreq.getNameForABOXModel()));
            editConfig.setAboxModelId(vreq.getNameForABOXModel());
        } else {
            editConfig.setQueryModelSelector(StandardModelSelector.selector);
            editConfig.setResourceModelSelector(StandardModelSelector.selector);
        }
        if (!StringUtils.isEmpty((CharSequence)vreq.getNameForTBOXModel())) {
            editConfig.setTboxModelId(vreq.getNameForTBOXModel());
        }
    }

    static List<String> list(Object ... objs) {
        ArrayList<String> rv = new ArrayList<String>();
        for (Object obj : objs) {
            if (obj instanceof String) {
                rv.add((String)obj);
                continue;
            }
            if (obj instanceof Iterable) {
                for (Object innerObj : (Iterable)obj) {
                    if (innerObj instanceof String) {
                        rv.add((String)innerObj);
                        continue;
                    }
                    throw new Error("list may only take String and List<String>. It does not accept List<" + innerObj.getClass().getName() + ">");
                }
                continue;
            }
            throw new Error("list may only take String and List<String>. It does not accept " + obj.getClass().getName());
        }
        return rv;
    }
}

