/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage.impl;

import edu.cornell.mannlib.vitro.webapp.filestorage.impl.FileStorageHelper;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileAlreadyExistsException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileStorageImpl {
    public static final String FILE_STORAGE_ROOT = "file_storage_root";
    public static final String FILE_STORAGE_NAMESPACES_PROPERTIES = "file_storage_namespaces.properties";
    public static final int SHORTY_LENGTH = 3;
    private static final Log log = LogFactory.getLog(FileStorageImpl.class);
    private final File baseDir;
    private final File rootDir;
    private final File namespaceFile;
    private final Map<Character, String> namespacesMap;

    FileStorageImpl(File baseDir, Collection<String> namespaces) throws IOException {
        this.checkBaseDirValid(baseDir);
        this.checkNamespacesValid(namespaces);
        this.baseDir = baseDir;
        this.rootDir = new File(this.baseDir, FILE_STORAGE_ROOT);
        this.namespaceFile = new File(baseDir, FILE_STORAGE_NAMESPACES_PROPERTIES);
        if (this.rootDir.exists() && this.namespaceFile.exists()) {
            Map<Character, String> existingMap = this.readNamespaces();
            this.namespacesMap = this.adjustNamespaces(existingMap, namespaces);
            if (!this.namespacesMap.equals(existingMap)) {
                this.initializeNamespacesFile();
            }
        } else if (!this.rootDir.exists() && !this.namespaceFile.exists()) {
            this.namespacesMap = this.mapNamespaces(namespaces);
            this.initializeRootDirectory();
            this.initializeNamespacesFile();
        } else {
            if (this.rootDir.exists()) {
                throw new IllegalStateException("Storage directory '" + baseDir.getPath() + "' has been partially initialized. '" + FILE_STORAGE_ROOT + "' exists, but '" + FILE_STORAGE_NAMESPACES_PROPERTIES + "' does not.");
            }
            throw new IllegalStateException("Storage directory '" + baseDir.getPath() + "' has been partially initialized. '" + FILE_STORAGE_NAMESPACES_PROPERTIES + "' exists, but '" + FILE_STORAGE_ROOT + "' does not.");
        }
    }

    private void checkNamespacesValid(Collection<String> namespaces) {
        if (namespaces == null) {
            throw new NullPointerException("namespaces may not be null.");
        }
    }

    private void checkBaseDirValid(File baseDir) {
        if (baseDir == null) {
            throw new NullPointerException("baseDir may not be null.");
        }
        if (!baseDir.exists()) {
            throw new IllegalArgumentException("File upload directory does not exist: '" + baseDir.getPath() + "'");
        }
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("File upload directory is not a directory: '" + baseDir.getPath() + "'");
        }
        if (!baseDir.canWrite()) {
            throw new IllegalArgumentException("File upload directory is not writeable: '" + baseDir.getPath() + "'");
        }
    }

    private Map<Character, String> mapNamespaces(Collection<String> namespaces) {
        HashMap<Character, String> map = new HashMap<Character, String>();
        for (String namespace : namespaces) {
            map.put(this.findAvailableKey(map), namespace);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNamespacesFile() throws FileNotFoundException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(this.namespaceFile);
            for (Map.Entry<Character, String> entry : this.namespacesMap.entrySet()) {
                writer.println(entry.getKey() + " = " + entry.getValue());
            }
        }
    }

    private void initializeRootDirectory() throws IOException {
        boolean created = this.rootDir.mkdir();
        if (!created) {
            throw new IOException("Failed to create root directory '" + this.rootDir + "'");
        }
    }

    private Map<Character, String> readNamespaces() throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(this.namespaceFile);
            Properties props = new Properties();
            props.load(reader);
            HashMap<Character, String> map = new HashMap<Character, String>();
            for (Object key : props.keySet()) {
                char keyChar = key.toString().charAt(0);
                map.put(Character.valueOf(keyChar), (String)props.get(key));
            }
            HashMap<Character, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            throw new IOException("Problem loading the namespace file.");
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Map<Character, String> adjustNamespaces(Map<Character, String> existingMap, Collection<String> namespaces) {
        HashMap<Character, String> adjustedMap = new HashMap<Character, String>(existingMap);
        for (String namespace : namespaces) {
            if (existingMap.values().contains(namespace)) continue;
            log.warn((Object)("Adding a new namespace to the file storage system: " + namespace));
            Character key = this.findAvailableKey(adjustedMap);
            adjustedMap.put(key, namespace);
        }
        return adjustedMap;
    }

    private Character findAvailableKey(Map<Character, String> adjustedMap) {
        for (char key = 'a'; key <= 'z'; key = (char)(key + '\u0001')) {
            if (adjustedMap.keySet().contains(Character.valueOf(key))) continue;
            return Character.valueOf(key);
        }
        throw new IllegalArgumentException("Can't handle more than 26 namespaces.");
    }

    File getBaseDir() {
        return this.baseDir;
    }

    Map<Character, String> getNamespaces() {
        return this.namespacesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(String id, String filename, InputStream bytes) throws FileAlreadyExistsException, IOException {
        String existingFilename = this.getFilename(id);
        if (existingFilename != null && !filename.equals(existingFilename)) {
            throw new FileAlreadyExistsException(id, existingFilename, filename);
        }
        File file = FileStorageHelper.getFullPath(this.rootDir, id, filename, this.namespacesMap);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
            if (!parent.exists()) {
                throw new IOException("Failed to create parent directories for file with ID '" + id + "', file location '" + file + "'");
            }
        }
        OutputStream out = null;
        try {
            int howMany;
            out = new BufferedOutputStream(new FileOutputStream(file));
            BufferedInputStream in = new BufferedInputStream(bytes);
            byte[] buffer = new byte[4096];
            while (-1 != (howMany = ((InputStream)in).read(buffer))) {
                out.write(buffer, 0, howMany);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean deleteFile(String id) throws IOException {
        String existingFilename = this.getFilename(id);
        if (existingFilename == null) {
            return false;
        }
        File file = FileStorageHelper.getFullPath(this.rootDir, id, existingFilename, this.namespacesMap);
        file.delete();
        if (file.exists()) {
            throw new IOException("Failed to delete file with ID '" + id + "', file location '" + file + "'");
        }
        this.deleteEmptyParents(file);
        return true;
    }

    private void deleteEmptyParents(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            log.warn((Object)("This is crazy. How can file '" + file.getAbsolutePath() + "' have no parent?"));
            return;
        }
        if (parent.equals(this.rootDir)) {
            log.trace((Object)"Not deleting the root directory.");
            return;
        }
        File[] children = parent.listFiles();
        if (children == null) {
            log.warn((Object)("This is crazy. How can file '" + parent.getAbsolutePath() + "' not be a directory?"));
            return;
        }
        if (children.length > 0) {
            log.trace((Object)("Directory '" + parent.getAbsolutePath() + "' is not empty. Not deleting."));
            return;
        }
        log.trace((Object)("Deleting empty directory '" + parent.getAbsolutePath() + "'"));
        parent.delete();
        if (parent.exists()) {
            log.warn((Object)("Failed to delete directory '" + parent.getAbsolutePath() + "'"));
            return;
        }
        this.deleteEmptyParents(parent);
    }

    public String getFilename(String id) {
        File dir = FileStorageHelper.getPathToIdDirectory(id, this.namespacesMap, this.rootDir);
        log.debug((Object)("ID '" + id + "' translates to this directory path: '" + dir + "'"));
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        if (files.length == 0) {
            return null;
        }
        if (files.length > 1) {
            throw new IllegalStateException("More than one file associated with ID: '" + id + "', directory location '" + dir + "'");
        }
        return FileStorageHelper.decodeName(files[0].getName());
    }

    public InputStream getInputStream(String id, String filename) throws IOException {
        File file = FileStorageHelper.getFullPath(this.rootDir, id, filename, this.namespacesMap);
        if (!file.exists()) {
            throw new FileNotFoundException("No file exists with ID '" + id + "', file location '" + file + "'");
        }
        return new FileInputStream(file);
    }
}

