/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.FieldMap;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchQueryUtils;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchResultsParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebFilter(filterName="Caching Response filter", urlPatterns={"/*"})
public class CachingResponseFilter
implements Filter {
    private static final Log log = LogFactory.getLog(CachingResponseFilter.class);
    private static final String PROPERTY_DEFAULT_NAMESPACE = "Vitro.defaultNamespace";
    private static final String PROPERTY_ENABLE_CACHING = "http.createCacheHeaders";
    private static final String ETAG_FIELD = "etag";
    private static final FieldMap parserFieldMap = SearchQueryUtils.fieldMap().put("etag", "etag");
    private ServletContext ctx;
    private String defaultNamespace;
    private boolean enabled;

    public void init(FilterConfig fc) throws ServletException {
        this.ctx = fc.getServletContext();
        ConfigurationProperties props = ConfigurationProperties.getBean(this.ctx);
        this.defaultNamespace = props.getProperty(PROPERTY_DEFAULT_NAMESPACE);
        this.enabled = Boolean.valueOf(props.getProperty(PROPERTY_ENABLE_CACHING));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.enabled) {
            this.produceBasicResponse(req, resp, chain);
            return;
        }
        String individualUri = this.figureIndividualUriFromRequest(req);
        if (individualUri == null) {
            this.produceBasicResponse(req, resp, chain);
            return;
        }
        String rawEtag = this.findEtagForIndividual(individualUri);
        String etag = this.produceLanguageSpecificEtag(req, rawEtag);
        if (etag == null) {
            this.produceBasicResponse(req, resp, chain);
            return;
        }
        if (this.userIsLoggedIn(req)) {
            this.produceUncacheableResponse(req, resp, chain);
            return;
        }
        if (!this.isConditionalRequest(req)) {
            this.produceCacheableResponse(req, resp, chain, etag);
            return;
        }
        if (this.cacheIsStale(req, etag)) {
            this.produceCacheableResponse(req, resp, chain, etag);
            return;
        }
        this.produceCacheHitResponse(resp, etag);
    }

    private boolean isConditionalRequest(HttpServletRequest req) {
        if (req.getHeader("If-None-Match") == null) {
            log.debug((Object)"Not conditional request.");
            return false;
        }
        log.debug((Object)"Conditional request.");
        return true;
    }

    private boolean userIsLoggedIn(HttpServletRequest req) {
        UserAccount currentUser = LoginStatusBean.getCurrentUser(req);
        if (currentUser == null) {
            log.debug((Object)"Not logged in.");
            return false;
        }
        log.debug((Object)("Logged in as '" + currentUser.getEmailAddress() + "'"));
        return true;
    }

    private String figureIndividualUriFromRequest(HttpServletRequest req) {
        String requestPath = req.getRequestURI();
        if (requestPath == null) {
            return null;
        }
        if (!this.mightBeProfileRequest(requestPath)) {
            return null;
        }
        String[] pathParts = requestPath.split("/");
        String uri = this.defaultNamespace + pathParts[pathParts.length - 1];
        log.debug((Object)("Request path = '" + requestPath + "', uri = '" + uri + "'"));
        return uri;
    }

    private boolean mightBeProfileRequest(String requestPath) {
        String[] extensions;
        String path = requestPath.toLowerCase();
        for (String ext : extensions = new String[]{".css", ".js", ".gif", ".png", ".jpg", ".jpeg"}) {
            if (!path.endsWith(ext)) continue;
            return false;
        }
        return requestPath.endsWith("/individual") || requestPath.contains("/individual/") || requestPath.contains("/display/");
    }

    private String findEtagForIndividual(String individualUri) {
        SearchEngine search = ApplicationUtils.instance().getSearchEngine();
        SearchQuery query = search.createQuery("URI:" + individualUri).addFields(ETAG_FIELD);
        try {
            SearchResponse response = search.query(query);
            List<Map<String, String>> maps = new SearchResultsParser(response, parserFieldMap).parse();
            log.debug((Object)("Search response for '" + query.getQuery() + "' was " + maps));
            if (maps.isEmpty()) {
                return null;
            }
            return maps.get(0).get(ETAG_FIELD);
        }
        catch (SearchEngineException e) {
            log.warn((Object)("Search query '" + query.getQuery() + "' threw an exception"), (Throwable)e);
            return null;
        }
    }

    private String produceLanguageSpecificEtag(HttpServletRequest req, String rawEtag) {
        if (rawEtag == null) {
            return null;
        }
        List locales = EnumerationUtils.toList((Enumeration)req.getLocales());
        StringBuilder buffer = new StringBuilder("\"").append(rawEtag);
        for (Locale locale : locales) {
            buffer.append(locale.toString());
        }
        buffer.append("\"");
        String etag = buffer.toString().replaceAll("\\s", "");
        log.debug((Object)("Language-specific ETAG = " + etag));
        return etag;
    }

    private boolean cacheIsStale(HttpServletRequest req, String etag) {
        Enumeration values = req.getHeaders("If-None-Match");
        while (values.hasMoreElements()) {
            String[] matches;
            String value = (String)values.nextElement();
            log.debug((Object)("If-None-Match: " + value));
            for (String match : matches = value.split("\\s*,\\s*")) {
                if (!etag.equalsIgnoreCase(match) && !"*".equals(match)) continue;
                log.debug((Object)("Cache is not stale: etag=" + match));
                return false;
            }
        }
        log.debug((Object)"Cache is stale.");
        return true;
    }

    private void produceBasicResponse(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private void produceUncacheableResponse(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String etag = this.generateArbitraryUniqueEtag(req);
        log.debug((Object)("Produce uncacheable response: etag='" + etag + "'"));
        resp.addHeader("ETag", etag);
        resp.addHeader("Vary", "*");
        resp.addHeader("Cache-Control", "no-store");
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private void produceCacheableResponse(HttpServletRequest req, HttpServletResponse resp, FilterChain chain, String etag) throws IOException, ServletException {
        log.debug((Object)("Produce cacheable response: etag='" + etag + "'"));
        resp.addHeader("ETag", etag);
        resp.addHeader("Vary", "Accept-Language");
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    private void produceCacheHitResponse(HttpServletResponse resp, String etag) throws IOException {
        log.debug((Object)("Produce cache hit response: etag='" + etag + "'"));
        resp.addHeader("ETag", etag);
        resp.addHeader("Vary", "Accept-Language");
        resp.sendError(304, "Not Modified");
    }

    private String generateArbitraryUniqueEtag(HttpServletRequest req) {
        return String.format("%s-%d", req.getSession().getId(), System.currentTimeMillis());
    }
}

