/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@WebFilter(filterName="Session Timeout Limiting Filter", urlPatterns={"/*"})
public class SessionTimeoutLimitingFilter
implements Filter {
    private static final int TRIVIAL_SESSION_LIFETIME = 120;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter(servletRequest, servletResponse);
        this.limitTrivialSession(servletRequest);
    }

    private void limitTrivialSession(ServletRequest servletRequest) {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        if (LoginStatusBean.getBean(request).isLoggedIn()) {
            return;
        }
        session.setMaxInactiveInterval(120);
    }

    public void destroy() {
    }
}

