/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.selection;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleSelectorUtilities {
    private static final Log log = LogFactory.getLog(LocaleSelectorUtilities.class);

    public static String getImageUrl(VitroRequest vreq, Locale locale) throws FileNotFoundException {
        String filename = "select_locale_" + locale + ".";
        String themeDir = vreq.getAppBean().getThemeDir();
        String imageDirPath = "/" + themeDir + "i18n/images/";
        ServletContext ctx = vreq.getSession().getServletContext();
        Set resourcePaths = ctx.getResourcePaths(imageDirPath);
        if (resourcePaths != null) {
            for (String resourcePath : resourcePaths) {
                if (!resourcePath.contains(filename)) continue;
                String fullPath = vreq.getContextPath() + resourcePath;
                log.debug((Object)("Found image for " + locale + " at '" + fullPath + "'"));
                return fullPath;
            }
        }
        throw new FileNotFoundException("Can't find an image for " + locale);
    }
}

