/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice;

import java.util.List;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;

public abstract class ResultSetConsumer {
    private ResultSet resultSet;

    protected abstract void processQuerySolution(QuerySolution var1);

    protected void startProcessing() {
    }

    protected void endProcessing() {
    }

    public void processResultSet(ResultSet rs) {
        if (rs != null) {
            this.resultSet = rs;
            this.startProcessing();
            while (rs.hasNext()) {
                this.processQuerySolution(rs.next());
            }
            this.endProcessing();
        }
    }

    protected final List<String> getResultVars() {
        return this.resultSet.getResultVars();
    }

    public static class HasResult
    extends ResultSetConsumer {
        private boolean hasResult = false;

        @Override
        public void processResultSet(ResultSet rs) {
            this.hasResult = rs != null && rs.hasNext();
        }

        @Override
        protected void processQuerySolution(QuerySolution qs) {
            this.hasResult = true;
        }

        public boolean hasResult() {
            return this.hasResult;
        }
    }

    public static abstract class Chaining
    extends ResultSetConsumer {
        private ResultSetConsumer innerConsumer;

        protected Chaining(ResultSetConsumer innerConsumer) {
            this.innerConsumer = innerConsumer;
        }

        @Override
        protected void startProcessing() {
            this.chainStartProcessing();
        }

        @Override
        protected void endProcessing() {
            this.chainEndProcessing();
        }

        protected void chainProcessQuerySolution(QuerySolution qs) {
            if (this.innerConsumer != null) {
                this.innerConsumer.processQuerySolution(qs);
            }
        }

        protected void chainStartProcessing() {
            if (this.innerConsumer != null) {
                this.innerConsumer.startProcessing();
            }
        }

        protected void chainEndProcessing() {
            if (this.innerConsumer != null) {
                this.innerConsumer.endProcessing();
            }
        }
    }
}

