/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner.plugin;

import edu.cornell.mannlib.vitro.webapp.reasoner.ReasonerPlugin;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public abstract class SimpleBridgingRule
implements ReasonerPlugin {
    private static final Log log = LogFactory.getLog(SimpleBridgingRule.class);
    private Property assertedProp1;
    private Property assertedProp2;
    private Property inferredProp;
    private String queryStr;
    private String retractionTestString;
    private SimpleReasoner simpleReasoner;

    protected SimpleBridgingRule(String assertedProp1, String assertedProp2, String inferredProp) {
        this.assertedProp1 = ResourceFactory.createProperty((String)assertedProp1);
        this.assertedProp2 = ResourceFactory.createProperty((String)assertedProp2);
        this.inferredProp = ResourceFactory.createProperty((String)inferredProp);
        this.queryStr = "CONSTRUCT { \n  ?x <" + inferredProp + "> ?z \n} WHERE { \n  ?x <" + assertedProp1 + "> ?y . \n  ?y <" + assertedProp2 + "> ?z \n}";
        this.retractionTestString = "  ASK { \n  ?x <" + assertedProp1 + "> ?y . \n  ?y <" + assertedProp2 + "> ?z \n  } ";
    }

    @Override
    public boolean isConfigurationOnlyPlugin() {
        return false;
    }

    @Override
    public boolean isInterestedInAddedStatement(Statement stmt) {
        return this.isRelevantPredicate(stmt);
    }

    @Override
    public boolean isInterestedInRemovedStatement(Statement stmt) {
        return this.isRelevantPredicate(stmt);
    }

    @Override
    public void addedABoxStatement(Statement stmt, Model aboxAssertionsModel, Model aboxInferencesModel, OntModel TBoxInferencesModel) {
        if (!this.isInterestedInAddedStatement(stmt) || this.ignore(stmt)) {
            return;
        }
        Model inf = this.constructInferences(this.queryStr, stmt, aboxAssertionsModel);
        StmtIterator sit = inf.listStatements();
        while (sit.hasNext()) {
            Statement s = sit.nextStatement();
            if (this.simpleReasoner == null) continue;
            this.simpleReasoner.addInference(s, aboxInferencesModel);
        }
    }

    private boolean ignore(Statement stmt) {
        return stmt.getSubject().isAnon() || stmt.getObject().isAnon() || !stmt.getObject().isResource();
    }

    private Query createQuery(String queryString, Statement stmt, Statement statement2) {
        String queryStr = queryString;
        if (stmt.getPredicate().equals(this.assertedProp1)) {
            queryStr = queryStr.replace("?x", "<" + stmt.getSubject().getURI() + ">");
            queryStr = queryStr.replace("?y", "<" + ((Resource)stmt.getObject()).getURI() + ">");
        } else if (stmt.getPredicate().equals(this.assertedProp2)) {
            queryStr = queryStr.replace("?y", "<" + stmt.getSubject().getURI() + ">");
            queryStr = queryStr.replace("?z", "<" + ((Resource)stmt.getObject()).getURI() + ">");
        } else {
            return null;
        }
        if (statement2 != null) {
            queryStr = queryStr.replace("?x", "<" + stmt.getSubject().getURI() + ">");
            queryStr = queryStr.replace("?z", "<" + ((Resource)stmt.getObject()).getURI() + ">");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)queryStr);
        }
        Query query = null;
        try {
            query = QueryFactory.create((String)queryStr);
        }
        catch (QueryParseException e) {
            log.error((Object)("Unable to parse query for SimpleBridgingRule. \nThis may mean that one of the following URIs is malformed: \n" + stmt.getSubject() + "\n" + stmt.getObject() + "\n"));
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model constructInferences(String queryString, Statement stmt, Model aboxAssertionsModel) {
        Query query = this.createQuery(queryString, stmt, null);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)aboxAssertionsModel);){
            Model model = qe.execConstruct();
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removedABoxStatement(Statement stmt, Model aboxAssertionsModel, Model aboxInferencesModel, OntModel TBoxInferencesModel) {
        if (!this.isInterestedInRemovedStatement(stmt) || this.ignore(stmt)) {
            return;
        }
        Resource x = null;
        RDFNode z = null;
        if (stmt.getPredicate().equals(this.assertedProp1)) {
            x = stmt.getSubject();
        } else if (stmt.getPredicate().equals(this.assertedProp2)) {
            z = stmt.getObject();
        }
        for (Statement s : aboxInferencesModel.listStatements(x, this.inferredProp, z).toList()) {
            Query ask = this.createQuery(this.retractionTestString, stmt, s);
            try (QueryExecution qe = QueryExecutionFactory.create((Query)ask, (Model)aboxAssertionsModel);){
                if (qe.execAsk()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("==> removing " + s));
                }
                if (this.simpleReasoner == null) continue;
                this.simpleReasoner.removeInference(s, aboxInferencesModel);
            }
        }
    }

    private boolean isRelevantPredicate(Statement stmt) {
        return this.assertedProp1.equals(stmt.getPredicate()) || this.assertedProp2.equals(stmt.getPredicate());
    }

    @Override
    public void setSimpleReasoner(SimpleReasoner simpleReasoner) {
        this.simpleReasoner = simpleReasoner;
    }

    @Override
    public SimpleReasoner getSimpleReasoner() {
        return this.simpleReasoner;
    }
}

