/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.QueryConverter;
import edu.cornell.mannlib.vitro.webapp.searchengine.elasticsearch.ResponseParser;
import edu.cornell.mannlib.vitro.webapp.utils.http.HttpClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class ESQuery {
    private static final Log log = LogFactory.getLog(ESQuery.class);
    private final String baseUrl;

    public ESQuery(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public SearchResponse query(SearchQuery query) throws SearchEngineException {
        String queryString = new QueryConverter(query).asString();
        String response = this.doTheQuery(queryString);
        return new ResponseParser(response).parse();
    }

    private String doTheQuery(String queryString) {
        log.debug((Object)("QUERY: " + queryString));
        try {
            String url = this.baseUrl + "/_search";
            HttpResponse response = new ESFunkyGetRequest(url).bodyString(queryString, ContentType.APPLICATION_JSON).execute();
            String responseString = IOUtils.toString((InputStream)response.getEntity().getContent());
            log.debug((Object)("RESPONSE: " + responseString));
            return responseString;
        }
        catch (Exception e) {
            log.error((Object)"Failed to put to Elasticsearch", (Throwable)e);
            return "";
        }
    }

    private static class ESFunkyGetRequest
    extends HttpEntityEnclosingRequestBase {
        public ESFunkyGetRequest(String url) throws SearchEngineException {
            try {
                this.setURI(new URI(url));
            }
            catch (URISyntaxException e) {
                throw new SearchEngineException(e);
            }
        }

        public ESFunkyGetRequest bodyString(String contents, ContentType contentType) {
            this.setEntity((HttpEntity)new StringEntity(contents, contentType));
            return this;
        }

        public HttpResponse execute() throws SearchEngineException {
            try {
                return HttpClientFactory.getHttpClient().execute((HttpUriRequest)this);
            }
            catch (IOException e) {
                throw new SearchEngineException(e);
            }
        }

        public String getMethod() {
            return "GET";
        }
    }
}

