/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.exclusions;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluder;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExcludeBasedOnType
implements SearchIndexExcluder {
    private static final String SKIP_MSG = "skipping due to type: ";
    private final Set<String> typeURIs = new HashSet<String>();

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#excludes")
    public void addTypeURI(String uri) {
        this.typeURIs.add(uri);
    }

    @Override
    public String checkForExclusion(Individual ind) {
        if (ind == null) {
            return DONT_EXCLUDE;
        }
        ArrayList<VClass> vclasses = new ArrayList<VClass>();
        this.addToList(vclasses, ind.getVClasses());
        for (VClass vclz : vclasses) {
            if (!this.typeURIinExcludeList(vclz)) continue;
            return SKIP_MSG + vclz;
        }
        return DONT_EXCLUDE;
    }

    private void addToList(List<VClass> list, List<VClass> additions) {
        if (additions != null) {
            list.addAll(additions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean typeURIinExcludeList(VClass vclz) {
        if (vclz != null && vclz.getURI() != null && !vclz.isAnonymous()) {
            Set<String> set = this.typeURIs;
            synchronized (set) {
                return this.typeURIs.contains(vclz.getURI());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExcludedTypes(List<String> typeURIs) {
        List<String> list = typeURIs;
        synchronized (list) {
            this.typeURIs.clear();
            this.typeURIs.addAll(typeURIs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTypeToExclude(String typeURI) {
        if (typeURI != null && !typeURI.isEmpty()) {
            Set<String> set = this.typeURIs;
            synchronized (set) {
                this.typeURIs.add(typeURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTypeToExclude(String typeURI) {
        Set<String> set = this.typeURIs;
        synchronized (set) {
            this.typeURIs.remove(typeURI);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[typeURIs=" + this.typeURIs + "]";
    }
}

