/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.exclusions;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluder;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchIndexExcluderListDeveloper
implements SearchIndexExcluderList {
    private static final Log log = LogFactory.getLog(SearchIndexExcluderListDeveloper.class);
    private final List<ExcluderTiming> timings;
    private final AtomicInteger count = new AtomicInteger();

    public SearchIndexExcluderListDeveloper(Collection<? extends SearchIndexExcluder> excluders) {
        ArrayList<ExcluderTiming> list = new ArrayList<ExcluderTiming>();
        for (SearchIndexExcluder searchIndexExcluder : excluders) {
            list.add(new ExcluderTiming(searchIndexExcluder));
        }
        this.timings = Collections.unmodifiableList(list);
    }

    @Override
    public void startIndexing() {
    }

    @Override
    public boolean isExcluded(Individual ind) {
        this.count.incrementAndGet();
        for (ExcluderTiming timing : this.timings) {
            long startTime = System.currentTimeMillis();
            String message = timing.getExcluder().checkForExclusion(ind);
            timing.incrementCount();
            timing.addElapsedTime(System.currentTimeMillis() - startTime);
            if (message == SearchIndexExcluder.DONT_EXCLUDE) continue;
            log.debug((Object)("Excluded " + ind + " because " + message));
            return true;
        }
        return false;
    }

    @Override
    public void stopIndexing() {
        StringBuilder message = new StringBuilder(String.format("Timings for %d excluders after %d calls:", this.timings.size(), this.count.get()));
        for (ExcluderTiming timing : this.timings) {
            int thisCount = timing.getCount();
            int totalMillis = timing.getTotal();
            float totalSeconds = (float)totalMillis / 1000.0f;
            int average = thisCount == 0 ? 0 : totalMillis / thisCount;
            message.append(String.format("\n   count: %7d, total: %9.3fsec, average: %4dms-- %1.200s", thisCount, Float.valueOf(totalSeconds), average, timing.getExcluder()));
        }
        log.info((Object)message.toString());
    }

    private static class ExcluderTiming {
        private final SearchIndexExcluder excluder;
        private final AtomicInteger invocationCount = new AtomicInteger();
        private final AtomicLong totalElapsedMillis = new AtomicLong();

        public ExcluderTiming(SearchIndexExcluder excluder) {
            this.excluder = excluder;
        }

        public SearchIndexExcluder getExcluder() {
            return this.excluder;
        }

        public void incrementCount() {
            this.invocationCount.incrementAndGet();
        }

        public int getTotal() {
            return (int)this.totalElapsedMillis.get();
        }

        public int getCount() {
            return this.invocationCount.get();
        }

        public void addElapsedTime(long elapsed) {
            this.totalElapsedMillis.addAndGet(elapsed);
        }
    }
}

