/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.services.freemarker;

import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfiguration;
import edu.cornell.mannlib.vitro.webapp.services.freemarker.FreemarkerProcessingService;
import edu.cornell.mannlib.vitro.webapp.utils.log.LogUtils;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerProcessingServiceImpl
implements FreemarkerProcessingService {
    private static final Log log = LogFactory.getLog(FreemarkerProcessingServiceImpl.class);

    @Override
    public boolean isTemplateAvailable(String templateName, HttpServletRequest req) throws FreemarkerProcessingService.TemplateProcessingException {
        return null != this.getTemplate(templateName, req);
    }

    @Override
    public String renderTemplate(String templateName, Map<String, Object> map, HttpServletRequest req) throws FreemarkerProcessingService.TemplateProcessingException {
        log.debug((Object)("renderTemplate: '" + templateName + "' with " + LogUtils.deepFormatForLog(log, "debug", map)));
        Template template = this.getTemplate(templateName, req);
        return this.processTemplate(template, map, req);
    }

    private Template getTemplate(String templateName, HttpServletRequest req) throws FreemarkerProcessingService.TemplateProcessingException {
        Template template = null;
        try {
            Configuration config = FreemarkerConfiguration.getConfig(req);
            template = config.getTemplate(templateName);
        }
        catch (ParseException e) {
            log.warn((Object)("Failed to parse the template at '" + templateName + "'" + (Object)((Object)e)));
            throw new FreemarkerProcessingService.TemplateParsingException(e);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)("No template found for '" + templateName + "'"));
            throw new FreemarkerProcessingService.TemplateProcessingException(e);
        }
        catch (IOException e) {
            log.warn((Object)("Failed to read the template at '" + templateName + "'"), (Throwable)e);
            throw new FreemarkerProcessingService.TemplateProcessingException(e);
        }
        return template;
    }

    private String processTemplate(Template template, Map<String, Object> map, HttpServletRequest req) throws FreemarkerProcessingService.TemplateProcessingException {
        StringWriter writer = new StringWriter();
        try {
            template.process(map, (Writer)writer);
            return writer.toString();
        }
        catch (TemplateException e) {
            throw new FreemarkerProcessingService.TemplateProcessingException("TemplateException creating processing environment", e);
        }
        catch (IOException e) {
            throw new FreemarkerProcessingService.TemplateProcessingException("IOException creating processing environment", e);
        }
    }
}

