/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.JenaDataSourceSetupBase;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.RDFFilesLoader;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.vocabulary.RDF;

public class ContentModelSetup
extends JenaDataSourceSetupBase
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ContentModelSetup.class);

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        long begin = System.currentTimeMillis();
        this.setUpJenaDataSource(ctx);
        ss.info(this, this.secondsSince(begin) + " seconds to set up models and DAO factories");
    }

    private void setUpJenaDataSource(ServletContext ctx) {
        ContextModelAccess models = ModelAccess.on(ctx);
        boolean firstTimeStartup = false;
        OntModel applicationMetadataModel = models.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata");
        if (applicationMetadataModel.isEmpty()) {
            firstTimeStartup = true;
            this.initializeApplicationMetadata(ctx, (Model)applicationMetadataModel);
        } else {
            this.checkForNamespaceMismatch((Model)applicationMetadataModel, ctx);
        }
        OntModel baseABoxModel = models.getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
        if (firstTimeStartup) {
            RDFFilesLoader.loadFirstTimeFiles("abox", (Model)baseABoxModel, true);
        }
        RDFFilesLoader.loadEveryTimeFiles("abox", baseABoxModel);
        OntModel baseTBoxModel = models.getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
        if (firstTimeStartup) {
            RDFFilesLoader.loadFirstTimeFiles("tbox", (Model)baseTBoxModel, true);
        }
        RDFFilesLoader.loadEveryTimeFiles("tbox", baseTBoxModel);
    }

    private long secondsSince(long startTime) {
        return (System.currentTimeMillis() - startTime) / 1000L;
    }

    private void initializeApplicationMetadata(ServletContext ctx, Model applicationMetadataModel) {
        OntModel temporaryAMModel = VitroModelFactory.createOntologyModel();
        RDFFilesLoader.loadFirstTimeFiles("applicationMetadata", (Model)temporaryAMModel, true);
        this.setPortalUriOnFirstTime((Model)temporaryAMModel, ctx);
        applicationMetadataModel.add((Model)temporaryAMModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPortalUriOnFirstTime(Model model, ServletContext ctx) {
        Resource portalResource = null;
        try (ResIterator portalResIt = model.listSubjectsWithProperty(RDF.type, (RDFNode)model.getResource("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#Portal"));){
            Resource portalRes;
            if (portalResIt.hasNext() && (portalRes = (Resource)portalResIt.next()).isAnon()) {
                portalResource = portalRes;
            }
        }
        if (portalResource != null) {
            ResourceUtils.renameResource((Resource)portalResource, (String)(this.getDefaultNamespace(ctx) + "portal1"));
        }
    }

    private void checkForNamespaceMismatch(Model model, ServletContext ctx) {
        String expectedNamespace = this.getDefaultNamespace(ctx);
        List<Resource> portals = this.getPortal1s(model);
        if (!portals.isEmpty() && this.noPortalForNamespace(portals, expectedNamespace)) {
            Resource portal = portals.get(0);
            String oldNamespace = portal.getNameSpace();
            this.renamePortal(portal, expectedNamespace, model);
            StartupStatus ss = StartupStatus.getBean(ctx);
            ss.warning(this, "\nThe default namespace has been changed \nfrom " + oldNamespace + "\nto " + expectedNamespace + ".\nThe application will function normally, but any individuals in the \n" + oldNamespace + " namespace will need to have their URIs \nchanged in order to be served as linked data. You can use the Ingest Tools \nto change the URIs for a batch of resources.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Resource> getPortal1s(Model model) {
        ArrayList<Resource> portals = new ArrayList<Resource>();
        try {
            model.enterCriticalSection(true);
            ResIterator portalIt = model.listResourcesWithProperty(RDF.type, (RDFNode)this.PORTAL);
            while (portalIt.hasNext()) {
                Resource portal = portalIt.nextResource();
                if (!"portal1".equals(portal.getLocalName())) continue;
                portals.add(portal);
            }
        }
        finally {
            model.leaveCriticalSection();
        }
        return portals;
    }

    private boolean noPortalForNamespace(List<Resource> portals, String expectedNamespace) {
        for (Resource portal : portals) {
            if (!expectedNamespace.equals(portal.getNameSpace())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renamePortal(Resource portal, String namespace, Model model) {
        model.enterCriticalSection(false);
        try {
            ResourceUtils.renameResource((Resource)portal, (String)(namespace + portal.getLocalName()));
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

