/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ResultSetParser;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.StringResultsMapping;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;

class ModelSelectQueryContext
implements SparqlQueryRunner.SelectQueryContext {
    private static final Log log = LogFactory.getLog(ModelSelectQueryContext.class);
    private static final Syntax SYNTAX = Syntax.syntaxARQ;
    private final Model model;
    private final QueryHolder query;

    public ModelSelectQueryContext(Model model, QueryHolder query) {
        this.model = model;
        this.query = query;
    }

    @Override
    public ModelSelectQueryContext bindVariableToUri(String name, String uri) {
        return new ModelSelectQueryContext(this.model, this.query.bindToUri(name, uri));
    }

    @Override
    public ModelSelectQueryContext bindVariableToPlainLiteral(String name, String value) {
        return new ModelSelectQueryContext(this.model, this.query.bindToPlainLiteral(name, value));
    }

    public String toString() {
        return "ModelSelectQueryContext[query=" + this.query + "]";
    }

    @Override
    public SparqlQueryRunner.ExecutingSelectQueryContext execute() {
        return new ModelExecutingQueryContext(this.model, this.query);
    }

    private static class ModelExecutingQueryContext
    implements SparqlQueryRunner.ExecutingSelectQueryContext {
        private final Model model;
        private final QueryHolder query;

        public ModelExecutingQueryContext(Model model, QueryHolder query) {
            this.model = model;
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StringResultsMapping toStringFields(String ... names) {
            StringResultsMapping stringResultsMapping;
            String qString = this.query.getQueryString();
            HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(names));
            Query q = QueryFactory.create((String)qString, (Syntax)SYNTAX);
            QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)this.model);
            try {
                ResultSet results = qexec.execSelect();
                stringResultsMapping = new StringResultsMapping(results, fieldNames);
            }
            catch (Throwable throwable) {
                try {
                    qexec.close();
                    throw throwable;
                }
                catch (Exception e) {
                    log.error((Object)("problem while running query '" + qString + "'"), (Throwable)e);
                    return StringResultsMapping.EMPTY;
                }
            }
            qexec.close();
            return stringResultsMapping;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <T> T parse(ResultSetParser<T> parser) {
            String qString = this.query.getQueryString();
            try {
                Query q = QueryFactory.create((String)qString, (Syntax)SYNTAX);
                try (QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)this.model);){
                    T t = parser.parseResults(qString, qexec.execSelect());
                    return t;
                }
            }
            catch (Exception e) {
                log.error((Object)("problem while running query '" + qString + "'"), (Throwable)e);
                return parser.defaultValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToOutput(OutputStream output) {
            String qString = this.query.getQueryString();
            try {
                Query q = QueryFactory.create((String)qString, (Syntax)SYNTAX);
                try (QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)this.model);){
                    ResultSetFormatter.outputAsJSON((OutputStream)output, (ResultSet)qexec.execSelect());
                }
            }
            catch (Exception e) {
                log.error((Object)("problem while running query '" + qString + "'"), (Throwable)e);
            }
        }
    }
}

