/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.FauxPropertyDao;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PropertyTemplateModel
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(PropertyTemplateModel.class);
    protected final VitroRequest vreq;
    protected final String subjectUri;
    protected final Property property;
    protected final String propertyUri;
    protected String domainUri;
    protected String rangeUri;
    private final String localName;
    protected Map<String, Object> verboseDisplay;
    protected String addUrl;
    private String name;
    private FauxProperty fauxProperty;
    private int displayLimit;

    PropertyTemplateModel(Property property, Individual subject, VitroRequest vreq, String name) {
        this.vreq = vreq;
        this.subjectUri = subject.getURI();
        this.property = property;
        this.propertyUri = property.getURI();
        this.localName = property.getLocalName();
        this.name = name;
        this.addUrl = "";
        this.fauxProperty = this.isFauxProperty(property);
        if (this.fauxProperty != null) {
            this.name = this.fauxProperty.getDisplayName();
            this.displayLimit = this.fauxProperty.getDisplayLimit();
        }
        this.setVerboseDisplayValues(property);
    }

    protected void setVerboseDisplayValues(Property property) {
        String namespace = property.getNamespace();
        if ("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#".equals(namespace) || "http://vitro.mannlib.cornell.edu/ns/vitro/public#".equals(namespace)) {
            return;
        }
        Boolean verboseDisplayValue = (Boolean)this.vreq.getSession().getAttribute("verbosePropertyDisplay");
        if (!Boolean.TRUE.equals(verboseDisplayValue)) {
            return;
        }
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{SimplePermission.SEE_VERBOSE_PROPERTY_INFORMATION.ACTION})) {
            return;
        }
        this.verboseDisplay = new HashMap<String, Object>();
        BaseResourceBean.RoleLevel roleLevel = property.getHiddenFromDisplayBelowRoleLevel();
        String roleLevelLabel = roleLevel != null ? roleLevel.getDisplayLabel() : "";
        this.verboseDisplay.put("displayLevel", roleLevelLabel);
        roleLevel = property.getProhibitedFromUpdateBelowRoleLevel();
        roleLevelLabel = roleLevel != null ? roleLevel.getUpdateLabel() : "";
        this.verboseDisplay.put("updateLevel", roleLevelLabel);
        roleLevel = property.getHiddenFromPublishBelowRoleLevel();
        roleLevelLabel = roleLevel != null ? roleLevel.getDisplayLabel() : "";
        this.verboseDisplay.put("publishLevel", roleLevelLabel);
        this.verboseDisplay.put("localName", property.getLocalNameWithPrefix());
        this.verboseDisplay.put("displayRank", this.getPropertyDisplayTier(property));
        String editUrl = UrlBuilder.getUrl(this.getPropertyEditRoute(), "uri", property.getURI());
        this.verboseDisplay.put("propertyEditUrl", editUrl);
        if (this.fauxProperty != null) {
            this.verboseDisplay.put("fauxProperty", this.assembleFauxPropertyValues(this.fauxProperty));
        }
    }

    private FauxProperty isFauxProperty(Property prop) {
        FauxPropertyDao fpDao = this.vreq.getUnfilteredWebappDaoFactory().getFauxPropertyDao();
        return fpDao.getFauxPropertyByUris(prop.getDomainVClassURI(), prop.getURI(), prop.getRangeVClassURI());
    }

    private Map<String, Object> assembleFauxPropertyValues(FauxProperty fp) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String editUrl = UrlBuilder.getUrl("/editForm", "controller", "FauxProperty", "baseUri", fp.getBaseURI(), "domainUri", fp.getDomainURI(), "rangeUri", fp.getRangeURI());
        map.put("propertyEditUrl", editUrl);
        map.put("displayName", fp.getDisplayName());
        return map;
    }

    protected abstract int getPropertyDisplayTier(Property var1);

    protected abstract UrlBuilder.Route getPropertyEditRoute();

    public String toString() {
        return String.format("%s on %s", this.propertyUri != null ? this.propertyUri : "null Prop URI", this.subjectUri != null ? this.subjectUri : "null Sub URI");
    }

    public abstract String getType();

    public String getName() {
        return this.name;
    }

    public int getDisplayLimit() {
        return this.displayLimit;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getUri() {
        return this.propertyUri;
    }

    public String getRangeUri() {
        return this.rangeUri;
    }

    public String getDomainUri() {
        return this.domainUri;
    }

    public String getAddUrl() {
        return this.addUrl != null ? this.addUrl : "";
    }

    public boolean getIsFauxProperty() {
        return this.fauxProperty != null;
    }

    public Map<String, Object> getVerboseDisplay() {
        return this.verboseDisplay;
    }
}

