/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;

public class ListControllerTestBase
extends AbstractTestClass {
    protected static ObjectMapper mapper = new ObjectMapper();

    protected static ArrayNode arrayOf(JsonNode ... nodes) {
        ArrayNode array = mapper.createArrayNode();
        for (JsonNode node : nodes) {
            array.add(node);
        }
        return array;
    }

    protected static ObjectNode propertyListNode(String path, String uri, String name, String internalName, String domainVClass, String rangeVClass, String group) {
        String nameString = String.format("<a href='%s?uri=%s'>%s</a>", path, ListControllerTestBase.urlEncode(uri), name);
        ObjectNode propNode = mapper.createObjectNode().put("name", nameString);
        propNode.putObject("data").put("internalName", internalName).put("domainVClass", domainVClass).put("rangeVClass", rangeVClass).put("group", group);
        return propNode;
    }

    protected static ObjectNode propertyHierarchyNode(String path, String uri, String name, String internalName, String domainVClass, String rangeVClass, String group, ObjectNode ... children) {
        ObjectNode propNode = ListControllerTestBase.propertyListNode(path, uri, name, internalName, domainVClass, rangeVClass, group);
        propNode.set("children", (JsonNode)ListControllerTestBase.arrayOf((JsonNode[])children));
        return propNode;
    }

    protected static ObjectNode degenerateVclassListNode(String name, String shortDef, String classGroup, String ontology) {
        ObjectNode vcNode = mapper.createObjectNode().put("name", name);
        vcNode.putObject("data").put("shortDef", shortDef).put("classGroup", classGroup).put("ontology", ontology);
        return vcNode;
    }

    protected static ObjectNode vclassListNode(String path, String uri, String name, String shortDef, String classGroup, String ontology) {
        String nameString = String.format("<a href='%s?uri=%s'>%s</a>", path, ListControllerTestBase.urlEncode(uri), name);
        ObjectNode vcNode = mapper.createObjectNode().put("name", nameString);
        vcNode.putObject("data").put("shortDef", shortDef).put("classGroup", classGroup).put("ontology", ontology);
        return vcNode;
    }

    protected static ObjectNode vclassHierarchyNode(String path, String uri, String name, String shortDef, String classGroup, String ontology, ObjectNode ... children) {
        ObjectNode vcNode = ListControllerTestBase.vclassListNode(path, uri, name, shortDef, classGroup, ontology);
        vcNode.set("children", (JsonNode)ListControllerTestBase.arrayOf((JsonNode[])children));
        return vcNode;
    }

    protected static ObjectNode groupListNode(String linkFormat, String uri, String name, String displayRank, ObjectNode ... children) {
        String nameString = String.format(linkFormat, ListControllerTestBase.urlEncode(uri), name);
        ObjectNode gNode = mapper.createObjectNode().put("name", nameString);
        gNode.putObject("data").put("displayRank", displayRank);
        gNode.set("children", (JsonNode)ListControllerTestBase.arrayOf((JsonNode[])children));
        return gNode;
    }

    protected static ObjectNode groupMemberNode(String linkFormat, String uri, String name, String shortDef, ObjectNode ... children) {
        String nameString = String.format(linkFormat, ListControllerTestBase.urlEncode(uri), name);
        ObjectNode memberNode = mapper.createObjectNode().put("name", nameString);
        memberNode.putObject("data").put("shortDef", shortDef);
        memberNode.set("children", (JsonNode)ListControllerTestBase.arrayOf((JsonNode[])children));
        return memberNode;
    }

    protected static void assertMatchingJson(FreemarkerHttpServlet controller, HttpServletRequest req, JsonNode expected) throws Exception {
        String jsonString = ListControllerTestBase.getJsonFromController(controller, req);
        JsonNode actual = mapper.readTree("[" + jsonString + "]");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected static String getJsonFromController(FreemarkerHttpServlet controller, HttpServletRequest req) throws Exception {
        ResponseValues rv = controller.processRequest(new VitroRequest(req));
        Assert.assertTrue((boolean)(rv instanceof TemplateResponseValues));
        TemplateResponseValues trv = (TemplateResponseValues)rv;
        Object o = trv.getMap().get("jsonTree");
        Assert.assertTrue((boolean)(o instanceof String));
        String jsonString = (String)o;
        return jsonString;
    }

    protected void assertKlugedJson(JsonNode expected, String klugedActualString) throws Exception {
        JsonNode actual = mapper.readTree("[" + klugedActualString + "]");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static String urlEncode(String uri) {
        try {
            return URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return uri;
        }
    }
}

