/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListPropertyGroupsController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ListPropertyGroupsControllerTest
extends ListControllerTestBase {
    private static final String LINK_FORMAT_GROUP = "<a href='./editForm?uri=%s&amp;controller=PropertyGroup'>%s</a>";
    private static final String LINK_FORMAT_DATA_PROPERTY = "<a href='datapropEdit?uri=%s'>%s</a>";
    private static final String LINK_FORMAT_OBJECT_PROPERTY = "<a href='propertyEdit?uri=%s'>%s</a>";
    private static final String GROUP1 = "http://ont1/group1";
    private static final String GROUP2 = "http://ont1/group2";
    private static final String DP1 = "http://ont1/dp1";
    private static final String DP2 = "http://ont1/dp2";
    private static final String OP1 = "http://ont1/op1";
    private static final String OP2 = "http://ont1/op2";
    private static final String DP2_NAME = "A second data property";
    private static final String OP2_DOMAIN_PUBLIC = "The second domain";
    private static final int GROUP1_RANK = 5;
    private static final String GROUP2_NAME = "The Second Group";
    private static final JsonNode JSON_EMPTY_RESPONSE = ListPropertyGroupsControllerTest.arrayOf(new JsonNode[0]);
    private static final JsonNode JSON_FULL_RESPONSE = ListPropertyGroupsControllerTest.arrayOf(new JsonNode[]{ListPropertyGroupsControllerTest.groupListNode("<a href='./editForm?uri=%s&amp;controller=PropertyGroup'>%s</a>", "http://ont1/group2", "The Second Group", "", ListPropertyGroupsControllerTest.groupMemberNode("<a href='datapropEdit?uri=%s'>%s</a>", "http://ont1/dp1", null, "", new ObjectNode[0]), ListPropertyGroupsControllerTest.groupMemberNode("<a href='datapropEdit?uri=%s'>%s</a>", "http://ont1/dp2", "A second data property", "", new ObjectNode[0]), ListPropertyGroupsControllerTest.groupMemberNode("<a href='propertyEdit?uri=%s'>%s</a>", "http://ont1/op1", null, "", new ObjectNode[0]), ListPropertyGroupsControllerTest.groupMemberNode("<a href='propertyEdit?uri=%s'>%s</a>", "http://ont1/op2", "The second domain", "", new ObjectNode[0])), ListPropertyGroupsControllerTest.groupListNode("<a href='./editForm?uri=%s&amp;controller=PropertyGroup'>%s</a>", "http://ont1/group1", "(unnamed group)", "5", new ObjectNode[0])});
    private ListPropertyGroupsController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private WebappDaoFactoryStub wadf;
    private PropertyGroupDaoStub pgdao;

    @Before
    public void setup() {
        this.controller = new ListPropertyGroupsController();
        this.req = new HttpServletRequestStub();
        this.pgdao = new PropertyGroupDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setPropertyGroupDao(this.pgdao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.PolicyOption.POLICY_NEUTRAL});
    }

    @Test
    public void noData() throws Exception {
        ListPropertyGroupsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, JSON_EMPTY_RESPONSE);
    }

    @Test
    public void basicJsonTest() throws Exception {
        this.populate();
        ListPropertyGroupsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, JSON_FULL_RESPONSE);
    }

    private void populate() {
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP1, "", 5, new Property[0]));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP2, GROUP2_NAME, -1, new Property[]{this.dataProperty(DP1, null), this.dataProperty(DP2, DP2_NAME), this.objectProperty(OP1, null), this.objectProperty(OP2, OP2_DOMAIN_PUBLIC)}));
    }

    private PropertyGroup propertyGroup(String uri, String name, int displayRank, Property ... properties) {
        PropertyGroup pg = new PropertyGroup();
        pg.setURI(uri);
        pg.setName(name);
        pg.setDisplayRank(displayRank);
        pg.setPropertyList(new ArrayList<Property>(Arrays.asList(properties)));
        return pg;
    }

    private ObjectProperty objectProperty(String uri, String name) {
        ObjectProperty op = new ObjectProperty();
        op.setURI(uri);
        op.setDomainPublic(name);
        return op;
    }

    private DataProperty dataProperty(String uri, String name) {
        DataProperty dp = new DataProperty();
        dp.setURI(uri);
        dp.setName(name);
        return dp;
    }
}

