/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListVClassWebappsController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.Collator;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.OntologyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ListVClassWebappsControllerTest
extends ListControllerTestBase {
    private static final String PATH = "./vclassEdit";
    private static final String ONT1 = "http://ont1/";
    private static final String ONT2 = "http://ont2/";
    private static final String ONT3 = "http://ont3/";
    private static final String ONT2_NAME = "Fabulous Ontology";
    private static final String VC1 = "http://ont1/vc1";
    private static final String VC2 = "http://ont2/vc2";
    private static final String VC3 = "http://ont2/vc3";
    private static final String VC4 = "http://ont1/vc4";
    private static final String VC2_NAME = "Carol";
    private static final String VC3_NAME = "Ted";
    private static final String VC4_NAME = "ALice";
    private static final String VC2_SHORT_DEF = "Short Carol";
    private static final String VC3_SHORT_DEF = "Tiny Ted";
    private static final String VC4_SHORT_DEF = "Wee ALice";
    private static final String GROUP_NONE = "http://domain/noSuchGroup";
    private static final String GROUP_NO_NAME = "http://domain/groupWithNoName";
    private static final String GROUP_W_NAME = "http://domain/namedGroup";
    private static final String NAME_GROUP = "The Groupsters";
    private static final JsonNode JSON_EMPTY_RESPONSE = ListVClassWebappsControllerTest.arrayOf(new JsonNode[0]);
    private static final JsonNode RESPONSE_UNFILTERED = ListVClassWebappsControllerTest.arrayOf(new JsonNode[]{ListVClassWebappsControllerTest.vclassListNode("./vclassEdit", "http://ont1/vc4", "ALice", "Wee ALice", "The Groupsters", "http://ont1/"), ListVClassWebappsControllerTest.vclassListNode("./vclassEdit", "http://ont2/vc2", "Carol", "Short Carol", "", "Fabulous Ontology"), ListVClassWebappsControllerTest.vclassListNode("./vclassEdit", "http://ont2/vc3", "Ted", "Tiny Ted", "", "Fabulous Ontology"), ListVClassWebappsControllerTest.degenerateVclassListNode("", "", "", "http://ont1/")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT1 = ListVClassWebappsControllerTest.arrayOf(new JsonNode[]{ListVClassWebappsControllerTest.vclassListNode("./vclassEdit", "http://ont1/vc4", "ALice", "Wee ALice", "The Groupsters", "http://ont1/"), ListVClassWebappsControllerTest.degenerateVclassListNode("", "", "", "http://ont1/")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT2 = ListVClassWebappsControllerTest.arrayOf(new JsonNode[]{ListVClassWebappsControllerTest.vclassListNode("./vclassEdit", "http://ont2/vc2", "Carol", "Short Carol", "", "Fabulous Ontology"), ListVClassWebappsControllerTest.vclassListNode("./vclassEdit", "http://ont2/vc3", "Ted", "Tiny Ted", "", "Fabulous Ontology")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT3 = ListVClassWebappsControllerTest.arrayOf(new JsonNode[0]);
    private ListVClassWebappsController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private WebappDaoFactoryStub wadf;
    private OntologyDaoStub odao;
    private VClassDaoStub vcdao;
    private VClassGroupDaoStub vcgdao;

    @Before
    public void setup() {
        this.controller = new ListVClassWebappsController();
        this.req = new HttpServletRequestStub();
        new VitroRequest((HttpServletRequest)this.req).setCollator(Collator.getInstance());
        this.odao = new OntologyDaoStub();
        this.vcdao = new VClassDaoStub();
        this.vcgdao = new VClassGroupDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setOntologyDao(this.odao);
        this.wadf.setVClassDao(this.vcdao);
        this.wadf.setVClassGroupDao(this.vcgdao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.PolicyOption.POLICY_NEUTRAL});
    }

    @Test
    public void noData() throws Exception {
        ListVClassWebappsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, JSON_EMPTY_RESPONSE);
    }

    @Test
    public void unfiltered() throws Exception {
        this.populate();
        String rawResponse = ListVClassWebappsControllerTest.getJsonFromController((FreemarkerHttpServlet)this.controller, this.req);
        String kluged = rawResponse.replace("\"\"\"", "\"\",\"");
        this.assertKlugedJson(RESPONSE_UNFILTERED, kluged);
    }

    @Test
    public void filteredByOnt1() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT1);
        String rawResponse = ListVClassWebappsControllerTest.getJsonFromController((FreemarkerHttpServlet)this.controller, this.req);
        String kluged = rawResponse.replace("\"\"\"", "\"\",\"").replace(", , ,", ",");
        this.assertKlugedJson(RESPONSE_FILTERED_BY_ONT1, kluged);
    }

    @Test
    public void filteredByOnt2() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT2);
        String rawResponse = ListVClassWebappsControllerTest.getJsonFromController((FreemarkerHttpServlet)this.controller, this.req);
        String kluged = rawResponse.replaceAll(", $", " ");
        this.assertKlugedJson(RESPONSE_FILTERED_BY_ONT2, kluged);
    }

    @Test
    public void filteredByOnt3() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT3);
        ListVClassWebappsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT3);
    }

    private void populate() {
        this.odao.insertNewOntology(this.ontology(ONT2, ONT2_NAME));
        this.odao.insertNewOntology(this.ontology(ONT3, null));
        this.vcgdao.setGroups(this.vclassGroup(GROUP_NO_NAME, null));
        this.vcgdao.setGroups(this.vclassGroup(GROUP_W_NAME, NAME_GROUP));
        this.vcdao.setVClass(this.vclass(VC1, null, null, null));
        this.vcdao.setVClass(this.vclass(VC2, VC2_NAME, VC2_SHORT_DEF, GROUP_NONE));
        this.vcdao.setVClass(this.vclass(VC3, VC3_NAME, VC3_SHORT_DEF, GROUP_NO_NAME));
        this.vcdao.setVClass(this.vclass(VC4, VC4_NAME, VC4_SHORT_DEF, GROUP_W_NAME));
    }

    private VClass vclass(String uri, String name, String shortDef, String groupURI) {
        VClass vc = new VClass();
        vc.setURI(uri);
        if (name != null) {
            vc.setName(name);
            vc.setPickListName(name);
        }
        if (shortDef != null) {
            vc.setShortDef(shortDef);
        }
        if (groupURI != null) {
            vc.setGroupURI(groupURI);
        }
        return vc;
    }

    private VClassGroup vclassGroup(String uri, String name) {
        VClassGroup vcg = new VClassGroup();
        vcg.setURI(uri);
        vcg.setPublicName(name);
        return vcg;
    }

    private Ontology ontology(String uri, String name) {
        Ontology o = new Ontology();
        o.setURI(uri);
        o.setName(name);
        return o;
    }
}

