/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.jena.DependentResourceDeleteJena;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.XSD;
import org.junit.Assert;
import org.junit.Test;

public class DependentResourceDeleteJenaTest {
    String isDependentRelation = " <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#stubObjectPropertyAnnot> \"true\"^^xsd:boolean .\n";
    String nosePropIsDependentRel = "<http://vitro.mannlib.cornell.edu/ns/vitro/0.7#stubObjectPropertyAnnot> rdf:type owl:AnnotationProperty .\n ex:hasNose " + this.isDependentRelation;
    String prefixesN3 = "@prefix vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> . \n@prefix xsd: <" + XSD.getURI() + "> . \n @prefix ex: <http://example.com/> . \n@prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> . \n@prefix owl:  <http://www.w3.org/2002/07/owl#> . \n";

    void printModels(Model expected, Model result) {
        System.out.println("Expected:");
        expected.write((OutputStream)System.out);
        System.out.println("Result:");
        result.write((OutputStream)System.out);
    }

    @Test
    public void testStmtNormalDelete() {
        String n3 = this.prefixesN3 + " ex:bob ex:hasNose ex:nose1 .  ";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        Model resultModel = ModelFactory.createDefaultModel();
        resultModel.add(deletes);
        Assert.assertTrue((boolean)resultModel.isIsomorphicWith(model));
    }

    @Test
    public void testStmtSimpleForceDelete() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        Model resultModel = ModelFactory.createDefaultModel();
        resultModel.add(deletes);
        Assert.assertTrue((boolean)resultModel.isIsomorphicWith(expectedModel));
    }

    @Test
    public void testStmtNonForceDelete() {
        String n3 = this.prefixesN3 + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + " ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithLiterals() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithSimpleCycles() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:c ex:bob .";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithCycles() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:c ex:bob . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:c ex:bob . \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithCycles2() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:c ex:nose1 . \n ex:nose1 ex:c ex:bob . \n";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithLinks() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:c ex:glasses65 . \n ex:glasses65 ex:c ex:nose1 . \n ex:glasses65 ex:a \"glasses 65\" .";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:glasses65 ex:a \"glasses 65\" .";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)model.createStatement(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)model.createResource("http://example.com/nose1")), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithBNodes() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose [ \n    ex:a \"this is a bnode\"; \n    ex:c ex:glasses65 ] . \n ex:glasses65 ex:a \"glasses 65\" .";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:glasses65 ex:a \"glasses 65\" .";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        StmtIterator stmtIt = model.listStatements(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)null);
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)stmtIt.nextStatement(), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testStmtForceDeleteWithNestedBNodes() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose [ \n    ex:a \"this is a bnode\"; \n    ex:c ex:glasses65 ; \n    ex:c [            ex:a \"this is a nested bnode\" ] ] . \n ex:glasses65 ex:a \"glasses 65\" .";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:glasses65 ex:a \"glasses 65\" .";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        StmtIterator stmtIt = model.listStatements(model.createResource("http://example.com/bob"), model.createProperty("http://example.com/hasNose"), (RDFNode)null);
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Statement)stmtIt.nextStatement(), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResNormalDelete() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:hasNose ex:nose1 .  ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel;
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/nose1"), (Model)model);
        Model resultModel = model.remove(deletes);
        boolean same = resultModel.isIsomorphicWith(expectedModel);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResSimpleForceDelete() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:hair23 ex:hasHairCount \"23\". ";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/nose1"), (Model)model);
        Model resultModel = model.remove(deletes);
        boolean same = resultModel.isIsomorphicWith(expectedModel);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResNonForceDelete() {
        String n3 = this.prefixesN3 + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + " ex:hair23 ex:hasHairCount \"23\". ";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/nose1"), (Model)model);
        Model resultModel = model.remove(deletes);
        boolean same = resultModel.isIsomorphicWith(expectedModel);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResNonForceDelete2() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:hair23 ex:hasHairCount \"23\". ";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/nose1"), (Model)model);
        Model resultModel = model.remove(deletes);
        boolean same = resultModel.isIsomorphicWith(expectedModel);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResForceDeleteWithLiterals() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/nose1"), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResForceDeleteWithCycles() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:c ex:bob . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:c ex:bob . \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/nose1"), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResForceDeleteWithCycles2() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:c ex:nose1 . \n ex:nose1 ex:c ex:bob . \n";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel;
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/bob"), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testResForceDeleteWithLinks() {
        String n3 = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:c ex:glasses65 . \n ex:glasses65 ex:c ex:nose1 . \n ex:glasses65 ex:a \"glasses 65\" .";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:glasses65 ex:a \"glasses 65\" .";
        Model model = ModelFactory.createDefaultModel().read((Reader)new StringReader(n3), "", "N3");
        List deletes = DependentResourceDeleteJena.getDependentResourceDeleteList((Resource)model.createResource("http://example.com/nose1"), (Model)model);
        model.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(model);
        if (!same) {
            this.printModels(expectedModel, model);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testDeleteForChange() {
        String source = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + "ex:hasHair " + this.isDependentRelation + " ex:bob ex:a \"Bob\".   \n";
        String retractions = "@prefix ex: <http://example.com/> . \n ex:bob ex:hasNose ex:nose1 . ";
        Model sourceModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(source), "", "N3");
        Model additionsModel = ModelFactory.createDefaultModel();
        Model retractionsModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(retractions), "", "N3");
        Model deletes = DependentResourceDeleteJena.getDependentResourceDeleteForChange((Model)additionsModel, (Model)retractionsModel, (Model)sourceModel);
        sourceModel.remove(retractionsModel);
        sourceModel.remove(deletes);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(sourceModel);
        if (!same) {
            this.printModels(expectedModel, sourceModel);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testDeleteForChangeWithReplace() {
        String source = this.prefixesN3 + this.nosePropIsDependentRel + " ex:bob ex:a \"Bob\".   \n ex:jim ex:a \"Jim\".   \n ex:bob ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String expected = this.prefixesN3 + this.nosePropIsDependentRel + " ex:jim ex:a \"Jim\".   \n ex:bob ex:a \"Bob\".   \n ex:jim ex:hasNose ex:nose1 .   \n ex:nose1 ex:a \"this is a literal\". \n ex:nose1 ex:b \"2343\" . \n ex:nose1 ex:hasHair ex:hair23. \n ex:hair23 ex:hasHairCount \"23\". ";
        String additions = "@prefix ex: <http://example.com/> . \n ex:jim ex:hasNose ex:nose1 . ";
        String retractions = "@prefix ex: <http://example.com/> . \n ex:bob ex:hasNose ex:nose1 . ";
        Model sourceModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(source), "", "N3");
        Model additionsModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(additions), "", "N3");
        Model retractionsModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(retractions), "", "N3");
        Model depDeletes = DependentResourceDeleteJena.getDependentResourceDeleteForChange((Model)additionsModel, (Model)retractionsModel, (Model)sourceModel);
        sourceModel.remove(depDeletes);
        sourceModel.remove(retractionsModel);
        sourceModel.add(additionsModel);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(sourceModel);
        if (!same) {
            this.printModels(expectedModel, sourceModel);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testDeleteWithNonZeroInDegree() {
        String source = this.prefixesN3 + " ex:personHasPosition " + this.isDependentRelation + " ex:bob  ex:a \"Bob\".   \n ex:orgP ex:a \"orgP\".   \n ex:bob  ex:personHasPosition ex:position1 .   \n ex:orgP ex:positionInOrganization ex:position1 .   \n ex:position1 ex:a \"This is Position1\". \n ex:position1 ex:b \"2343\" . ";
        String expected = this.prefixesN3 + " ex:personHasPosition " + this.isDependentRelation + " ex:bob  ex:a \"Bob\".   \n ex:orgP ex:a \"orgP\".   \n ex:bob  ex:personHasPosition ex:position1 .   \n ex:position1 ex:a \"This is Position1\". \n ex:position1 ex:hasOrgName \"org xyz\" . \n ex:position1 ex:b \"2343\" . ";
        String additions = "@prefix ex: <http://example.com/> . \n@prefix xsd: <" + XSD.getURI() + "> . \n  ex:position1 ex:hasOrgName \"org xyz\" . ";
        String retractions = "@prefix ex: <http://example.com/> . \n@prefix xsd: <" + XSD.getURI() + "> . \n  ex:orgP ex:positionInOrganization ex:position1 . ";
        Model sourceModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(source), "", "N3");
        Model additionsModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(additions), "", "N3");
        Model retractionsModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(retractions), "", "N3");
        Model depDeletes = DependentResourceDeleteJena.getDependentResourceDeleteForChange((Model)additionsModel, (Model)retractionsModel, (Model)sourceModel);
        sourceModel.remove(depDeletes);
        sourceModel.remove(retractionsModel);
        sourceModel.add(additionsModel);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(sourceModel);
        if (!same) {
            this.printModels(expectedModel, sourceModel);
        }
        Assert.assertTrue((boolean)same);
    }

    @Test
    public void testDeleteWithNonZeroInDegree2() {
        String source = this.prefixesN3 + " ex:personHasPosition " + this.isDependentRelation + " ex:bob  ex:a \"Bob\".   \n ex:orgP ex:a \"orgP\".   \n ex:bob  ex:personHasPosition ex:position1 .   \n ex:orgP ex:positionInOrganization ex:position1 .   \n ex:position1 ex:a \"This is Position1\". \n ex:position1 ex:b \"2343\" . ";
        String expected = this.prefixesN3 + " ex:personHasPosition " + this.isDependentRelation + " ex:bob  ex:a \"Bob\".   \n ex:orgP ex:a \"orgP\".   \n ex:bob  ex:personHasPosition ex:position1 .   \n ex:position1 ex:a \"This is Position1\". \n ex:position1 ex:b \"2343\" . ";
        String retractions = "@prefix ex: <http://example.com/> . \n@prefix xsd: <" + XSD.getURI() + "> . \n  ex:orgP ex:positionInOrganization ex:position1 . ";
        Model sourceModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(source), "", "N3");
        Model additionsModel = ModelFactory.createDefaultModel();
        Model retractionsModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(retractions), "", "N3");
        Model depDeletes = DependentResourceDeleteJena.getDependentResourceDeleteForChange((Model)additionsModel, (Model)retractionsModel, (Model)sourceModel);
        sourceModel.remove(depDeletes);
        sourceModel.remove(retractionsModel);
        sourceModel.add(additionsModel);
        Model expectedModel = ModelFactory.createDefaultModel().read((Reader)new StringReader(expected), "", "N3");
        boolean same = expectedModel.isIsomorphicWith(sourceModel);
        if (!same) {
            this.printModels(expectedModel, sourceModel);
        }
        Assert.assertTrue((boolean)same);
    }
}

