/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringRDFService;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.org.apache.jena.rdf.model.LiteralStub;

public class LanguageFilteringRDFServiceTest
extends AbstractTestClass {
    private static final Log log = LogFactory.getLog(LanguageFilteringRDFServiceTest.class);
    private static final String COLLATOR_CLASSNAME = "edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringRDFService$RowIndexedLiteralSortByLang";
    private static final String RIL_CLASSNAME = "edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringRDFService$RowIndexedLiteral";
    private LanguageFilteringRDFService filteringRDFService;
    private List<Object> listOfRowIndexedLiterals;
    private int literalIndex;
    private List<String> preferredLanguages;
    private List<String> availableLanguages;
    private List<String> expectedSortOrders;

    @Before
    public void setup() {
    }

    @Test
    public void singleMatch() {
        this.preferredLanguages = this.list("en-US");
        this.availableLanguages = this.list("en-US");
        this.expectedSortOrders = this.list("en-US");
        this.testArbitraryOrder();
    }

    @Test
    public void singleNoMatch() {
        this.preferredLanguages = this.list("en-US");
        this.availableLanguages = this.list("es-MX");
        this.expectedSortOrders = this.list("es-MX");
        this.testArbitraryOrder();
    }

    @Test
    public void doubleMatch() {
        this.preferredLanguages = this.list("en-US", "es-MX");
        this.availableLanguages = this.list("en-US", "es-MX");
        this.expectedSortOrders = this.list("en-US", "es-MX");
        this.testBothWays();
    }

    @Test
    public void noMatches() {
        this.preferredLanguages = this.list("es-MX");
        this.availableLanguages = this.list("en-US", "fr-FR");
        this.expectedSortOrders = this.list("en-US", "fr-FR");
        this.testArbitraryOrder();
    }

    @Test
    public void partialMatches() {
        this.preferredLanguages = this.list("en", "es");
        this.availableLanguages = this.list("en-US", "es-MX");
        this.expectedSortOrders = this.list("en-US", "es-MX");
        this.testBothWays();
    }

    @Test
    public void matchIsBetterThanNoMatch() {
        this.preferredLanguages = this.list("en-US", "es-MX");
        this.availableLanguages = this.list("en-US", "fr-FR");
        this.expectedSortOrders = this.list("en-US", "fr-FR");
        this.testBothWays();
    }

    @Test
    public void matchIsBetterThanPartialMatch() {
        this.preferredLanguages = this.list("es-ES", "en-US");
        this.availableLanguages = this.list("en-US", "es-MX");
        this.expectedSortOrders = this.list("en-US", "es-MX");
        this.testBothWays();
    }

    @Test
    public void exactMatchIsBetterThanPartialMatch() {
        this.preferredLanguages = this.list("es");
        this.availableLanguages = this.list("es", "es-MX");
        this.expectedSortOrders = this.list("es", "es-MX");
        this.testBothWays();
    }

    @Test
    public void matchIsBetterThanVanilla() {
        this.preferredLanguages = this.list("en-US");
        this.availableLanguages = this.list("en-US", "");
        this.expectedSortOrders = this.list("en-US", "");
        this.testBothWays();
    }

    @Test
    public void partialMatchIsBetterThanVanilla() {
        this.preferredLanguages = this.list("es-MX");
        this.availableLanguages = this.list("es-ES", "");
        this.expectedSortOrders = this.list("es-ES", "");
        this.testBothWays();
    }

    @Test
    public void vanillaIsBetterThanNoMatch() {
        this.preferredLanguages = this.list("es-MX");
        this.availableLanguages = this.list("en-US", "");
        this.expectedSortOrders = this.list("", "en-US");
        this.testBothWays();
    }

    @Test
    public void omnibus() {
        this.preferredLanguages = this.list("es-MX", "es", "en-UK", "es-PE", "fr");
        this.availableLanguages = this.list("es-MX", "es", "fr", "es-ES", "fr-FR", "", "de-DE");
        this.expectedSortOrders = this.list("es-MX", "es", "fr", "es-ES", "fr-FR", "", "de-DE");
        this.testBothWays();
    }

    private void testBothWays() {
        this.createLanguageFilter();
        this.buildListOfLiterals();
        this.sortListOfLiterals();
        this.assertLanguageOrder("sort literals");
        this.buildReversedListOfLiterals();
        this.sortListOfLiterals();
        this.assertLanguageOrder("sort reversed literals");
    }

    private void testArbitraryOrder() {
        this.createLanguageFilter();
        this.buildListOfLiterals();
        this.sortListOfLiterals();
        this.assertLanguages("sort literals");
        this.buildReversedListOfLiterals();
        this.sortListOfLiterals();
        this.assertLanguages("sort reversed literals");
    }

    private List<String> list(String ... strings) {
        return new ArrayList<String>(Arrays.asList(strings));
    }

    private void createLanguageFilter() {
        this.filteringRDFService = new LanguageFilteringRDFService(null, this.preferredLanguages);
    }

    private void buildListOfLiterals() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String language : this.availableLanguages) {
            list.add(this.buildRowIndexedLiteral(language));
        }
        this.listOfRowIndexedLiterals = list;
    }

    private void buildReversedListOfLiterals() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String language : this.availableLanguages) {
            list.add(0, this.buildRowIndexedLiteral(language));
        }
        this.listOfRowIndexedLiterals = list;
    }

    private void sortListOfLiterals() {
        log.debug((Object)("before sorting: " + this.languagesFromLiterals(this.listOfRowIndexedLiterals)));
        Comparator<Object> comparator = this.buildRowIndexedLiteralSortByLang();
        this.listOfRowIndexedLiterals.sort(comparator);
    }

    private void assertLanguageOrder(String message) {
        List<String> expectedLanguages = this.expectedSortOrders;
        log.debug((Object)("expected order: " + expectedLanguages));
        List<String> actualLanguages = this.languagesFromLiterals(this.listOfRowIndexedLiterals);
        log.debug((Object)("actual order:   " + actualLanguages));
        Assert.assertEquals((String)message, expectedLanguages, actualLanguages);
    }

    private void assertLanguages(String message) {
        HashSet<String> expectedLanguages = new HashSet<String>(this.expectedSortOrders);
        log.debug((Object)("expected languages: " + expectedLanguages));
        HashSet<String> actualLanguages = new HashSet<String>(this.languagesFromLiterals(this.listOfRowIndexedLiterals));
        log.debug((Object)("actual languages:   " + actualLanguages));
        Assert.assertEquals((String)message, expectedLanguages, actualLanguages);
    }

    private List<String> languagesFromLiterals(List<Object> literals) {
        ArrayList<String> actualLanguages = new ArrayList<String>();
        for (Object ril : literals) {
            actualLanguages.add(this.getLanguageFromRowIndexedLiteral(ril));
        }
        return actualLanguages;
    }

    private Object buildRowIndexedLiteral(String language) {
        try {
            Class<?> clazz = Class.forName(RIL_CLASSNAME);
            Class[] argTypes = new Class[]{LanguageFilteringRDFService.class, Literal.class, Integer.TYPE};
            Constructor<?> constructor = clazz.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            LiteralStub l = new LiteralStub(language);
            int i = this.literalIndex++;
            return constructor.newInstance(this.filteringRDFService, l, i);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a row-indexed literal", e);
        }
    }

    private Comparator<Object> buildRowIndexedLiteralSortByLang() {
        try {
            Class<?> clazz = Class.forName(COLLATOR_CLASSNAME);
            Class[] argTypes = new Class[]{LanguageFilteringRDFService.class};
            Constructor<?> constructor = clazz.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            return (Comparator)constructor.newInstance(this.filteringRDFService);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a collator", e);
        }
    }

    private String getLanguageFromRowIndexedLiteral(Object ril) {
        try {
            Method m = ril.getClass().getDeclaredMethod("getLiteral", new Class[0]);
            m.setAccessible(true);
            Literal l = (Literal)m.invoke(ril, new Object[0]);
            return l.getLanguage();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get the Literal from a RowIndexedLiteral", e);
        }
    }
}

