/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.SelectQueryUriFinder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccessStub;

public class SelectQueryUriFinderTest
extends AbstractTestClass {
    private static final Log log = LogFactory.getLog(SelectQueryUriFinderTest.class);
    private static final String BOB_URI = "http://ns#Bob";
    private static final String BETTY_URI = "http://ns#Betty";
    private static final String DICK_URI = "http://ns#Dick";
    private static final String JANE_URI = "http://ns#Jane";
    private static final String FRIEND_URI = "http://ns#Friend";
    private static final String SEES_URI = "http://ns#Sees";
    private static final String OTHER_URI = "http://ns#Other";
    private static final Resource BOB = ResourceFactory.createResource((String)"http://ns#Bob");
    private static final Resource BETTY = ResourceFactory.createResource((String)"http://ns#Betty");
    private static final Resource DICK = ResourceFactory.createResource((String)"http://ns#Dick");
    private static final Resource JANE = ResourceFactory.createResource((String)"http://ns#Jane");
    private static final Property FRIEND = ResourceFactory.createProperty((String)"http://ns#Friend");
    private static final Property SEES = ResourceFactory.createProperty((String)"http://ns#Sees");
    private static final String QUERY1 = "SELECT ?friend WHERE {?subject <http://ns#Friend> ?friend}";
    private static final String QUERY2 = "SELECT ?partner WHERE {?object <http://ns#Friend> ?partner}";
    private Model m;
    private RDFService rdfService;
    private SelectQueryUriFinder finder;
    private List<String> foundUris;

    @Before
    public void populateModel() {
        this.m = ModelFactory.createDefaultModel();
        this.m.add(ResourceFactory.createStatement((Resource)BOB, (Property)FRIEND, (RDFNode)BETTY));
        this.m.add(ResourceFactory.createStatement((Resource)DICK, (Property)FRIEND, (RDFNode)JANE));
        this.rdfService = new RDFServiceModel(this.m);
        ContextModelAccessStub models = new ContextModelAccessStub();
        models.setRDFService(ModelAccess.WhichService.CONTENT, this.rdfService);
        this.finder = new SelectQueryUriFinder();
        this.finder.setContextModels((ContextModelAccess)models);
        this.finder.addQuery(QUERY1);
        this.finder.addQuery(QUERY2);
    }

    @Test
    public void fullSuccess_bothResults() {
        this.setPredicateRestrictions(new String[0]);
        this.exerciseUriFinder(BOB, SEES, (RDFNode)DICK);
        this.assertExpectedUris(BETTY_URI, JANE_URI);
    }

    @Test
    public void acceptableRestriction_bothResults() {
        this.setPredicateRestrictions(SEES_URI);
        this.exerciseUriFinder(BOB, SEES, (RDFNode)DICK);
        this.assertExpectedUris(BETTY_URI, JANE_URI);
    }

    @Test
    public void excludingRestriction_noResults() {
        this.setPredicateRestrictions(OTHER_URI);
        this.exerciseUriFinder(BOB, SEES, (RDFNode)DICK);
        this.assertExpectedUris(new String[0]);
    }

    @Test
    public void blankSubject_justObjectResult() {
        this.setPredicateRestrictions(new String[0]);
        this.exerciseUriFinder(ResourceFactory.createResource(), SEES, (RDFNode)DICK);
        this.assertExpectedUris(JANE_URI);
    }

    @Test
    public void literalObject_justSubjectResult() {
        this.setPredicateRestrictions(new String[0]);
        this.exerciseUriFinder(BOB, SEES, (RDFNode)ResourceFactory.createPlainLiteral((String)"Bogus"));
        this.assertExpectedUris(BETTY_URI);
    }

    private void setPredicateRestrictions(String ... uris) {
        for (String uri : uris) {
            this.finder.addPredicateRestriction(uri);
        }
    }

    private void exerciseUriFinder(Resource subject, Property predicate, RDFNode object) {
        this.foundUris = this.finder.findAdditionalURIsToIndex(ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)object));
    }

    private void assertExpectedUris(String ... expectedArray) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(expectedArray));
        HashSet<String> actual = new HashSet<String>(this.foundUris);
        Assert.assertEquals((String)"found URIs", expected, actual);
    }
}

