/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.Tags;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.ApplicationStub;
import stubs.javax.servlet.ServletContextStub;

public class TagsTest
extends AbstractTestClass {
    private ServletContextStub ctx;
    private File resource;

    @Before
    public void setup() throws IOException {
        this.resource = File.createTempFile("resource", "");
        this.ctx = new ServletContextStub();
        this.ctx.setRealPath("/base/sub/file.js", this.resource.getPath());
        this.ctx.setRealPath("/base/sub/file.css", this.resource.getPath());
        ApplicationStub.setup(this.ctx, null);
        this.setContextPath("/context");
    }

    @Test
    public void noAttribute_failure() {
        this.assertNoMatch("<div height='value'></div>");
    }

    @Test
    public void singleQuote_noTerminator_failure() {
        this.assertNoMatch("<link rel='stylesheet' href='problem></link>");
    }

    @Test
    public void singleQuotes_embeddedSingleQuote_failure() {
        this.assertNoMatch("<script src='value'problem'></script");
    }

    @Test
    public void singleQuotes_embeddedDoubleQuote_success() {
        this.assertMatch("<script src='value\"noproblem'></script", "value\"noproblem");
    }

    @Test
    public void doubleQuote_noTerminator_failure() {
        this.assertNoMatch("<link rel=\"stylesheet\" href=\"problem ></link>");
    }

    @Test
    public void doubleQuotes_embeddedDoubleQuote_failure() {
        this.assertNoMatch("<link href=\"value\"problem\"></link>");
    }

    @Test
    public void doubleQuotes_embeddedSingleQuote_success() {
        this.assertMatch("<link href=\"value'noproblem\"></link>", "value'noproblem");
    }

    @Test
    public void unquotedBadTerminator_failure() {
        this.assertNoMatch("<script src=problem");
    }

    @Test
    public void unquoted_embeddedEquals_failure() {
        this.assertNoMatch("<script src=value=problem>");
    }

    @Test
    public void unquoted_embeddedSingleQuote_failure() {
        this.assertNoMatch("<script src=value'problem>");
    }

    @Test
    public void unquoted_embeddedDoubleQuote_failure() {
        this.assertNoMatch("<script src=value\"problem>");
    }

    @Test
    public void unquoted_embeddedBackTick_failure() {
        this.assertNoMatch("<script src=value`problem>");
    }

    @Test
    public void unquoted_embeddedLessThan_failure() {
        this.assertNoMatch("<script src=value<problem>");
    }

    @Test
    public void spacesBeforeEquals_success() {
        this.assertMatch("<link href =value rel='stylesheet'>", "value");
    }

    @Test
    public void spacesAfterEquals_success() {
        this.assertMatch("<script src= 'value'></script>", "value");
    }

    @Test
    public void noSpacesAroundEquals_success() {
        this.assertMatch("<script src=\"value\" ></script>", "value");
    }

    @Test
    public void noMatch_noChange() {
        this.assertVersionNotAdded("<script junk='/context/base/sub/file.js' ></script>", "no match");
    }

    @Test
    public void alreadyHasQueryString_noChange() {
        this.assertVersionNotAdded("<script src='/context/base/sub/file.js?why' ></script>", "has query");
    }

    @Test
    public void doesntStartWithContextPath_noChange() {
        this.assertVersionNotAdded("<script src='/notContext/base/sub/file.js' ></script>", "context path");
    }

    @Test
    public void noRealPath_noChange() {
        this.assertVersionNotAdded("<script src='/context/base/sub/nofile.js' ></script>", "real path");
    }

    @Test
    @Ignore
    public void exception_noChange() {
        Assert.fail((String)"exception_noChange not implemented");
    }

    @Test
    public void doubleQuotes_substitution() {
        this.assertVersionAdded("<link href=\"/context/base/sub/file.css\" rel=stylesheet></link>", "<link href=\"/context/base/sub/file.css?version=9999\" rel=stylesheet></link>");
    }

    @Test
    public void singleQuotes_substitution() {
        this.assertVersionAdded("<script src='/context/base/sub/file.js' ></script>", "<script src='/context/base/sub/file.js?version=9999' ></script>");
    }

    @Test
    public void unquoted_substitution() {
        this.assertVersionAdded("<script type=text/javascript src=/context/base/sub/file.js ></script>", "<script type=text/javascript src=/context/base/sub/file.js?version&eq;9999 ></script>");
    }

    private void setContextPath(String contextPath) {
        try {
            Field f = UrlBuilder.class.getDeclaredField("contextPath");
            f.setAccessible(true);
            f.set(null, contextPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertMatch(String tag, String expected) {
        Tags.TagVersionInfo info = new Tags.TagVersionInfo(tag);
        try {
            Field f = Tags.TagVersionInfo.class.getDeclaredField("match");
            f.setAccessible(true);
            Tags.TagVersionInfo.MatchResult match = (Tags.TagVersionInfo.MatchResult)f.get(info);
            Assert.assertEquals((Object)expected, (Object)match.group);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertNoMatch(String tag) {
        Tags.TagVersionInfo info = new Tags.TagVersionInfo(tag);
        Assert.assertFalse((boolean)info.hasVersion());
    }

    private void assertVersionAdded(String rawTag, String expected) {
        String actual = this.createTag(rawTag);
        String canonicalActual = actual.replaceAll("=[0-9a-f]{4}", "=9999").replaceAll("&eq;[0-9a-f]{4}", "&eq;9999");
        Assert.assertEquals((Object)expected, (Object)canonicalActual);
    }

    private void assertVersionNotAdded(String rawTag, String debugMessage) {
        StringWriter writer = new StringWriter();
        this.captureLogOutput(Tags.class, writer, true);
        TagsTest.setLoggerLevel(Tags.class, Level.DEBUG);
        String actual = this.createTag(rawTag);
        Assert.assertEquals((Object)rawTag, (Object)actual);
        Assert.assertThat((Object)writer.toString(), (Matcher)Matchers.containsString((String)debugMessage));
    }

    private String createTag(String rawTag) {
        Tags t = new Tags();
        t.add(rawTag);
        return t.list();
    }
}

