/*
 * Decompiled with CFR 0.152.
 */
package stubs.edu.cornell.mannlib.vitro.webapp.dao;

import com.google.common.base.Objects;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ObjectPropertyDaoStub
implements ObjectPropertyDao {
    private final Map<String, ObjectPropertyHolder> objectPropertyMap = new HashMap<String, ObjectPropertyHolder>();
    private final Map<String, String> configFilesMap = new HashMap<String, String>();

    public void addObjectProperty(ObjectProperty property) {
        this.addObjectProperty(property, null);
    }

    public void addObjectProperty(ObjectProperty property, String parentUri) {
        if (property == null) {
            throw new NullPointerException("property may not be null.");
        }
        String uri = property.getURI();
        if (uri == null) {
            throw new NullPointerException("uri may not be null.");
        }
        this.objectPropertyMap.put(uri, new ObjectPropertyHolder(property, parentUri));
    }

    public void setCustomListViewConfigFileName(ObjectProperty property, String filename) {
        if (property == null) {
            throw new NullPointerException("property may not be null.");
        }
        String uri = property.getURI();
        if (uri == null) {
            throw new NullPointerException("uri may not be null.");
        }
        this.configFilesMap.put(uri, filename);
    }

    public List<ObjectProperty> getAllObjectProperties() {
        return this.objectPropertyMap.values().stream().map(ObjectPropertyHolder::getObjectProperty).collect(Collectors.toList());
    }

    public ObjectProperty getObjectPropertyByURI(String objectPropertyURI) {
        if (objectPropertyURI == null) {
            return null;
        }
        if (this.objectPropertyMap.containsKey(objectPropertyURI)) {
            return this.objectPropertyMap.get(objectPropertyURI).getObjectProperty();
        }
        return null;
    }

    public ObjectProperty getObjectPropertyByURIs(String objectPropertyURI, String domainURI, String rangeURI) {
        return this.getObjectPropertyByURI(objectPropertyURI);
    }

    public ObjectProperty getObjectPropertyByURIs(String objectPropertyURI, String domainURI, String rangeURI, ObjectProperty base) {
        return this.getObjectPropertyByURI(objectPropertyURI);
    }

    public List<ObjectProperty> getRootObjectProperties() {
        return this.objectPropertyMap.values().stream().filter(ObjectPropertyHolder::isRoot).map(ObjectPropertyHolder::getObjectProperty).collect(Collectors.toList());
    }

    public List<String> getSubPropertyURIs(String objectPropertyURI) {
        return this.objectPropertyMap.values().stream().filter(oph -> objectPropertyURI.equals(oph.getParentUri())).map(oph -> oph.getObjectProperty().getURI()).collect(Collectors.toList());
    }

    public String getCustomListViewConfigFileName(ObjectProperty objectProperty) {
        if (objectProperty == null) {
            return null;
        }
        String uri = objectProperty.getURI();
        if (uri == null) {
            return null;
        }
        return this.configFilesMap.get(uri);
    }

    public void addSuperproperty(Property property, Property superproperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.addSuperproperty() not implemented.");
    }

    public void addSuperproperty(String propertyURI, String superpropertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.addSuperproperty() not implemented.");
    }

    public void removeSuperproperty(Property property, Property superproperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.removeSuperproperty() not implemented.");
    }

    public void removeSuperproperty(String propertyURI, String superpropertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.removeSuperproperty() not implemented.");
    }

    public void addSubproperty(Property property, Property subproperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.addSubproperty() not implemented.");
    }

    public void addSubproperty(String propertyURI, String subpropertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.addSubproperty() not implemented.");
    }

    public void removeSubproperty(Property property, Property subproperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.removeSubproperty() not implemented.");
    }

    public void removeSubproperty(String propertyURI, String subpropertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.removeSubproperty() not implemented.");
    }

    public void addEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.addEquivalentProperty() not implemented.");
    }

    public void addEquivalentProperty(Property property, Property equivalentProperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.addEquivalentProperty() not implemented.");
    }

    public void removeEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.removeEquivalentProperty() not implemented.");
    }

    public void removeEquivalentProperty(Property property, Property equivalentProperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.removeEquivalentProperty() not implemented.");
    }

    public List<String> getAllSubPropertyURIs(String propertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.getAllSubPropertyURIs() not implemented.");
    }

    public List<String> getAllSuperPropertyURIs(String propertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.getAllSuperPropertyURIs() not implemented.");
    }

    public List<String> getEquivalentPropertyURIs(String propertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.getEquivalentPropertyURIs() not implemented.");
    }

    public List<VClass> getClassesWithRestrictionOnProperty(String propertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.getClassesWithRestrictionOnProperty() not implemented.");
    }

    public List<ObjectProperty> getObjectPropertiesForObjectPropertyStatements(List<ObjectPropertyStatement> objectPropertyStatements) {
        throw new RuntimeException("ObjectPropertyDaoStub.getObjectPropertiesForObjectPropertyStatements() not implemented.");
    }

    public List<String> getSuperPropertyURIs(String objectPropertyURI, boolean direct) {
        throw new RuntimeException("ObjectPropertyDaoStub.getSuperPropertyURIs() not implemented.");
    }

    public void fillObjectPropertiesForIndividual(Individual individual) {
        throw new RuntimeException("ObjectPropertyDaoStub.fillObjectPropertiesForIndividual() not implemented.");
    }

    public int insertObjectProperty(ObjectProperty objectProperty) throws InsertException {
        throw new RuntimeException("ObjectPropertyDaoStub.insertObjectProperty() not implemented.");
    }

    public void updateObjectProperty(ObjectProperty objectProperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.updateObjectProperty() not implemented.");
    }

    public void deleteObjectProperty(String objectPropertyURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.deleteObjectProperty() not implemented.");
    }

    public void deleteObjectProperty(ObjectProperty objectProperty) {
        throw new RuntimeException("ObjectPropertyDaoStub.deleteObjectProperty() not implemented.");
    }

    public boolean skipEditForm(String predicateURI) {
        throw new RuntimeException("ObjectPropertyDaoStub.skipEditForm() not implemented.");
    }

    public List<ObjectProperty> getObjectPropertyList(Individual subject) {
        throw new RuntimeException("ObjectPropertyDaoStub.getObjectPropertyList() not implemented.");
    }

    public List<ObjectProperty> getObjectPropertyList(String subjectUri) {
        throw new RuntimeException("ObjectPropertyDaoStub.getObjectPropertyList() not implemented.");
    }

    private static class ObjectPropertyHolder {
        final ObjectProperty oprop;
        final String parentUri;

        ObjectPropertyHolder(ObjectProperty oprop, String parentUri) {
            this.oprop = oprop;
            this.parentUri = parentUri;
        }

        public ObjectProperty getObjectProperty() {
            return this.oprop;
        }

        public String getParentUri() {
            return this.parentUri;
        }

        boolean isRoot() {
            return this.parentUri == null;
        }

        boolean inOntology(String ontologyUri) {
            return Objects.equal((Object)ontologyUri, (Object)this.oprop.getNamespace());
        }
    }
}

