/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.util;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperationUtils {
    private static final Log log = LogFactory.getLog((String)OperationUtils.class.getName());

    public static void beanSetAndValidate(Object newObj, String field, String value, EditProcessObject epo) {
        Class<?> cls = epo.getBeanClass() != null ? epo.getBeanClass() : newObj.getClass();
        Class[] paramList = new Class[]{String.class};
        boolean isInt = false;
        boolean isBoolean = false;
        Method setterMethod = null;
        try {
            setterMethod = cls.getMethod("set" + field, paramList);
        }
        catch (NoSuchMethodException e) {
            paramList[0] = Integer.TYPE;
            try {
                setterMethod = cls.getMethod("set" + field, paramList);
                isInt = true;
            }
            catch (NoSuchMethodException f) {
                paramList[0] = Boolean.TYPE;
                try {
                    setterMethod = cls.getMethod("set" + field, paramList);
                    isBoolean = true;
                    log.debug((Object)("found boolean field " + field));
                }
                catch (NoSuchMethodException g) {
                    log.error((Object)("beanSet could not find an appropriate String, int, or boolean setter method for " + field));
                }
            }
        }
        if (setterMethod != null) {
            Object[] arglist = new Object[]{isInt ? Integer.decode(value) : (isBoolean ? Boolean.valueOf(value.equalsIgnoreCase("TRUE")) : value)};
            try {
                setterMethod.invoke(newObj, arglist);
            }
            catch (Exception e) {
                log.error((Object)"Couldn't invoke method");
                log.error((Object)e.getMessage());
                log.error((Object)(field + " " + arglist[0]));
            }
        }
    }

    public static Object cloneBean(Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean may not be null.");
        }
        return OperationUtils.cloneBean(bean, bean.getClass(), bean.getClass());
    }

    public static Object cloneBean(final Object bean, final Class<?> beanClass, final Class<?> iface) {
        class CloneBeanException
        extends RuntimeException {
            public CloneBeanException(String message, Throwable cause) {
                super(message + " <" + cause.getClass().getSimpleName() + ">: bean=" + object + ", beanClass=" + clazz.getName() + ", iface=" + clazz2.getName(), cause);
            }
        }
        Object newBean;
        if (bean == null) {
            throw new NullPointerException("bean may not be null.");
        }
        if (beanClass == null) {
            throw new NullPointerException("beanClass may not be null.");
        }
        if (iface == null) {
            throw new NullPointerException("iface may not be null.");
        }
        try {
            newBean = beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CloneBeanException("bean has no 'nullary' constructor.", e);
        }
        catch (InstantiationException e) {
            throw new CloneBeanException("tried to create instance of an abstract class.", e);
        }
        catch (IllegalAccessException e) {
            throw new CloneBeanException("bean constructor is not accessible.", e);
        }
        catch (InvocationTargetException e) {
            throw new CloneBeanException("bean constructor threw an exception.", e);
        }
        catch (Exception e) {
            throw new CloneBeanException("failed to instantiate a new bean.", e);
        }
        for (Method beanMeth : iface.getMethods()) {
            Object fieldVal;
            Method setterMethod;
            String methName = beanMeth.getName();
            if (!methName.startsWith("get") || beanMeth.getParameterTypes().length != 0) continue;
            String fieldName = methName.substring(3, methName.length());
            Class<?> returnType = beanMeth.getReturnType();
            try {
                setterMethod = iface.getMethod("set" + fieldName, returnType);
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
            try {
                fieldVal = beanMeth.invoke(bean, (Object[])null);
            }
            catch (Exception e) {
                throw new CloneBeanException("failed to invoke " + beanMeth, e);
            }
            try {
                Object[] setArgs = new Object[]{fieldVal};
                setterMethod.invoke(newBean, setArgs);
            }
            catch (Exception e) {
                throw new CloneBeanException("failed to invoke " + setterMethod, e);
            }
        }
        return newBean;
    }
}

