/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.permissions;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishDataProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishObjectProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishByRolePermission
extends Permission {
    private static final Log log = LogFactory.getLog(PublishByRolePermission.class);
    public static final String NAMESPACE = "java:" + PublishByRolePermission.class.getName() + "#";
    private final String roleName;
    private final BaseResourceBean.RoleLevel roleLevel;

    public PublishByRolePermission(String roleName, BaseResourceBean.RoleLevel roleLevel) {
        super(NAMESPACE + roleName);
        if (roleName == null) {
            throw new NullPointerException("role may not be null.");
        }
        if (roleLevel == null) {
            throw new NullPointerException("roleLevel may not be null.");
        }
        this.roleName = roleName;
        this.roleLevel = roleLevel;
    }

    @Override
    public boolean isAuthorized(RequestedAction whatToAuth) {
        boolean result = whatToAuth instanceof PublishDataProperty ? this.isAuthorized((PublishDataProperty)whatToAuth) : (whatToAuth instanceof PublishObjectProperty ? this.isAuthorized((PublishObjectProperty)whatToAuth) : (whatToAuth instanceof PublishDataPropertyStatement ? this.isAuthorized((PublishDataPropertyStatement)whatToAuth) : (whatToAuth instanceof PublishObjectPropertyStatement ? this.isAuthorized((PublishObjectPropertyStatement)whatToAuth) : false)));
        if (result) {
            log.debug((Object)(this + " authorizes " + whatToAuth));
        } else {
            log.debug((Object)(this + " does not authorize " + whatToAuth));
        }
        return result;
    }

    private boolean isAuthorized(PublishDataProperty action) {
        String predicateUri = action.getDataProperty().getURI();
        return this.canPublishPredicate(new Property(predicateUri));
    }

    private boolean isAuthorized(PublishObjectProperty action) {
        return this.canPublishPredicate(action.getObjectProperty());
    }

    private boolean isAuthorized(PublishDataPropertyStatement action) {
        String subjectUri = action.getSubjectUri();
        String predicateUri = action.getPredicateUri();
        return this.canPublishResource(subjectUri) && this.canPublishPredicate(new Property(predicateUri));
    }

    private boolean isAuthorized(PublishObjectPropertyStatement action) {
        String subjectUri = action.getSubjectUri();
        Property predicate = action.getPredicate();
        String objectUri = action.getObjectUri();
        return this.canPublishResource(subjectUri) && this.canPublishPredicate(predicate) && this.canPublishResource(objectUri);
    }

    private boolean canPublishResource(String resourceUri) {
        return PropertyRestrictionBean.getBean().canPublishResource(resourceUri, this.roleLevel);
    }

    private boolean canPublishPredicate(Property predicate) {
        return PropertyRestrictionBean.getBean().canPublishPredicate(predicate, this.roleLevel);
    }

    @Override
    public String toString() {
        return "PublishByRolePermission['" + this.roleName + "']";
    }
}

