/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyDecisionLogger {
    private static final Log log = LogFactory.getLog(PolicyDecisionLogger.class);
    private static final Pattern NEVER_MATCHES = Pattern.compile("^__NEVER__$");
    private static final BasicPolicyDecision NULL_DECISION = new BasicPolicyDecision(Authorization.INCONCLUSIVE, "The decision was null.");
    private final DeveloperSettings settings = DeveloperSettings.getInstance();
    private final RequestedAction whatToAuth;
    private final IdentifierBundle whoToAuth;
    private final boolean enabled;
    private final Pattern policyRestriction;
    private final boolean skipInconclusive;
    private final boolean includeIdentifiers;

    public PolicyDecisionLogger(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        this.whoToAuth = whoToAuth;
        this.whatToAuth = whatToAuth;
        this.enabled = this.figureEnabled();
        this.policyRestriction = this.figurePolicyRestriction();
        this.skipInconclusive = this.figureSkipInconclusive();
        this.includeIdentifiers = this.figureIncludeIdentifiers();
    }

    private boolean figureEnabled() {
        return log.isInfoEnabled() && this.settings.getBoolean(Key.AUTHORIZATION_LOG_DECISIONS_ENABLE) && this.passesUserRestriction() && this.passesActionRestriction();
    }

    private boolean passesUserRestriction() {
        Pattern userRestriction = this.compilePatternFromSetting(Key.AUTHORIZATION_LOG_DECISIONS_USER_RESTRICTION);
        return userRestriction == null || userRestriction.matcher(String.valueOf(this.whoToAuth)).find();
    }

    private boolean passesActionRestriction() {
        Pattern actionRestriction = this.compilePatternFromSetting(Key.AUTHORIZATION_LOG_DECISIONS_ACTION_RESTRICTION);
        return actionRestriction == null || actionRestriction.matcher(String.valueOf(this.whatToAuth)).find();
    }

    private Pattern figurePolicyRestriction() {
        return this.compilePatternFromSetting(Key.AUTHORIZATION_LOG_DECISIONS_POLICY_RESTRICTION);
    }

    private boolean figureSkipInconclusive() {
        return this.settings.getBoolean(Key.AUTHORIZATION_LOG_DECISIONS_SKIP_INCONCLUSIVE);
    }

    private boolean figureIncludeIdentifiers() {
        return this.settings.getBoolean(Key.AUTHORIZATION_LOG_DECISIONS_ADD_IDENTIFERS);
    }

    private Pattern compilePatternFromSetting(Key key) {
        String setting = this.settings.getString(key);
        if (setting.isEmpty()) {
            return null;
        }
        try {
            return Pattern.compile(setting);
        }
        catch (Exception e) {
            return NEVER_MATCHES;
        }
    }

    public void log(PolicyIface policy, PolicyDecision pd) {
        if (this.passesRestrictions(String.valueOf(policy), pd)) {
            if (this.includeIdentifiers) {
                log.info((Object)String.format("Decision on %s by %s was %s; user is %s", this.whatToAuth, policy, pd, this.whoToAuth));
            } else {
                log.info((Object)String.format("Decision on %s by %s was %s", this.whatToAuth, policy, pd));
            }
        }
    }

    private boolean passesRestrictions(String policyString, PolicyDecision pd) {
        if (pd == null) {
            pd = NULL_DECISION;
        }
        return this.enabled && this.passesPolicyRestriction(policyString) && this.passesConclusiveRestriction(pd);
    }

    private boolean passesPolicyRestriction(String policyString) {
        return this.policyRestriction == null || this.policyRestriction.matcher(policyString).find();
    }

    private boolean passesConclusiveRestriction(PolicyDecision pd) {
        return !this.skipInconclusive || !this.isInconclusive(pd);
    }

    private boolean isInconclusive(PolicyDecision pd) {
        return pd == null || pd.getAuthorized() == Authorization.INCONCLUSIVE;
    }

    public void logNoDecision(PolicyDecision pd) {
        if (this.enabled) {
            if (this.includeIdentifiers) {
                log.info((Object)(pd.getMessage() + "; user is " + this.whoToAuth));
            } else {
                log.info((Object)pd.getMessage());
            }
        }
    }
}

