/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestPolicyList
extends PolicyList {
    private static final String ATTRIBUTE_POLICY_ADDITIONS = RequestPolicyList.class.getName();
    private static final Log log = LogFactory.getLog(RequestPolicyList.class);

    public static PolicyList getPolicies(HttpServletRequest request) {
        ServletContext ctx = request.getSession().getServletContext();
        PolicyList list = ServletPolicyList.getPolicies(ctx);
        list.addAll(RequestPolicyList.getPoliciesFromRequest((ServletRequest)request));
        return list;
    }

    public static void addPolicy(ServletRequest request, PolicyIface policy) {
        PolicyList policies = RequestPolicyList.getPoliciesFromRequest(request);
        if (!policies.contains(policy)) {
            policies.add(policy);
            log.debug((Object)("Added policy: " + policy.toString()));
        } else {
            log.warn((Object)"Ignored attempt to add redundent policy.");
        }
    }

    private static PolicyList getPoliciesFromRequest(ServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request may not be null.");
        }
        Object obj = request.getAttribute(ATTRIBUTE_POLICY_ADDITIONS);
        if (obj == null) {
            obj = new PolicyList();
            request.setAttribute(ATTRIBUTE_POLICY_ADDITIONS, obj);
        }
        if (!(obj instanceof PolicyList)) {
            throw new IllegalStateException("Expected to find an instance of " + PolicyList.class.getName() + " in the context, but found an instance of " + obj.getClass().getName() + " instead.");
        }
        return (PolicyList)obj;
    }
}

