/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;

public abstract class AbstractPageHandler {
    private static final Log log = LogFactory.getLog(AbstractPageHandler.class);
    protected final VitroRequest vreq;
    protected final I18nBundle i18n;
    protected final ServletContext ctx;
    protected final OntModel userAccountsModel;
    protected final OntModel unionModel;
    protected final UserAccountsDao userAccountsDao;
    protected final VClassDao vclassDao;
    protected final IndividualDao indDao;
    protected final DataPropertyStatementDao dpsDao;
    protected final ObjectPropertyStatementDao opsDao;

    protected AbstractPageHandler(VitroRequest vreq) {
        this.vreq = vreq;
        this.i18n = I18n.bundle((HttpServletRequest)vreq);
        this.ctx = vreq.getSession().getServletContext();
        this.userAccountsModel = ModelAccess.on(this.ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts");
        this.unionModel = ModelAccess.on(this.ctx).getOntModel("vitro:jenaOntModel");
        WebappDaoFactory wdf = ModelAccess.on(this.ctx).getWebappDaoFactory();
        this.userAccountsDao = wdf.getUserAccountsDao();
        this.vclassDao = wdf.getVClassDao();
        this.indDao = wdf.getIndividualDao();
        this.dpsDao = wdf.getDataPropertyStatementDao();
        this.opsDao = wdf.getObjectPropertyStatementDao();
    }

    protected String getStringParameter(String key, String defaultValue) {
        String value = this.vreq.getParameter(key);
        return value == null ? defaultValue : value;
    }

    protected List<String> getStringParameters(String key) {
        String[] values = this.vreq.getParameterValues(key);
        if (values == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(values));
    }

    protected int getIntegerParameter(String key, int defaultValue) {
        String value = this.vreq.getParameter(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid integer for parameter '" + key + "': " + value));
            return defaultValue;
        }
    }

    protected boolean isFlagOnRequest(String key) {
        String value = this.vreq.getParameter(key);
        return value != null;
    }

    protected boolean isParameterAsExpected(String key, String expected) {
        return expected.equals(this.getStringParameter(key, ""));
    }

    protected void applyMessage(HttpServletRequest req, Map<String, Object> body) {
        Message.applyMessageToBodyMap(req, body, "message");
    }

    public static abstract class Message {
        private static final String ATTRIBUTE = Message.class.getName();

        public static void setMessage(HttpServletRequest req, Message message) {
            log.debug((Object)("Added message to session: " + message.getMessageInfoMap()));
            req.getSession().setAttribute(ATTRIBUTE, (Object)message);
        }

        public static void applyMessageToBodyMap(HttpServletRequest req, Map<String, Object> body, String key) {
            Object o = req.getSession().getAttribute(ATTRIBUTE);
            req.getSession().removeAttribute(ATTRIBUTE);
            if (o instanceof Message) {
                body.put(key, ((Message)o).getMessageInfoMap());
            }
        }

        public Map<String, Object> assembleMap(Object ... args) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("you must provide keys and values in pairs.");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < args.length; i += 2) {
                if (!(args[i] instanceof String)) {
                    throw new IllegalArgumentException("args[" + i + "] is not a String");
                }
                map.put((String)args[i], args[i + 1]);
            }
            return map;
        }

        public abstract Map<String, Object> getMessageInfoMap();
    }

    protected static class InvalidParametersException
    extends Exception {
        public InvalidParametersException(String message) {
            super(message);
        }
    }
}

