/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies;

import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelection;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelectionBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ProxyRelationshipSelectionCriteria;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SparqlQueryUtils;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ResultSetParser;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;

public class ProxyRelationshipSelector {
    private static final Log log = LogFactory.getLog(ProxyRelationshipSelector.class);
    private static final String PREFIX_LINES = "PREFIX fn: <http://www.w3.org/2005/xpath-functions#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX auth: <http://vitro.mannlib.cornell.edu/ns/vitro/authorization#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX vpublic: <http://vitro.mannlib.cornell.edu/ns/vitro/public#> \n";
    private final Context context;
    private final ProxyRelationshipSelectionCriteria criteria;
    private final ProxyRelationshipSelectionBuilder builder;
    private static final String COUNT_QUERY_TEMPLATE = "%prefixes% \nSELECT count(DISTINCT ?uri) \nWHERE {\n    ?uri a auth:UserAccount ; \n            auth:firstName ?firstName ; \n            auth:lastName ?lastName ; \n            auth:proxyEditorFor ?profile . \n    LET ( ?label := fn:concat(?lastName, ', ', ?firstName) )    %filterClause% \n} \n";
    private static final String QUERY_PROXY_BASICS = "%prefixes% \nSELECT DISTINCT ?uri ?label ?externalAuthId \nWHERE { \n    ?uri a auth:UserAccount ; \n            auth:firstName ?firstName ; \n            auth:lastName ?lastName ; \n            auth:proxyEditorFor ?profile . \n    LET ( ?label := fn:concat(?lastName, ', ', ?firstName) )    OPTIONAL { ?uri auth:externalAuthId ?externalAuthId } \n    %filterClause% \n} \nORDER BY ASC(?lastName) ASC(?firstName) \nLIMIT %perPage% \nOFFSET %offset%\n";
    private static final String QUERY_EXPAND_PROXY = "%prefixes% \nSELECT ?classLabel ?imageUrl \nWHERE { \n    ?uri <%matchingProperty%> '%externalAuthId%'. \n    OPTIONAL { \n       ?uri vitro:mostSpecificType ?type. \n       ?type rdfs:label ?classLabel  \n       }  \n   OPTIONAL { \n       ?uri vpublic:mainImage ?imageUri. \n       ?imageUri vpublic:thumbnailImage ?thumbUri. \n       ?thumbUri vpublic:downloadLocation ?thumbstreamUri. \n       ?thumbstreamUri vpublic:directDownloadUrl ?imageUrl. \n       }  \n} \nLIMIT 1 \n";
    private static final String QUERY_RELATIONSHIPS = "%prefixes% \nSELECT DISTINCT ?profileUri \nWHERE { \n    <%proxyUri%> a auth:UserAccount ; \n            auth:proxyEditorFor ?profileUri . \n} \n";
    private static final String QUERY_EXPAND_PROFILE = "%prefixes% \nSELECT ?label ?classLabel ?imageUrl \nWHERE { \n    <%profileUri%> rdfs:label ?label . \n    OPTIONAL { \n       <%profileUri%> vitro:mostSpecificType ?type. \n       ?type rdfs:label ?classLabel  \n       }  \n   OPTIONAL { \n       <%profileUri%> vpublic:mainImage ?imageUri. \n       ?imageUri vpublic:thumbnailImage ?thumbUri. \n       ?thumbUri vpublic:downloadLocation ?thumbstreamUri. \n       ?thumbstreamUri vpublic:directDownloadUrl ?imageUrl. \n       }  \n} \nLIMIT 1 \n";

    public static ProxyRelationshipSelection select(Context context, ProxyRelationshipSelectionCriteria criteria) {
        return new ProxyRelationshipSelector(context, criteria).select();
    }

    public ProxyRelationshipSelector(Context context, ProxyRelationshipSelectionCriteria criteria) {
        if (context == null) {
            throw new NullPointerException("context may not be null.");
        }
        this.context = context;
        if (criteria == null) {
            throw new NullPointerException("criteria may not be null.");
        }
        this.criteria = criteria;
        this.builder = new ProxyRelationshipSelectionBuilder(criteria);
    }

    public ProxyRelationshipSelection select() {
        if (this.criteria.getViewBy() == ProxyRelationshipSelectionCriteria.ProxyRelationshipView.BY_PROXY) {
            this.figureTotalResultCount();
            this.getProxyBasics();
            this.expandProxies();
            this.getRelationships();
            this.expandProfiles();
        } else {
            log.error((Object)"Trying to select ProxyRelationships by profile!");
        }
        return this.builder.build();
    }

    private void figureTotalResultCount() {
        String qString = COUNT_QUERY_TEMPLATE.replace("%prefixes%", PREFIX_LINES);
        qString = this.replaceFilterClauses(qString);
        int count = SparqlQueryRunner.createSelectQueryContext((Model)this.context.userAccountsModel, qString).execute().parse(new CountQueryParser());
        log.debug((Object)("result count: " + count));
        this.builder.count = count;
    }

    private String replaceFilterClauses(String q) {
        String searchTerm = this.criteria.getSearchTerm();
        if (searchTerm.isEmpty()) {
            return q.replace("%filterClause%", "");
        }
        String clean = SparqlQueryUtils.escapeForRegex(searchTerm);
        return q.replace("%filterClause%", "FILTER (REGEX(str(?label), '^" + clean + "', 'i'))");
    }

    private void getProxyBasics() {
        String qString = QUERY_PROXY_BASICS.replace("%prefixes%", PREFIX_LINES).replace("%perPage%", String.valueOf(this.criteria.getRelationshipsPerPage())).replace("%offset%", this.offset());
        qString = this.replaceFilterClauses(qString);
        List<ProxyRelationshipSelectionBuilder.Relationship> relationships = SparqlQueryRunner.createSelectQueryContext((Model)this.context.userAccountsModel, qString).execute().parse(new ProxyBasicsParser());
        log.debug((Object)("getProxyBasics returns: " + relationships));
        this.builder.relationships.addAll(relationships);
    }

    private void expandProxies() {
        if (this.context.matchingProperty.isEmpty()) {
            return;
        }
        for (ProxyRelationshipSelectionBuilder.Relationship r : this.builder.relationships) {
            for (ProxyRelationshipSelectionBuilder.ItemInfo proxy : r.proxyInfos) {
                if (proxy.externalAuthId.isEmpty()) continue;
                String qString = QUERY_EXPAND_PROXY.replace("%prefixes%", PREFIX_LINES).replace("%matchingProperty%", this.context.matchingProperty).replace("%externalAuthId%", proxy.externalAuthId);
                ProxyRelationshipSelectionBuilder.ItemInfo expansion = SparqlQueryRunner.createSelectQueryContext((Model)this.context.unionModel, qString).execute().parse(new ExpandProxyParser());
                proxy.classLabel = expansion.classLabel;
                proxy.imageUrl = expansion.imageUrl;
            }
        }
    }

    private void getRelationships() {
        for (ProxyRelationshipSelectionBuilder.Relationship r : this.builder.relationships) {
            for (ProxyRelationshipSelectionBuilder.ItemInfo proxy : r.proxyInfos) {
                String qString = QUERY_RELATIONSHIPS.replace("%prefixes%", PREFIX_LINES).replace("%proxyUri%", proxy.uri);
                List<String> profileUris = SparqlQueryRunner.createSelectQueryContext((Model)this.context.userAccountsModel, qString).execute().parse(new RelationshipsParser());
                for (String profileUri : profileUris) {
                    r.profileInfos.add(new ProxyRelationshipSelectionBuilder.ItemInfo(profileUri, "", "", "", ""));
                }
            }
        }
    }

    private void expandProfiles() {
        for (ProxyRelationshipSelectionBuilder.Relationship r : this.builder.relationships) {
            for (ProxyRelationshipSelectionBuilder.ItemInfo profile : r.profileInfos) {
                String qString = QUERY_EXPAND_PROFILE.replace("%prefixes%", PREFIX_LINES).replace("%profileUri%", profile.uri);
                ProxyRelationshipSelectionBuilder.ItemInfo expansion = SparqlQueryRunner.createSelectQueryContext((Model)this.context.unionModel, qString).execute().parse(new ExpandProfileParser());
                profile.label = expansion.label;
                profile.classLabel = expansion.classLabel;
                profile.imageUrl = expansion.imageUrl;
            }
        }
    }

    private String offset() {
        int offset = this.criteria.getRelationshipsPerPage() * (this.criteria.getPageIndex() - 1);
        return String.valueOf(offset);
    }

    private static class ExpandProfileParser
    extends ResultSetParser<ProxyRelationshipSelectionBuilder.ItemInfo> {
        private ExpandProfileParser() {
        }

        @Override
        protected ProxyRelationshipSelectionBuilder.ItemInfo defaultValue() {
            return new ProxyRelationshipSelectionBuilder.ItemInfo();
        }

        @Override
        protected ProxyRelationshipSelectionBuilder.ItemInfo parseResults(String queryStr, ResultSet results) {
            ProxyRelationshipSelectionBuilder.ItemInfo item = new ProxyRelationshipSelectionBuilder.ItemInfo();
            if (results.hasNext()) {
                try {
                    QuerySolution solution = results.next();
                    item.label = this.ifLiteralPresent(solution, "label", "");
                    item.classLabel = this.ifLiteralPresent(solution, "classLabel", "");
                    item.imageUrl = this.ifLiteralPresent(solution, "imageUrl", "");
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to parse the query result" + queryStr), (Throwable)e);
                }
            }
            return item;
        }
    }

    private static class RelationshipsParser
    extends ResultSetParser<List<String>> {
        private RelationshipsParser() {
        }

        @Override
        protected List<String> defaultValue() {
            return Collections.emptyList();
        }

        @Override
        protected List<String> parseResults(String queryStr, ResultSet results) {
            ArrayList<String> proxyUris = new ArrayList<String>();
            while (results.hasNext()) {
                try {
                    QuerySolution solution = results.next();
                    proxyUris.add(solution.getResource("profileUri").getURI());
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to parse the query result: " + queryStr), (Throwable)e);
                }
            }
            return proxyUris;
        }
    }

    private static class ExpandProxyParser
    extends ResultSetParser<ProxyRelationshipSelectionBuilder.ItemInfo> {
        private ExpandProxyParser() {
        }

        @Override
        protected ProxyRelationshipSelectionBuilder.ItemInfo defaultValue() {
            return new ProxyRelationshipSelectionBuilder.ItemInfo();
        }

        @Override
        protected ProxyRelationshipSelectionBuilder.ItemInfo parseResults(String queryStr, ResultSet results) {
            ProxyRelationshipSelectionBuilder.ItemInfo item = new ProxyRelationshipSelectionBuilder.ItemInfo();
            if (results.hasNext()) {
                try {
                    QuerySolution solution = results.next();
                    item.classLabel = this.ifLiteralPresent(solution, "classLabel", "");
                    item.imageUrl = this.ifLiteralPresent(solution, "imageUrl", "");
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to parse the query result" + queryStr), (Throwable)e);
                }
            }
            return item;
        }
    }

    private static class CountQueryParser
    extends ResultSetParser<Integer> {
        private CountQueryParser() {
        }

        @Override
        protected Integer defaultValue() {
            return 0;
        }

        @Override
        protected Integer parseResults(String queryStr, ResultSet results) {
            int count = 0;
            if (!results.hasNext()) {
                log.warn((Object)"count query returned no results.");
            }
            try {
                QuerySolution solution = results.next();
                count = this.ifIntPresent(solution, ".1", 0);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse the query result" + queryStr), (Throwable)e);
            }
            return count;
        }
    }

    private static class ProxyBasicsParser
    extends ResultSetParser<List<ProxyRelationshipSelectionBuilder.Relationship>> {
        private ProxyBasicsParser() {
        }

        @Override
        protected List<ProxyRelationshipSelectionBuilder.Relationship> defaultValue() {
            return Collections.emptyList();
        }

        @Override
        protected List<ProxyRelationshipSelectionBuilder.Relationship> parseResults(String queryStr, ResultSet results) {
            ArrayList<ProxyRelationshipSelectionBuilder.Relationship> relationships = new ArrayList<ProxyRelationshipSelectionBuilder.Relationship>();
            while (results.hasNext()) {
                try {
                    relationships.add(this.parseSolution(results.next()));
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to parse the query result: " + queryStr), (Throwable)e);
                }
            }
            return relationships;
        }

        private ProxyRelationshipSelectionBuilder.Relationship parseSolution(QuerySolution solution) {
            ProxyRelationshipSelectionBuilder.ItemInfo info = new ProxyRelationshipSelectionBuilder.ItemInfo();
            info.uri = solution.getResource("uri").getURI();
            info.label = solution.getLiteral("label").getString();
            info.externalAuthId = this.ifLiteralPresent(solution, "externalAuthId", "");
            ProxyRelationshipSelectionBuilder.Relationship r = new ProxyRelationshipSelectionBuilder.Relationship();
            r.proxyInfos.add(info);
            return r;
        }
    }

    public static class Context {
        private final OntModel userAccountsModel;
        private final OntModel unionModel;
        private final String matchingProperty;

        public Context(OntModel userAccountsModel, OntModel unionModel, String matchingProperty) {
            if (userAccountsModel == null) {
                throw new NullPointerException("userAccountsModel may not be null.");
            }
            this.userAccountsModel = userAccountsModel;
            if (unionModel == null) {
                throw new NullPointerException("unionModel may not be null.");
            }
            this.unionModel = unionModel;
            this.matchingProperty = matchingProperty == null ? "" : matchingProperty;
        }
    }
}

