/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsPasswordBasePage;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailMessage;
import java.util.HashMap;
import javax.mail.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAccountsCreatePasswordPage
extends UserAccountsPasswordBasePage {
    private static final Log log = LogFactory.getLog(UserAccountsCreatePasswordPage.class);
    private static final String TEMPLATE_NAME = "userAccounts-createPassword.ftl";
    private static final String EMAIL_TEMPLATE = "userAccounts-passwordCreatedEmail.ftl";

    public UserAccountsCreatePasswordPage(VitroRequest vreq) {
        super(vreq);
    }

    public void createPassword() {
        this.userAccount.setArgon2Password(Authenticator.applyArgon2iEncoding(this.newPassword));
        this.userAccount.setMd5Password("");
        this.userAccount.setPasswordLinkExpires(0L);
        this.userAccount.setPasswordChangeRequired(false);
        this.userAccount.setStatus(UserAccount.Status.ACTIVE);
        this.userAccountsDao.updateUserAccount(this.userAccount);
        log.debug((Object)("Set password on '" + this.userAccount.getEmailAddress() + "' to '" + this.newPassword + "'"));
        this.notifyUser();
    }

    @Override
    protected String alreadyLoggedInMessage(String currentUserEmail) {
        return this.i18n.text("cant_activate_while_logged_in", this.userEmail, currentUserEmail);
    }

    @Override
    protected String passwordChangeNotPendingMessage() {
        return this.i18n.text("account_already_activated", this.userEmail);
    }

    @Override
    protected String templateName() {
        return TEMPLATE_NAME;
    }

    private void notifyUser() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("userAccount", this.userAccount);
        body.put("siteName", this.getSiteName());
        FreemarkerEmailMessage email = FreemarkerEmailFactory.createNewMessage(this.vreq);
        email.addRecipient(Message.RecipientType.TO, this.userAccount.getEmailAddress());
        email.setSubject(this.i18n.text("password_created_subject", this.getSiteName()));
        email.setTemplate(EMAIL_TEMPLATE);
        email.setBodyMap(body);
        email.processTemplate();
        email.send();
    }
}

