/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.util.HashMap;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="adminLogin", urlPatterns={"/admin/login"})
public class AdminLoginController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(AdminLoginController.class);
    public static final String PARAMETER_EMAIL_ADDRESS = "email";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_NEW_PASSWORD = "newPassword";
    public static final String PARAMETER_CONFIRM_PASSWORD = "confirmPassword";
    public static final String URL_THIS = "/admin/login";
    public static final String URL_HOME_PAGE = "/";
    public static final String TEMPLATE_NAME = "adminLogin.ftl";
    private static final String MESSAGE_NO_EMAIL_ADDRESS = "errorNoEmail";
    private static final String MESSAGE_NO_PASSWORD = "errorNoPassword";
    private static final String MESSAGE_LOGIN_DISABLED = "errorLoginDisabled";
    private static final String MESSAGE_LOGIN_FAILED = "errorLoginFailed";
    private static final String MESSAGE_NEW_PASSWORD_REQUIRED = "newPasswordRequired";
    private static final String MESSAGE_NEW_PASSWORD_WRONG_LENGTH = "errorNewPasswordWrongLength";
    private static final String MESSAGE_NEW_PASSWORDS_DONT_MATCH = "errorNewPasswordsDontMatch";
    private static final String MESSAGE_NEW_PASSWORD_MATCHES_OLD = "errorNewPasswordMatchesOld";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return AuthorizationRequest.AUTHORIZED;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        return new Core(vreq).process();
    }

    private static class Core {
        private final Authenticator auth;
        private final String emailAddress;
        private final String password;
        private final String newPassword;
        private final String confirmPassword;
        private final UserAccount userAccount;

        public Core(VitroRequest vreq) {
            this.auth = Authenticator.getInstance((HttpServletRequest)vreq);
            this.emailAddress = this.nonNull(vreq.getParameter(AdminLoginController.PARAMETER_EMAIL_ADDRESS));
            this.password = this.nonNull(vreq.getParameter(AdminLoginController.PARAMETER_PASSWORD));
            this.newPassword = this.nonNull(vreq.getParameter(AdminLoginController.PARAMETER_NEW_PASSWORD));
            this.confirmPassword = this.nonNull(vreq.getParameter(AdminLoginController.PARAMETER_CONFIRM_PASSWORD));
            log.debug((Object)("Parameters: email='" + this.emailAddress + "', password='" + this.password + "', newPassword='" + this.newPassword + "', confirmPassword='" + this.confirmPassword + "'"));
            this.userAccount = this.auth.getAccountForInternalAuth(this.emailAddress);
        }

        public ResponseValues process() {
            boolean loggedIn;
            if (this.emailAddress.isEmpty() && this.password.isEmpty()) {
                return this.showForm(new String[0]);
            }
            if (this.emailAddress.isEmpty()) {
                return this.showForm(AdminLoginController.MESSAGE_NO_EMAIL_ADDRESS);
            }
            if (this.password.isEmpty()) {
                return this.showForm(AdminLoginController.MESSAGE_NO_PASSWORD);
            }
            if (!this.loginPermitted()) {
                return this.showForm(AdminLoginController.MESSAGE_LOGIN_DISABLED);
            }
            if (this.newPasswordRequired()) {
                if (this.newPassword.isEmpty()) {
                    return this.showForm(AdminLoginController.MESSAGE_NEW_PASSWORD_REQUIRED);
                }
                if (!this.isPasswordValidLength(this.newPassword)) {
                    return this.showForm(AdminLoginController.MESSAGE_NEW_PASSWORD_REQUIRED, AdminLoginController.MESSAGE_NEW_PASSWORD_WRONG_LENGTH);
                }
                if (this.newPassword.equals(this.password)) {
                    return this.showForm(AdminLoginController.MESSAGE_NEW_PASSWORD_REQUIRED, AdminLoginController.MESSAGE_NEW_PASSWORD_MATCHES_OLD);
                }
                if (!this.newPassword.equals(this.confirmPassword)) {
                    return this.showForm(AdminLoginController.MESSAGE_NEW_PASSWORD_REQUIRED, AdminLoginController.MESSAGE_NEW_PASSWORDS_DONT_MATCH);
                }
            }
            if (loggedIn = this.tryToLogin()) {
                return this.goToHomePage();
            }
            return this.showForm(AdminLoginController.MESSAGE_LOGIN_FAILED);
        }

        private boolean loginPermitted() {
            return this.auth.isUserPermittedToLogin(this.userAccount);
        }

        private boolean newPasswordRequired() {
            if (this.auth.md5HashIsNull(this.userAccount)) {
                return this.auth.isCurrentPasswordArgon2(this.userAccount, this.password) && this.userAccount.isPasswordChangeRequired();
            }
            return this.auth.isCurrentPassword(this.userAccount, this.password);
        }

        private boolean isPasswordValidLength(String pw) {
            return pw.length() >= 6 && pw.length() <= 12;
        }

        private boolean tryToLogin() {
            if (this.auth.md5HashIsNull(this.userAccount)) {
                if (!this.auth.isCurrentPasswordArgon2(this.userAccount, this.password)) {
                    return false;
                }
            } else {
                if (!this.auth.isCurrentPassword(this.userAccount, this.password)) {
                    return false;
                }
                this.userAccount.setPasswordChangeRequired(true);
                this.userAccount.setMd5Password("");
            }
            try {
                this.auth.recordLoginAgainstUserAccount(this.userAccount, LoginStatusBean.AuthenticationSource.INTERNAL);
            }
            catch (Authenticator.LoginNotPermitted e) {
                return false;
            }
            if (!this.newPassword.isEmpty()) {
                this.auth.recordNewPassword(this.userAccount, this.newPassword);
            }
            return true;
        }

        private ResponseValues showForm(String ... codes) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("controllerUrl", UrlBuilder.getUrl(AdminLoginController.URL_THIS));
            body.put(AdminLoginController.PARAMETER_EMAIL_ADDRESS, this.emailAddress);
            body.put(AdminLoginController.PARAMETER_PASSWORD, this.password);
            body.put(AdminLoginController.PARAMETER_NEW_PASSWORD, this.newPassword);
            body.put(AdminLoginController.PARAMETER_CONFIRM_PASSWORD, this.confirmPassword);
            body.put("minPasswordLength", 6);
            body.put("maxPasswordLength", 12);
            for (String code : codes) {
                body.put(code, Boolean.TRUE);
            }
            log.debug((Object)("showing form with values: " + body));
            return new TemplateResponseValues(AdminLoginController.TEMPLATE_NAME, body);
        }

        private ResponseValues goToHomePage() {
            return new RedirectResponseValues(AdminLoginController.URL_HOME_PAGE);
        }

        private String nonNull(String s) {
            return s == null ? "" : s;
        }
    }
}

