/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsRootUser;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.edit.Authenticate;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.LoginEvent;
import edu.cornell.mannlib.vitro.webapp.dao.jena.LogoutEvent;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicAuthenticator
extends Authenticator {
    private static final Log log = LogFactory.getLog(BasicAuthenticator.class);
    private final HttpServletRequest request;

    public BasicAuthenticator(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public UserAccount getAccountForInternalAuth(String emailAddress) {
        UserAccountsDao userAccountsDao = this.getUserAccountsDao();
        if (userAccountsDao == null) {
            return null;
        }
        return userAccountsDao.getUserAccountByEmail(emailAddress);
    }

    @Override
    public UserAccount getAccountForExternalAuth(String externalAuthId) {
        UserAccountsDao userAccountsDao = this.getUserAccountsDao();
        if (userAccountsDao == null) {
            return null;
        }
        return userAccountsDao.getUserAccountByExternalAuthId(externalAuthId);
    }

    @Override
    public boolean isUserPermittedToLogin(UserAccount userAccount) {
        return true;
    }

    @Override
    public boolean isCurrentPassword(UserAccount userAccount, String clearTextPassword) {
        if (userAccount == null) {
            return false;
        }
        if (clearTextPassword == null) {
            return false;
        }
        String encodedPassword = BasicAuthenticator.applyMd5Encoding(clearTextPassword);
        return encodedPassword.equals(userAccount.getMd5Password());
    }

    @Override
    public boolean md5HashIsNull(UserAccount userAccount) {
        return userAccount.getMd5Password().compareTo("") == 0 || userAccount.getMd5Password() == null;
    }

    @Override
    public boolean isCurrentPasswordArgon2(UserAccount userAccount, String clearTextPassword) {
        if (userAccount == null) {
            return false;
        }
        if (clearTextPassword == null) {
            return false;
        }
        return BasicAuthenticator.verifyArgon2iHash(userAccount.getArgon2Password(), clearTextPassword);
    }

    @Override
    public void recordNewPassword(UserAccount userAccount, String newClearTextPassword) {
        if (userAccount == null) {
            log.error((Object)"Trying to change password on null user.");
            return;
        }
        userAccount.setArgon2Password(BasicAuthenticator.applyArgon2iEncoding(newClearTextPassword));
        userAccount.setMd5Password("");
        userAccount.setPasswordChangeRequired(false);
        userAccount.setPasswordLinkExpires(0L);
        this.getUserAccountsDao().updateUserAccount(userAccount);
    }

    @Override
    public boolean accountRequiresEditing(UserAccount userAccount) {
        if (userAccount == null) {
            log.error((Object)"Trying to check for valid fields on a null user.");
            return false;
        }
        if (userAccount.getFirstName().isEmpty()) {
            return true;
        }
        if (userAccount.getLastName().isEmpty()) {
            return true;
        }
        if (userAccount.getEmailAddress().isEmpty()) {
            return true;
        }
        return !BasicAuthenticator.isValidEmailAddress(userAccount.getEmailAddress());
    }

    @Override
    public List<String> getAssociatedIndividualUris(UserAccount userAccount) {
        ArrayList<String> uris = new ArrayList<String>();
        if (userAccount == null) {
            return uris;
        }
        uris.addAll(this.getUrisAssociatedBySelfEditorConfig(userAccount));
        return uris;
    }

    @Override
    public void recordLoginAgainstUserAccount(UserAccount userAccount, LoginStatusBean.AuthenticationSource authSource) throws Authenticator.LoginNotPermitted {
        if (!this.isUserPermittedToLogin(userAccount)) {
            throw new Authenticator.LoginNotPermitted();
        }
        if (userAccount == null) {
            log.error((Object)"Trying to record the login of a null user. ");
            return;
        }
        this.recordLoginOnUserRecord(userAccount);
        HttpSession session = this.request.getSession();
        this.createLoginStatusBean(userAccount.getUri(), authSource, session);
        RequestIdentifiers.resetIdentifiers((ServletRequest)this.request);
        this.setSessionTimeoutLimit(userAccount, session);
        this.recordInUserSessionMap(userAccount.getUri(), session);
        this.notifyOtherUsers(userAccount.getUri(), session);
        if (IsRootUser.isRootUser(RequestIdentifiers.getIdBundleForRequest((ServletRequest)this.request))) {
            try {
                SearchEngine engine = ApplicationUtils.instance().getSearchEngine();
                if (engine.documentCount() == 0) {
                    log.info((Object)"Search index is empty. Running a full index rebuild.");
                    ApplicationUtils.instance().getSearchIndexer().rebuildIndex();
                }
            }
            catch (SearchEngineException e) {
                log.warn((Object)"Unable to check for search index", (Throwable)e);
            }
        }
    }

    private void recordLoginOnUserRecord(UserAccount userAccount) {
        userAccount.setLoginCount(userAccount.getLoginCount() + 1);
        userAccount.setLastLoginTime(new Date().getTime());
        userAccount.setStatus(UserAccount.Status.ACTIVE);
        this.getUserAccountsDao().updateUserAccount(userAccount);
    }

    private void createLoginStatusBean(String userUri, LoginStatusBean.AuthenticationSource authSource, HttpSession session) {
        LoginStatusBean lsb = new LoginStatusBean(userUri, authSource);
        LoginStatusBean.setBean(session, lsb);
        log.debug((Object)("Adding status bean: " + lsb));
    }

    private void setSessionTimeoutLimit(UserAccount userAccount, HttpSession session) {
        BaseResourceBean.RoleLevel role = BaseResourceBean.RoleLevel.getRoleFromLoginStatus(this.request);
        if (role == BaseResourceBean.RoleLevel.EDITOR || role == BaseResourceBean.RoleLevel.CURATOR || role == BaseResourceBean.RoleLevel.DB_ADMIN) {
            session.setMaxInactiveInterval(28800);
        } else if (userAccount.isRootUser()) {
            session.setMaxInactiveInterval(28800);
        } else {
            session.setMaxInactiveInterval(3600);
        }
    }

    private void recordInUserSessionMap(String userUri, HttpSession session) {
        Map<String, HttpSession> userURISessionMap = Authenticate.getUserURISessionMapFromContext(session.getServletContext());
        userURISessionMap.put(userUri, session);
    }

    private void notifyOtherUsers(String userUri, HttpSession session) {
        Authenticate.sendLoginNotifyEvent(new LoginEvent(userUri), session.getServletContext(), session);
    }

    private List<String> getUrisAssociatedBySelfEditorConfig(UserAccount user) {
        ArrayList<String> uris = new ArrayList<String>();
        if (user == null) {
            return uris;
        }
        IndividualDao iDao = this.getIndividualDao();
        if (iDao == null) {
            return uris;
        }
        List<Individual> associatedIndividuals = SelfEditingConfiguration.getBean((ServletRequest)this.request).getAssociatedIndividuals(iDao, user);
        for (Individual ind : associatedIndividuals) {
            uris.add(ind.getURI());
        }
        return uris;
    }

    @Override
    public void recordUserIsLoggedOut() {
        HttpSession session = this.request.getSession();
        this.notifyOtherUsersOfLogout(session);
        session.invalidate();
    }

    private void notifyOtherUsersOfLogout(HttpSession session) {
        String userUri = LoginStatusBean.getBean(session).getUserURI();
        if (userUri == null || userUri.isEmpty()) {
            return;
        }
        Authenticate.sendLoginNotifyEvent(new LogoutEvent(userUri), session.getServletContext(), session);
    }

    private UserAccountsDao getUserAccountsDao() {
        UserAccountsDao userAccountsDao = this.getWebappDaoFactory().getUserAccountsDao();
        if (userAccountsDao == null) {
            log.error((Object)"getUserAccountsDao: no UserAccountsDao");
        }
        return userAccountsDao;
    }

    private IndividualDao getIndividualDao() {
        IndividualDao individualDao = this.getWebappDaoFactory().getIndividualDao();
        if (individualDao == null) {
            log.error((Object)"getIndividualDao: no IndividualDao");
        }
        return individualDao;
    }

    private WebappDaoFactory getWebappDaoFactory() {
        return ModelAccess.on(this.request).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]);
    }

    public String toString() {
        return "BasicAuthenticator[" + this.request + "]";
    }

    public static class Factory
    implements Authenticator.AuthenticatorFactory {
        @Override
        public Authenticator getInstance(HttpServletRequest req) {
            return new BasicAuthenticator(req);
        }
    }
}

