/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

@WebServlet(name="MenuManagementEdit", urlPatterns={"/menuManagementEdit"})
public class MenuManagementEdit
extends VitroHttpServlet {
    private static final String CMD_PARAM = "cmd";
    private static final String REORDER_PARAM_VALUE = "Reorder";
    private static final String REDIRECT_URL = "/individual?uri=http%3A%2F%2Fvitro.mannlib.cornell.edu%2Fontologies%2Fdisplay%2F1.1%23DefaultMenu&switchToDisplayModel=true";
    private static Model removeStatements = null;
    private static Model addStatements = null;
    Log log = LogFactory.getLog(MenuManagementEdit.class);

    @Override
    protected void doPost(HttpServletRequest rawRequest, HttpServletResponse resp) throws ServletException, IOException {
        removeStatements = ModelFactory.createDefaultModel();
        addStatements = ModelFactory.createDefaultModel();
        VitroRequest vreq = new VitroRequest(rawRequest);
        String command = this.getCommand(vreq);
        if (command != null) {
            this.processCommand(command, vreq, resp);
        } else {
            this.log.error((Object)"Command is null");
        }
        if (!this.isReorder(command)) {
            resp.sendRedirect(rawRequest.getContextPath() + REDIRECT_URL);
        }
    }

    public String getCommand(VitroRequest vreq) {
        String command = vreq.getParameter(CMD_PARAM);
        return command;
    }

    public boolean isReorder(String command) {
        return command.equals(REORDER_PARAM_VALUE);
    }

    public boolean isHomePage(String uri) {
        return uri.equals("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#Home");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCommand(String command, VitroRequest vreq, HttpServletResponse resp) {
        OntModel displayModel = this.getDisplayModel(vreq);
        if (displayModel == null) {
            this.log.error((Object)"Display model not being retrieved correctly");
        }
        String errorMessage = "";
        if (this.isReorder(command)) {
            errorMessage = this.processReorder(displayModel, vreq);
        }
        displayModel.enterCriticalSection(false);
        try {
            this.log.debug((Object)"Statement to be removed are ");
            StringWriter r = new StringWriter();
            removeStatements.write((Writer)r, "N3");
            this.log.debug((Object)r.toString());
            r.close();
            this.log.debug((Object)"Statements to be added are ");
            StringWriter a = new StringWriter();
            addStatements.write((Writer)a, "N3");
            this.log.debug((Object)a.toString());
            a.close();
            displayModel.remove(removeStatements);
            displayModel.add(addStatements);
        }
        catch (Exception ex) {
            this.log.error((Object)"An error occurred in processing command", (Throwable)ex);
            errorMessage = errorMessage + "An error occurred and the operation could not be completed successfully.";
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        if (this.isReorder(command)) {
            this.sendReorderResponse(errorMessage, resp);
        }
    }

    private String processReorder(OntModel displayModel, VitroRequest vreq) {
        String[] individuals = vreq.getParameterValues("individuals");
        String errorMessage = null;
        if (individuals.length > 0) {
            removeStatements = this.removePositionStatements(displayModel, individuals);
            addStatements = this.addPositionStatements(displayModel, individuals);
        } else {
            errorMessage = "No individuals passed";
        }
        return errorMessage;
    }

    private void sendReorderResponse(String errorMessage, HttpServletResponse resp) {
        try {
            ObjectNode rObj = JsonNodeFactory.instance.objectNode();
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json;charset=UTF-8");
            if (errorMessage != null && !errorMessage.isEmpty()) {
                rObj.put("errorMessage", errorMessage);
                resp.setStatus(500);
            } else {
                rObj.put("errorMessage", "");
            }
            PrintWriter writer = resp.getWriter();
            ((Writer)writer).write(rObj.toString());
        }
        catch (Exception ex) {
            this.log.error((Object)"Error creating JSON object for response", (Throwable)ex);
        }
    }

    private Model removePositionStatements(OntModel displayModel, String[] individuals) {
        Model removePositionStatements = ModelFactory.createDefaultModel();
        for (String individual : individuals) {
            Resource individualResource = ResourceFactory.createResource((String)individual);
            removePositionStatements.add(displayModel.listStatements(individualResource, (Property)DisplayVocabulary.MENU_POSITION, (RDFNode)null));
        }
        return removePositionStatements;
    }

    private Model addPositionStatements(OntModel displayModel, String[] individuals) {
        Model addPositionStatements = ModelFactory.createDefaultModel();
        int index = 0;
        int len = individuals.length;
        for (index = 0; index < len; ++index) {
            Resource individualResource = ResourceFactory.createResource((String)individuals[index]);
            int position = index + 1;
            addPositionStatements.add(addPositionStatements.createStatement(individualResource, (Property)DisplayVocabulary.MENU_POSITION, (RDFNode)addPositionStatements.createTypedLiteral(position)));
        }
        return addPositionStatements;
    }

    private OntModel getDisplayModel(VitroRequest vreq) {
        if (vreq.getAttribute("specialWriteModel") != null) {
            return vreq.getJenaOntModel();
        }
        return vreq.getDisplayModel();
    }
}

