/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;

public class ManageLabelsForIndividualController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ManageLabelsForIndividualController.class.getName());
    private static final String TEMPLATE_NAME = "manageLabelsForIndividual.ftl";
    private static String LABEL_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT DISTINCT ?label WHERE { \n    ?subject rdfs:label ?label \n} ORDER BY ?label";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String subjectUri = vreq.getParameter("subjectUri");
        body.put("subjectUri", subjectUri);
        ArrayList<Literal> labels = this.getLabels(subjectUri, vreq);
        log.debug((Object)("labels = " + labels));
        body.put("labels", labels);
        Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectUri);
        if (subject != null && subject.getName() != null) {
            body.put("subjectName", subject.getName());
        } else {
            body.put("subjectName", null);
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    ArrayList<Literal> getLabels(String subjectUri, VitroRequest vreq) {
        String queryStr = QueryUtils.subUriForQueryVar(LABEL_QUERY, "subject", subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        ArrayList<Literal> labels = new ArrayList<Literal>();
        try {
            ResultSet results = QueryUtils.getQueryResults(queryStr, vreq);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Literal nodeLiteral = soln.get("label").asLiteral();
                labels.add(nodeLiteral);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return labels;
    }
}

