/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.Classes2Classes;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jga.algorithms.Filter;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.property.GetProperty;

public class VClassDaoFiltering
extends BaseFiltering
implements VClassDao {
    final VClassDao innerVClassDao;
    final IndividualDao innerIndividualDao;
    final VitroFilters filters;
    static UnaryFunctor<VClass, String> getURI = new GetProperty(VClass.class, "URI");

    public VClassDaoFiltering(VClassDao classDao, IndividualDao individualDao, VitroFilters filters) {
        this.innerVClassDao = classDao;
        this.innerIndividualDao = individualDao;
        this.filters = filters;
    }

    @Override
    public void deleteVClass(String URI2) {
        this.innerVClassDao.deleteVClass(URI2);
    }

    @Override
    public void deleteVClass(VClass cls) {
        this.innerVClassDao.deleteVClass(cls);
    }

    @Override
    public List<String> getDisjointWithClassURIs(String classURI) {
        return this.innerVClassDao.getDisjointWithClassURIs(classURI);
    }

    @Override
    public void addDisjointWithClass(String classURI, String disjointClassURI) {
        this.innerVClassDao.addDisjointWithClass(classURI, disjointClassURI);
    }

    @Override
    public void removeDisjointWithClass(String classURI, String disjointClassURI) {
        this.innerVClassDao.removeDisjointWithClass(classURI, disjointClassURI);
    }

    @Override
    public List<String> getEquivalentClassURIs(String classURI) {
        return this.innerVClassDao.getEquivalentClassURIs(classURI);
    }

    @Override
    public void addEquivalentClass(String classURI, String equivalentClassURI) {
        this.innerVClassDao.addEquivalentClass(classURI, equivalentClassURI);
    }

    @Override
    public void removeEquivalentClass(String classURI, String equivalentClassURI) {
        this.innerVClassDao.removeEquivalentClass(classURI, equivalentClassURI);
    }

    @Override
    public void addSuperclass(VClass subclass, VClass superclass) {
        this.innerVClassDao.addSuperclass(subclass, superclass);
    }

    @Override
    public void addSuperclass(String classURI, String superclassURI) {
        this.innerVClassDao.addSuperclass(classURI, superclassURI);
    }

    @Override
    public void removeSuperclass(VClass vclass, VClass superclass) {
        this.innerVClassDao.removeSuperclass(vclass, superclass);
    }

    @Override
    public void removeSuperclass(String classURI, String superclassURI) {
        this.innerVClassDao.removeSuperclass(classURI, superclassURI);
    }

    @Override
    public void addSubclass(VClass vclass, VClass subclass) {
        this.innerVClassDao.addSubclass(vclass, subclass);
    }

    @Override
    public void addSubclass(String classURI, String subclassURI) {
        this.innerVClassDao.addSubclass(classURI, subclassURI);
    }

    @Override
    public void removeSubclass(VClass vclass, VClass subclass) {
        this.innerVClassDao.removeSubclass(vclass, subclass);
    }

    @Override
    public void removeSubclass(String classURI, String subclassURI) {
        this.innerVClassDao.removeSubclass(classURI, subclassURI);
    }

    @Override
    public List<String> getAllSubClassURIs(String classURI) {
        return this.innerVClassDao.getAllSubClassURIs(classURI);
    }

    @Override
    public List<String> getAllSuperClassURIs(String classURI) {
        return this.innerVClassDao.getAllSuperClassURIs(classURI);
    }

    @Override
    public List<VClass> getAllVclasses() {
        List<VClass> list = this.innerVClassDao.getAllVclasses();
        if (list == null) {
            return null;
        }
        this.filter(list, this.filters.getClassFilter());
        return list;
    }

    @Override
    public List<VClass> getOntologyRootClasses(String ontologyURI) {
        return this.innerVClassDao.getOntologyRootClasses(ontologyURI);
    }

    @Override
    public List<VClass> getRootClasses() {
        return this.innerVClassDao.getRootClasses();
    }

    @Override
    public List<String> getSubClassURIs(String classURI) {
        return this.innerVClassDao.getSubClassURIs(classURI);
    }

    @Override
    public List<String> getSuperClassURIs(String classURI, boolean direct) {
        return this.innerVClassDao.getSuperClassURIs(classURI, direct);
    }

    @Override
    public VClass getVClassByURI(String URI2) {
        return this.innerVClassDao.getVClassByURI(URI2);
    }

    @Override
    public List<VClass> getVClassesForProperty(String propertyURI, boolean domainSide) {
        return this.innerVClassDao.getVClassesForProperty(propertyURI, domainSide);
    }

    @Override
    public List<VClass> getVClassesForProperty(String vclassURI, String propertyURI) {
        return this.innerVClassDao.getVClassesForProperty(vclassURI, propertyURI);
    }

    @Override
    public void insertNewVClass(VClass cls) throws InsertException {
        this.innerVClassDao.insertNewVClass(cls);
    }

    @Override
    public void updateVClass(VClass cls) {
        this.innerVClassDao.updateVClass(cls);
    }

    @Override
    public void addVClassesToGroup(VClassGroup group) {
        this.addVClassesToGroup(group, true);
    }

    @Override
    public void addVClassesToGroup(VClassGroup group, boolean includeUninstantiatedClasses) {
        this.addVClassesToGroup(group, includeUninstantiatedClasses, false);
    }

    @Override
    public void addVClassesToGroup(VClassGroup group, boolean includeUninstantiatedClasses, boolean setIndividualCount) {
        this.innerVClassDao.addVClassesToGroup(group, includeUninstantiatedClasses, false);
        List<VClass> classes = group.getVitroClassList();
        LinkedList out = new LinkedList();
        Filter.filter(classes, this.filters.getClassFilter(), out);
        group.clear();
        group.addAll(out);
        if (setIndividualCount) {
            for (VClass vc : group) {
                if (!(vc instanceof VClass)) continue;
                this.correctVClassCount(vc);
            }
        }
    }

    @Override
    public void addVClassesToGroups(List<VClassGroup> groups) {
        if (groups != null && groups.size() > 0) {
            for (VClassGroup g : groups) {
                this.addVClassesToGroup(g);
            }
        } else {
            VClassGroup vcg = new VClassGroup();
            vcg.setURI("null://null#0");
            vcg.setNamespace("null://null#");
            vcg.setLocalName("0");
            vcg.setPublicName("Browse Categories");
            vcg.addAll(this.getAllVclasses());
            vcg.getVitroClassList().sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((VClass)o1).getName().compareTo(((VClass)o2).getName());
                }
            });
            groups.add(vcg);
        }
    }

    private void correctVClassCount(VClass vclass) {
        List<Individual> ents = this.innerIndividualDao.getIndividualsByVClass(vclass);
        long count = 0L;
        if (ents == null) {
            return;
        }
        ArrayList out = new ArrayList(ents.size());
        Filter.filter(ents, this.filters.getIndividualFilter(), out);
        if (out != null) {
            vclass.setEntityCount(out.size());
        }
        System.out.println(vclass.getURI() + " count: " + vclass.getEntityCount());
    }

    private List<VClass> correctVClassCounts(List<VClass> vclasses) {
        for (VClass vclass : vclasses) {
            this.correctVClassCount(vclass);
        }
        return vclasses;
    }

    @Override
    public VClass getTopConcept() {
        return this.innerVClassDao.getTopConcept();
    }

    @Override
    public VClass getBottomConcept() {
        return this.innerVClassDao.getBottomConcept();
    }

    @Override
    public void insertNewClasses2Classes(Classes2Classes c2c) {
        this.innerVClassDao.insertNewClasses2Classes(c2c);
    }

    @Override
    public void deleteClasses2Classes(Classes2Classes c2c) {
        this.innerVClassDao.deleteClasses2Classes(c2c);
    }

    @Override
    public boolean isSubClassOf(VClass vc1, VClass vc2) {
        return this.innerVClassDao.isSubClassOf(vc1, vc2);
    }

    @Override
    public boolean isSubClassOf(String vclassURI1, String vclassURI2) {
        return this.innerVClassDao.isSubClassOf(vclassURI1, vclassURI2);
    }
}

