/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.DisplayModelDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.servlet.ServletContext;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;

public class DisplayModelDaoJena
implements DisplayModelDao {
    WebappDaoFactoryJena wdf;
    protected static final String MENU_N3_FILE = "/WEB-INF/ontologies/app/menu.n3";
    protected static final String MENU_N3_FILE_BACKUP = "/WEB-INF/ontologies/app/menu.backup";
    protected static Resource MENU_TEXT_RES = ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#MenuText");
    protected static Property HAS_TEXT_REPRESENTATION = ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasMenuText");

    public DisplayModelDaoJena(WebappDaoFactoryJena wdfj) {
        this.wdf = wdfj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceDisplayModel(String n3, ServletContext context) throws Exception {
        OntModel displayModel = this.wdf.getOntModelSelector().getDisplayModel();
        Model oldMenuStmts = ModelFactory.createDefaultModel();
        try {
            oldMenuStmts.read((Reader)new StringReader(this.getDisplayModel(context)), null, "N3");
        }
        catch (Throwable th) {
            throw new Exception("Cannot read in existing menu. " + th.getMessage());
        }
        Model newMenuStmts = ModelFactory.createDefaultModel();
        StringReader newIn = new StringReader(n3);
        try {
            newMenuStmts.read((Reader)newIn, null, "N3");
        }
        catch (Throwable th) {
            throw new Exception("There was an error in the menu N3: " + th.getMessage());
        }
        displayModel.enterCriticalSection(true);
        try {
            displayModel.removeAll(MENU_TEXT_RES, HAS_TEXT_REPRESENTATION, null);
            displayModel.add(MENU_TEXT_RES, HAS_TEXT_REPRESENTATION, n3);
            displayModel.remove(oldMenuStmts);
            displayModel.add(newMenuStmts);
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayModel(ServletContext context) throws IOException {
        OntModel displayModel = this.wdf.getOntModelSelector().getDisplayModel();
        String text = null;
        displayModel.enterCriticalSection(false);
        try {
            Statement stmt = displayModel.getProperty(MENU_TEXT_RES, HAS_TEXT_REPRESENTATION);
            if (stmt != null && stmt.getLiteral() != null) {
                text = stmt.getLiteral().getLexicalForm();
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        if (text == null) {
            File oldMenuFile = new File(context.getRealPath(MENU_N3_FILE));
            StringBuilder str = new StringBuilder(2000);
            BufferedReader reader = new BufferedReader(new FileReader(oldMenuFile));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                str.append(readData);
            }
            reader.close();
            String menuN3Content = str.toString();
            displayModel.enterCriticalSection(true);
            try {
                displayModel.add(MENU_TEXT_RES, HAS_TEXT_REPRESENTATION, menuN3Content);
            }
            finally {
                displayModel.leaveCriticalSection();
            }
            return menuN3Content;
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

