/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstanceIface;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DependentResourceDeleteJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.PropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.IndividualDeletionEvent;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.IndividualUpdateEvent;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;

public class PropertyInstanceDaoJena
extends PropertyDaoJena
implements PropertyInstanceDao {
    public PropertyInstanceDaoJena(RDFService rdfService, DatasetWrapperFactory dwf, WebappDaoFactoryJena wadf) {
        super(rdfService, dwf, wadf);
    }

    @Override
    public void deleteObjectPropertyStatement(String subjectURI, String propertyURI, String objectURI) {
        this.deleteObjectPropertyStatement(subjectURI, propertyURI, objectURI, this.getOntModelSelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjectPropertyStatement(String subjectURI, String propertyURI, String objectURI, OntModelSelector ontModelSelector) {
        block13: {
            OntModel ontModel = ontModelSelector.getABoxModel();
            OntModel tboxModel = ontModelSelector.getTBoxModel();
            ontModel.enterCriticalSection(false);
            try {
                Resource subjRes = ontModel.getResource(subjectURI);
                Property pred = tboxModel.getProperty(propertyURI);
                OntProperty invPred = null;
                if (pred.canAs(OntProperty.class)) {
                    invPred = ((OntProperty)pred.as(OntProperty.class)).getInverse();
                }
                Resource objRes = ontModel.getResource(objectURI);
                Model baseModel = this.getOntModel().getBaseModel();
                String userUri = this.getWebappDaoFactory().getUserURI();
                if (subjRes == null || pred == null || objRes == null) break block13;
                baseModel.notifyEvent((Object)new IndividualUpdateEvent(userUri, true, subjectURI));
                try {
                    ontModel.remove(subjRes, pred, (RDFNode)objRes);
                }
                finally {
                    baseModel.notifyEvent((Object)new IndividualUpdateEvent(userUri, false, subjectURI));
                }
                try {
                    baseModel.notifyEvent((Object)new IndividualDeletionEvent(userUri, true, objectURI));
                    List<Statement> depResStmts = DependentResourceDeleteJena.getDependentResourceDeleteList(ResourceFactory.createStatement((Resource)subjRes, (Property)pred, (RDFNode)objRes), (Model)ontModel);
                    ontModel.remove(depResStmts);
                }
                finally {
                    baseModel.notifyEvent((Object)new IndividualDeletionEvent(userUri, false, objectURI));
                }
                if (invPred == null) break block13;
                baseModel.notifyEvent((Object)new IndividualUpdateEvent(userUri, true, objectURI));
                try {
                    ontModel.remove(objRes, (Property)invPred, (RDFNode)subjRes);
                }
                finally {
                    baseModel.notifyEvent((Object)new IndividualUpdateEvent(userUri, false, subjectURI));
                }
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        }
    }

    @Override
    public List<PropertyInstance> getAllPossiblePropInstForIndividual(String individualURI) {
        return this.filterAndSort(super.getAllPossiblePropInstForIndividual(individualURI));
    }

    @Override
    public List<PropertyInstance> getAllPropInstByVClass(String vclassURI) {
        return this.filterAndSort(super.getAllPropInstByVClass(vclassURI));
    }

    @Override
    public List<PropertyInstance> getAllPropInstByVClasses(List<VClass> vclasses) {
        return this.filterAndSort(super.getAllPropInstByVClasses(vclasses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyInstance> filterAndSort(List<PropertyInstance> propList) {
        ArrayList<PropertyInstance> propInsts = new ArrayList<PropertyInstance>();
        for (PropertyInstance propInst : propList) {
            OntModel tboxModel = this.getOntModel();
            tboxModel.enterCriticalSection(true);
            boolean add = false;
            try {
                add = propInst.getPropertyURI() != null && tboxModel.contains(tboxModel.getResource(propInst.getPropertyURI()), RDF.type, (RDFNode)OWL.ObjectProperty);
            }
            finally {
                tboxModel.leaveCriticalSection();
            }
            if (!add) continue;
            propInsts.add(propInst);
        }
        propInsts.sort(new PropInstSorter());
        return propInsts;
    }

    @Override
    public Collection<PropertyInstance> getExistingProperties(String entityURI, String propertyURI) {
        Individual ent = this.getWebappDaoFactory().getIndividualDao().getIndividualByURI(entityURI);
        if (ent == null) {
            return null;
        }
        ent.sortForDisplay();
        ArrayList<PropertyInstance> existingPropertyInstances = new ArrayList<PropertyInstance>();
        if (ent.getObjectPropertyList() == null) {
            return existingPropertyInstances;
        }
        for (ObjectProperty op : ent.getObjectPropertyList()) {
            for (ObjectPropertyStatement objPropertyStmt : op.getObjectPropertyStatements()) {
                if (propertyURI != null && !objPropertyStmt.getPropertyURI().equals(propertyURI)) continue;
                PropertyInstance pi = new PropertyInstance();
                pi.setSubjectSide(true);
                pi.setSubjectEntURI(ent.getURI());
                pi.setSubjectName(ent.getName());
                if (objPropertyStmt.getObject() != null) {
                    pi.setObjectName(objPropertyStmt.getObject().getName());
                } else {
                    pi.setObjectName(objPropertyStmt.getObjectURI());
                }
                pi.setObjectEntURI(objPropertyStmt.getObjectURI());
                pi.setPropertyURI(objPropertyStmt.getPropertyURI());
                if (objPropertyStmt.getProperty() != null) {
                    pi.setDomainPublic(objPropertyStmt.getProperty().getDomainPublic() != null ? objPropertyStmt.getProperty().getDomainPublic() : objPropertyStmt.getProperty().getLocalName());
                } else {
                    pi.setDomainPublic(objPropertyStmt.getPropertyURI());
                }
                existingPropertyInstances.add(pi);
            }
        }
        return existingPropertyInstances;
    }

    @Override
    public PropertyInstance getProperty(String subjectURI, String predicateURI, String objectURI) {
        PropertyInstance pi = new PropertyInstance();
        pi.setSubjectEntURI(subjectURI);
        Individual sub = this.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectURI);
        pi.setSubjectName(sub.getName());
        pi.setDomainClassURI(sub.getVClassURI());
        pi.setPropertyURI(predicateURI);
        pi.setPropertyName(this.getWebappDaoFactory().getObjectPropertyDao().getObjectPropertyByURI(predicateURI).getDomainPublic());
        pi.setObjectEntURI(objectURI);
        Individual obj = this.getWebappDaoFactory().getIndividualDao().getIndividualByURI(objectURI);
        pi.setObjectName(obj.getName());
        pi.setRangeClassURI(obj.getVClassURI());
        return pi;
    }

    @Override
    public int insertProp(PropertyInstanceIface prop) {
        return this.insertProp(prop, this.getOntModelSelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertProp(PropertyInstanceIface prop, OntModelSelector oms) {
        OntModel ontModel = oms.getABoxModel();
        OntModel tboxModel = oms.getTBoxModel();
        ontModel.enterCriticalSection(false);
        try {
            int n;
            tboxModel.enterCriticalSection(true);
            try {
                Resource subjRes = ontModel.getResource(prop.getSubjectEntURI());
                OntProperty pred = tboxModel.getOntProperty(prop.getPropertyURI());
                Resource objRes = ontModel.getResource(prop.getObjectEntURI());
                if (subjRes != null && pred != null && objRes != null) {
                    this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, prop.getSubjectEntURI()));
                    try {
                        ontModel.add(subjRes, (Property)pred, (RDFNode)objRes);
                    }
                    finally {
                        this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, prop.getSubjectEntURI()));
                    }
                    OntProperty invPred = pred.getInverse();
                    if (invPred != null) {
                        this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), true, prop.getObjectEntURI()));
                        try {
                            ontModel.add(objRes, (Property)invPred, (RDFNode)subjRes);
                        }
                        finally {
                            this.getOntModel().getBaseModel().notifyEvent((Object)new IndividualUpdateEvent(this.getWebappDaoFactory().getUserURI(), false, prop.getSubjectEntURI()));
                        }
                    }
                }
                n = 0;
            }
            catch (Throwable throwable) {
                tboxModel.leaveCriticalSection();
                throw throwable;
            }
            tboxModel.leaveCriticalSection();
            return n;
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void insertPropertyInstance(PropertyInstance prop) {
        this.insertProp(prop);
    }

    @Override
    public void deletePropertyInstance(PropertyInstance prop) {
        this.deleteObjectPropertyStatement(prop.getSubjectEntURI(), prop.getPropertyURI(), prop.getObjectEntURI());
    }

    private class PropInstSorter
    implements Comparator<PropertyInstance> {
        private PropInstSorter() {
        }

        @Override
        public int compare(PropertyInstance pi1, PropertyInstance pi2) {
            try {
                if (pi1.getDomainPublic().equals(pi2.getDomainPublic())) {
                    return pi1.getRangeClassName().compareTo(pi2.getRangeClassName());
                }
                return pi1.getDomainPublic().compareTo(pi2.getDomainPublic());
            }
            catch (NullPointerException npe) {
                return -1;
            }
        }
    }
}

