/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.listener.impl;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.listener.ChangeListener;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BasicValidationVTwo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualDataPropertyStatementProcessor
implements ChangeListener {
    private static final Log log = LogFactory.getLog((String)IndividualDataPropertyStatementProcessor.class.getName());

    @Override
    public void doInserted(Object newObj, EditProcessObject epo) {
        this.processDataprops(epo);
    }

    @Override
    public void doUpdated(Object oldObj, Object newObj, EditProcessObject epo) {
        this.processDataprops(epo);
    }

    @Override
    public void doDeleted(Object oldObj, EditProcessObject epo) {
    }

    private void processDataprops(EditProcessObject epo) {
        HashSet<String> deletedDataPropertyURIs = new HashSet<String>();
        Map<String, String[]> dpm = this.datapropParameterMap(epo.getRequestParameterMap());
        DataPropertyStatementDao dataPropertyStatementDao = (DataPropertyStatementDao)epo.getAdditionalDaoMap().get("DataPropertyStatement");
        for (String key : dpm.keySet()) {
            String[] data;
            for (String aData : data = dpm.get(key)) {
                String rangeDatatypeURI;
                String[] keyArg = key.split("_");
                String rowId = keyArg[2];
                DataPropertyStatementImpl dataPropertyStmt = new DataPropertyStatementImpl();
                if (rowId == null) {
                    dataPropertyStmt = new DataPropertyStatementImpl();
                }
                try {
                    Map<String, String> beanParamMap = FormUtils.beanParamMapFromString(keyArg[3]);
                    String dataPropertyURI = beanParamMap.get("DatatypePropertyURI");
                    if (!deletedDataPropertyURIs.contains(dataPropertyURI)) {
                        deletedDataPropertyURIs.add(dataPropertyURI);
                        dataPropertyStatementDao.deleteDataPropertyStatementsForIndividualByDataProperty(((Individual)epo.getNewBean()).getURI(), dataPropertyURI);
                    }
                    dataPropertyStmt.setDatapropURI(dataPropertyURI);
                }
                catch (Exception e) {
                    log.error((Object)"Messed up beanParamMap?");
                }
                dataPropertyStmt.setData(aData);
                Individual individual = null;
                if (((Individual)epo.getOriginalBean()).getURI() != null) {
                    individual = (Individual)epo.getOriginalBean();
                    dataPropertyStmt.setIndividualURI(individual.getURI());
                } else {
                    individual = (Individual)epo.getNewBean();
                    dataPropertyStmt.setIndividualURI(individual.getURI());
                }
                if (dataPropertyStmt.getData().length() <= 0 || rowId == null) continue;
                DataPropertyDao dataPropertyDao = (DataPropertyDao)epo.getAdditionalDaoMap().get("DataProperty");
                DataProperty dp = dataPropertyDao.getDataPropertyByURI(dataPropertyStmt.getDatapropURI());
                if (dp != null && (rangeDatatypeURI = dataPropertyDao.getRequiredDatatypeURI(individual, dp)) != null) {
                    dataPropertyStmt.setDatatypeURI(rangeDatatypeURI);
                    String validationMsg = BasicValidationVTwo.validateAgainstDatatype(dataPropertyStmt.getData(), rangeDatatypeURI);
                    if (validationMsg != null) {
                        validationMsg = "'" + dataPropertyStmt.getData() + "' is invalid. " + validationMsg;
                        throw new RuntimeException(validationMsg);
                    }
                }
                dataPropertyStatementDao.insertNewDataPropertyStatement(dataPropertyStmt);
            }
        }
    }

    private Map<String, String[]> datapropParameterMap(Map<String, String[]> requestParameterMap) {
        HashMap<String, String[]> dpm = new HashMap<String, String[]>();
        for (String key : requestParameterMap.keySet()) {
            if (!key.startsWith("_DataPropertyStatement")) continue;
            dpm.put(key, requestParameterMap.get(key));
        }
        return dpm;
    }
}

