/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BaseEditSubmissionPreprocessorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Literal;

public class ManageLabelsForIndividualPreprocessor
extends BaseEditSubmissionPreprocessorVTwo {
    public ManageLabelsForIndividualPreprocessor(EditConfigurationVTwo editConfig) {
        super(editConfig);
    }

    @Override
    public void preprocess(MultiValueEditSubmission inputSubmission, VitroRequest vreq) {
        if (inputSubmission.hasLiteralValue("label") && inputSubmission.hasLiteralValue("newLabelLanguage")) {
            Map<String, List<Literal>> literalsFromForm = inputSubmission.getLiteralsFromForm();
            List<Literal> newLabelLanguages = literalsFromForm.get("newLabelLanguage");
            List<Literal> labels = literalsFromForm.get("label");
            if (labels.size() > 0 && newLabelLanguages.size() > 0) {
                Literal newLabelLanguage = newLabelLanguages.get(0);
                Literal labelLiteral = labels.get(0);
                String lang = this.getLanguage(newLabelLanguage.getString());
                String label = labelLiteral.getString();
                Literal labelWithLanguage = inputSubmission.createLiteral(label, newLabelLanguage.getDatatypeURI(), lang);
                labels = new ArrayList<Literal>();
                labels.add(labelWithLanguage);
                literalsFromForm.put("label", labels);
                inputSubmission.setLiteralsFromForm(literalsFromForm);
            }
        }
    }

    protected String getLanguage(String inputLanguageCode) {
        if (inputLanguageCode.contains("_")) {
            return inputLanguageCode.replace("_", "-");
        }
        return inputLanguageCode;
    }
}

