/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.FilteredResultSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class LanguageFilteringRDFService
implements RDFService {
    private static final Log log = LogFactory.getLog(LanguageFilteringRDFService.class);
    private RDFService s;
    private List<String> langs;

    public LanguageFilteringRDFService(RDFService service, List<String> langs) {
        this.s = service;
        this.langs = this.normalizeLangs(langs);
    }

    private List<String> normalizeLangs(List<String> langs) {
        log.debug((Object)("Preferred languages:" + langs));
        ArrayList<String> normalizedLangs = new ArrayList<String>(langs);
        for (String lang : langs) {
            String baseLang = lang.split("-")[0];
            if (normalizedLangs.contains(baseLang)) continue;
            normalizedLangs.add(baseLang);
        }
        log.debug((Object)("Normalized languages:" + normalizedLangs));
        return normalizedLangs;
    }

    @Override
    public boolean changeSetUpdate(ChangeSet changeSet) throws RDFServiceException {
        return this.s.changeSetUpdate(changeSet);
    }

    @Override
    public void newIndividual(String individualURI, String individualTypeURI) throws RDFServiceException {
        this.s.newIndividual(individualURI, individualTypeURI);
    }

    @Override
    public void newIndividual(String individualURI, String individualTypeURI, String graphURI) throws RDFServiceException {
        this.s.newIndividual(individualURI, individualTypeURI, graphURI);
    }

    @Override
    public InputStream sparqlConstructQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model m = RDFServiceUtils.parseModel(this.s.sparqlConstructQuery(query, resultFormat), resultFormat);
        InputStream in = this.outputModel(this.filterModel(m), resultFormat);
        return in;
    }

    @Override
    public void sparqlConstructQuery(String query, Model model) throws RDFServiceException {
        if (model.isEmpty()) {
            this.s.sparqlConstructQuery(query, model);
            this.filterModel(model);
        } else {
            Model constructedModel = ModelFactory.createDefaultModel();
            this.s.sparqlConstructQuery(query, constructedModel);
            this.filterModel(constructedModel);
            model.add(constructedModel);
        }
    }

    @Override
    public InputStream sparqlDescribeQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        Model m = RDFServiceUtils.parseModel(this.s.sparqlDescribeQuery(query, resultFormat), resultFormat);
        return this.outputModel(this.filterModel(m), resultFormat);
    }

    private InputStream outputModel(Model m, RDFService.ModelSerializationFormat resultFormat) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.write((OutputStream)out, RDFServiceUtils.getSerializationFormatString(resultFormat));
        return new ByteArrayInputStream(out.toByteArray());
    }

    private Model filterModel(Model m) {
        log.debug((Object)"filterModel");
        ArrayList<Statement> retractions = new ArrayList<Statement>();
        StmtIterator stmtIt = m.listStatements();
        while (stmtIt.hasNext()) {
            List candidatesForRemoval;
            Statement stmt = stmtIt.nextStatement();
            if (!stmt.getObject().isLiteral() || (candidatesForRemoval = m.listStatements(stmt.getSubject(), stmt.getPredicate(), (RDFNode)null).toList()).size() == 1) continue;
            candidatesForRemoval.sort(new StatementSortByLang());
            log.debug((Object)("sorted statements: " + this.showSortedStatements(candidatesForRemoval)));
            Iterator candIt = candidatesForRemoval.iterator();
            String langRegister = null;
            boolean chuckRemaining = false;
            while (candIt.hasNext()) {
                Statement s = (Statement)candIt.next();
                if (!s.getObject().isLiteral()) continue;
                if (chuckRemaining) {
                    retractions.add(s);
                }
                String lang = s.getObject().asLiteral().getLanguage();
                if (langRegister == null) {
                    langRegister = lang;
                    continue;
                }
                if (langRegister.equals(lang)) continue;
                chuckRemaining = true;
                retractions.add(s);
            }
        }
        m.remove(retractions);
        return m;
    }

    private String showSortedStatements(List<Statement> candidatesForRemoval) {
        ArrayList<String> langStrings = new ArrayList<String>();
        for (Statement stmt : candidatesForRemoval) {
            if (stmt == null) {
                langStrings.add("null stmt");
                continue;
            }
            RDFNode node = stmt.getObject();
            if (!node.isLiteral()) {
                langStrings.add("not literal");
                continue;
            }
            langStrings.add(node.asLiteral().getLanguage());
        }
        return ((Object)langStrings).toString();
    }

    @Override
    public InputStream sparqlSelectQuery(String query, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        log.debug((Object)("sparqlSelectQuery: " + query.replaceAll("\\s+", " ")));
        ResultSet resultSet = ResultSetFactory.fromJSON((InputStream)this.s.sparqlSelectQuery(query, RDFService.ResultFormat.JSON));
        List<QuerySolution> solnList = this.getSolutionList(resultSet);
        List vars = resultSet.getResultVars();
        for (Object var : vars) {
            for (int i = 0; i < solnList.size(); ++i) {
                RDFNode node;
                QuerySolution s = solnList.get(i);
                if (s == null || (node = s.get((String)var)) == null || !node.isLiteral()) continue;
                ArrayList<RowIndexedLiteral> candidatesForRemoval = new ArrayList<RowIndexedLiteral>();
                candidatesForRemoval.add(new RowIndexedLiteral(node.asLiteral(), i));
                for (int j = i + 1; j < solnList.size(); ++j) {
                    QuerySolution t = solnList.get(j);
                    if (t == null || !this.matchesExceptForVar(s, t, (String)var, vars)) continue;
                    candidatesForRemoval.add(new RowIndexedLiteral(t.getLiteral((String)var), j));
                }
                if (candidatesForRemoval.size() == 1) continue;
                candidatesForRemoval.sort(new RowIndexedLiteralSortByLang());
                log.debug((Object)("sorted RowIndexedLiterals: " + this.showSortedRILs(candidatesForRemoval)));
                Iterator candIt = candidatesForRemoval.iterator();
                String langRegister = null;
                boolean chuckRemaining = false;
                while (candIt.hasNext()) {
                    RowIndexedLiteral rlit = (RowIndexedLiteral)candIt.next();
                    if (chuckRemaining) {
                        solnList.set(rlit.getIndex(), null);
                        continue;
                    }
                    if (langRegister == null) {
                        langRegister = rlit.getLiteral().getLanguage();
                        continue;
                    }
                    if (langRegister.equals(rlit.getLiteral().getLanguage())) continue;
                    chuckRemaining = true;
                    solnList.set(rlit.getIndex(), null);
                }
            }
        }
        ArrayList<QuerySolution> compactedList = new ArrayList<QuerySolution>();
        for (QuerySolution soln : solnList) {
            if (soln == null) continue;
            compactedList.add(soln);
        }
        FilteredResultSet filtered = new FilteredResultSet(compactedList, resultSet);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        switch (resultFormat) {
            case CSV: {
                ResultSetFormatter.outputAsCSV((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            case TEXT: {
                ResultSetFormatter.out((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            case JSON: {
                ResultSetFormatter.outputAsJSON((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            case XML: {
                ResultSetFormatter.outputAsXML((OutputStream)outputStream, (ResultSet)filtered);
                break;
            }
            default: {
                throw new RDFServiceException("unrecognized result format");
            }
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    @Override
    public void sparqlSelectQuery(String query, ResultSetConsumer consumer) throws RDFServiceException {
        log.debug((Object)("sparqlSelectQuery: " + query.replaceAll("\\s+", " ")));
        this.s.sparqlSelectQuery(query, new ResultSetConsumer.Chaining(consumer){
            List<String> vars;
            List<QuerySolution> solnList;
            {
                this.solnList = new ArrayList<QuerySolution>();
            }

            @Override
            protected void processQuerySolution(QuerySolution qs) {
                this.solnList.add(qs);
            }

            @Override
            protected void startProcessing() {
                this.vars = this.getResultVars();
            }

            @Override
            protected void endProcessing() {
                this.chainStartProcessing();
                for (String var : this.vars) {
                    for (int i = 0; i < this.solnList.size(); ++i) {
                        RDFNode node;
                        QuerySolution s = this.solnList.get(i);
                        if (s == null || (node = s.get(var)) == null || !node.isLiteral()) continue;
                        ArrayList<RowIndexedLiteral> candidatesForRemoval = new ArrayList<RowIndexedLiteral>();
                        candidatesForRemoval.add(new RowIndexedLiteral(node.asLiteral(), i));
                        for (int j = i + 1; j < this.solnList.size(); ++j) {
                            QuerySolution t = this.solnList.get(j);
                            if (t == null || !LanguageFilteringRDFService.this.matchesExceptForVar(s, t, var, this.vars)) continue;
                            candidatesForRemoval.add(new RowIndexedLiteral(t.getLiteral(var), j));
                        }
                        if (candidatesForRemoval.size() == 1) continue;
                        candidatesForRemoval.sort(new RowIndexedLiteralSortByLang());
                        log.debug((Object)("sorted RowIndexedLiterals: " + LanguageFilteringRDFService.this.showSortedRILs(candidatesForRemoval)));
                        Iterator candIt = candidatesForRemoval.iterator();
                        String langRegister = null;
                        boolean chuckRemaining = false;
                        while (candIt.hasNext()) {
                            RowIndexedLiteral rlit = (RowIndexedLiteral)candIt.next();
                            if (chuckRemaining) {
                                this.solnList.set(rlit.getIndex(), null);
                                continue;
                            }
                            if (langRegister == null) {
                                langRegister = rlit.getLiteral().getLanguage();
                                continue;
                            }
                            if (langRegister.equals(rlit.getLiteral().getLanguage())) continue;
                            chuckRemaining = true;
                            this.solnList.set(rlit.getIndex(), null);
                        }
                    }
                }
                for (QuerySolution soln : this.solnList) {
                    if (soln == null) continue;
                    this.chainProcessQuerySolution(soln);
                }
                this.chainEndProcessing();
            }
        });
    }

    private String showSortedRILs(List<RowIndexedLiteral> candidatesForRemoval) {
        ArrayList<String> langstrings = new ArrayList<String>();
        for (RowIndexedLiteral ril : candidatesForRemoval) {
            langstrings.add(ril.getLiteral().getLanguage());
        }
        return ((Object)langstrings).toString();
    }

    private boolean matchesExceptForVar(QuerySolution a, QuerySolution b, String varName, List<String> varList) {
        if (varName == null) {
            throw new RuntimeException("expected non-null variable nane");
        }
        for (String var : varList) {
            RDFNode nodea = a.get(var);
            RDFNode nodeb = b.get(var);
            if (var.equals(varName)) {
                if (nodea != null && nodea.isLiteral() && nodeb != null && nodeb.isLiteral()) continue;
                return false;
            }
            if (nodea == null && nodeb == null) continue;
            if (nodea == null && nodeb != null) {
                return false;
            }
            if (nodeb == null && nodea != null) {
                return false;
            }
            if (a.get(var).equals(b.get(var))) continue;
            return false;
        }
        return true;
    }

    private List<QuerySolution> getSolutionList(ResultSet resultSet) {
        ArrayList<QuerySolution> solnList = new ArrayList<QuerySolution>();
        while (resultSet.hasNext()) {
            QuerySolution soln = resultSet.nextSolution();
            solnList.add(soln);
        }
        return solnList;
    }

    @Override
    public boolean sparqlAskQuery(String query) throws RDFServiceException {
        return this.s.sparqlAskQuery(query);
    }

    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        return this.s.getGraphURIs();
    }

    @Override
    public void getGraphMetadata() throws RDFServiceException {
        this.s.getGraphMetadata();
    }

    @Override
    public String getDefaultWriteGraphURI() throws RDFServiceException {
        return this.s.getDefaultWriteGraphURI();
    }

    @Override
    public void serializeAll(OutputStream outputStream) throws RDFServiceException {
        this.s.serializeAll(outputStream);
    }

    @Override
    public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
        this.s.serializeGraph(graphURI, outputStream);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        return this.s.isEquivalentGraph(graphURI, serializedGraph, serializationFormat);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        return this.s.isEquivalentGraph(graphURI, graph);
    }

    @Override
    public void registerListener(ChangeListener changeListener) throws RDFServiceException {
        this.s.registerListener(changeListener);
    }

    @Override
    public void unregisterListener(ChangeListener changeListener) throws RDFServiceException {
        this.s.unregisterListener(changeListener);
    }

    @Override
    public void registerJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.s.registerJenaModelChangedListener(changeListener);
    }

    @Override
    public void unregisterJenaModelChangedListener(ModelChangedListener changeListener) throws RDFServiceException {
        this.s.unregisterJenaModelChangedListener(changeListener);
    }

    @Override
    public ChangeSet manufactureChangeSet() {
        return this.s.manufactureChangeSet();
    }

    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        return this.s.countTriples(subject, predicate, object);
    }

    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        return this.s.getTriples(subject, predicate, object, limit, offset);
    }

    @Override
    public boolean preferPreciseOptionals() {
        return this.s.preferPreciseOptionals();
    }

    @Override
    public void close() {
        this.s.close();
    }

    private class StatementSortByLang
    extends LangSort
    implements Comparator<Statement> {
        private StatementSortByLang() {
        }

        @Override
        public int compare(Statement s1, Statement s2) {
            if (s1 == null || s2 == null) {
                return 0;
            }
            if (!s1.getObject().isLiteral() || !s2.getObject().isLiteral()) {
                return 0;
            }
            String s1lang = s1.getObject().asLiteral().getLanguage();
            String s2lang = s2.getObject().asLiteral().getLanguage();
            return this.compareLangs(s1lang, s2lang);
        }
    }

    private class RowIndexedLiteralSortByLang
    extends LangSort
    implements Comparator<RowIndexedLiteral> {
        private RowIndexedLiteralSortByLang() {
        }

        @Override
        public int compare(RowIndexedLiteral rilit1, RowIndexedLiteral rilit2) {
            if (rilit1 == null || rilit2 == null) {
                return 0;
            }
            String t1lang = rilit1.getLiteral().getLanguage();
            String t2lang = rilit2.getLiteral().getLanguage();
            return this.compareLangs(t1lang, t2lang);
        }
    }

    private class LangSort {
        private int inexactMatchPenalty;
        private int noLanguage;
        private int noMatch;

        private LangSort() {
            this.inexactMatchPenalty = LanguageFilteringRDFService.this.langs.size();
            this.noLanguage = 2 * this.inexactMatchPenalty;
            this.noMatch = this.noLanguage + 1;
        }

        protected int compareLangs(String t1lang, String t2lang) {
            return this.languageIndex(t1lang) - this.languageIndex(t2lang);
        }

        private int languageIndex(String lang) {
            int index;
            if (lang == null) {
                lang = "";
            }
            if ((index = LanguageFilteringRDFService.this.langs.indexOf(lang)) >= 0) {
                log.debug((Object)("languageIndex for '" + lang + "' is " + index));
                return index;
            }
            if (lang.length() > 2 && (index = LanguageFilteringRDFService.this.langs.indexOf(lang.substring(0, 2))) >= 0) {
                log.debug((Object)("languageIndex for '" + lang + "' is " + index + this.inexactMatchPenalty));
                return index + this.inexactMatchPenalty;
            }
            if (lang.isEmpty()) {
                log.debug((Object)("languageIndex for '" + lang + "' is " + this.noLanguage));
                return this.noLanguage;
            }
            return this.noMatch;
        }
    }

    private class RowIndexedLiteral {
        private Literal literal;
        private int index;

        public RowIndexedLiteral(Literal literal, int index) {
            this.literal = literal;
            this.index = index;
        }

        public Literal getLiteral() {
            return this.literal;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

