/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging;

import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.logging.LoggingRDFService;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import edu.cornell.mannlib.vitro.webapp.utils.developer.loggers.StackTraceUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFServiceLogger
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(RDFServiceLogger.class);
    private final Object[] args;
    private final StackTraceUtility stackTrace;
    private boolean traceRequested;
    private Pattern queryStringRestriction;
    private Pattern callStackRestriction;
    private long startTime;

    private static boolean isEnabled() {
        return log.isInfoEnabled() && DeveloperSettings.getInstance().getBoolean(Key.LOGGING_RDF_ENABLE);
    }

    public RDFServiceLogger(Object ... args) {
        this.args = args;
        this.stackTrace = new StackTraceUtility(LoggingRDFService.class, RDFServiceLogger.isEnabled());
        try {
            this.getProperties();
            if (RDFServiceLogger.isEnabled() && this.passesQueryRestriction() && this.stackTrace.passesStackRestriction(this.callStackRestriction)) {
                this.startTime = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to create instance", (Throwable)e);
        }
    }

    private void getProperties() {
        DeveloperSettings settings = DeveloperSettings.getInstance();
        this.traceRequested = settings.getBoolean(Key.LOGGING_RDF_STACK_TRACE);
        this.queryStringRestriction = this.patternFromSettings(settings, Key.LOGGING_RDF_QUERY_RESTRICTION);
        this.callStackRestriction = this.patternFromSettings(settings, Key.LOGGING_RDF_STACK_RESTRICTION);
    }

    private Pattern patternFromSettings(DeveloperSettings settings, Key key) {
        String patternString = settings.getString(key);
        if (StringUtils.isBlank((CharSequence)patternString)) {
            return null;
        }
        try {
            return Pattern.compile(patternString);
        }
        catch (Exception e) {
            log.error((Object)("Failed to compile the pattern for " + (Object)((Object)key) + " = " + patternString + " " + e));
            return Pattern.compile("^_____NEVER MATCH_____$");
        }
    }

    private boolean passesQueryRestriction() {
        if (this.queryStringRestriction == null) {
            return true;
        }
        String q = this.assembleQueryString();
        return this.queryStringRestriction.matcher(q).find();
    }

    private String assembleQueryString() {
        ArrayList<String> stringArgs = new ArrayList<String>();
        for (Object arg : this.args) {
            if (!(arg instanceof String)) continue;
            stringArgs.add((String)arg);
        }
        return StringUtils.join(stringArgs, (String)" ");
    }

    @Override
    public void close() {
        try {
            if (this.startTime != 0L) {
                long endTime = System.currentTimeMillis();
                float elapsedSeconds = (float)(endTime - this.startTime) / 1000.0f;
                String cleanArgs = Arrays.deepToString(this.args).replaceAll("[\\n\\r\\t]+", " ");
                String formattedTrace = this.stackTrace.format(this.traceRequested);
                log.info((Object)String.format("%8.3f %s %s %s", Float.valueOf(elapsedSeconds), this.stackTrace.getMethodName(), cleanArgs, formattedTrace));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to write log record", (Throwable)e);
        }
    }
}

